/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.util;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.ClassPathResource;

public class DateTimeUtility {
    public static final DateFormat stdDateFmt = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
    public static final String formatFull = "yyyyMMddHHmmss.SSS";
    public static final String formatTZ = "Z";
    private static final String tzIndicators = "[-+]";
    private static Properties timezones = null;
    private static final Pattern iso8824_1987;
    private static final Pattern iso8601_1988;
    private static final int DATETIME_GROUP = 1;
    private static final int TIMEZONE_GROUP = 9;
    private static final int TZ_SIGN_GROUP = 10;
    private static final int TZ_HOUR_GROUP = 11;
    private static final int TZ_MINUTE_GROUP = 12;
    private static final int YEAR_PRECISION = 4;
    private static final int MONTH_PRECISION = 6;
    private static final int DAY_PRECISION = 8;
    private static final int HOUR_PRECISION = 10;
    private static final int MINUTE_PRECISION = 12;
    private static final int SECOND_PRECISION = 14;

    public static final String[] splitTimeZone(String strDate) {
        String[] dt = new String[]{strDate, "+0000"};
        Matcher matcher = iso8824_1987.matcher(strDate);
        if (matcher.matches()) {
            dt[0] = matcher.group(1);
            int last = matcher.end(9);
            if (strDate.length() == last) {
                dt[1] = matcher.group(9);
            }
        }
        return dt;
    }

    private static final String completeDateTime(String dttm) {
        StringBuilder complete = new StringBuilder(dttm);
        switch (dttm.length()) {
            case 4: {
                complete.append("12");
            }
            case 6: {
                Calendar cal = GregorianCalendar.getInstance();
                cal.set(2, Integer.parseInt(complete.substring(4)) - 1);
                complete.append(cal.getActualMaximum(5));
                complete.append("235959.999");
                break;
            }
            case 8: {
                complete.append("00");
            }
            case 10: {
                complete.append("00");
            }
            case 12: {
                complete.append("00");
            }
            case 14: {
                complete.append(".000");
            }
        }
        return complete.toString();
    }

    public static final TimeZone getTimezoneFor(String locationId, String defaultZone) {
        String zone = timezones.getProperty(locationId, defaultZone);
        return null != zone ? TimeZone.getTimeZone(zone) : null;
    }

    public static final String normalizeDateString(String strDate, String locationId) {
        if (null != strDate) {
            String[] dt_tz = DateTimeUtility.splitTimeZone(strDate);
            String dt = DateTimeUtility.completeDateTime(dt_tz[0]);
            TimeZone tZone = DateTimeUtility.getTimezoneFor(locationId, "GMT" + dt_tz[1]);
            int dtOutLength = Math.max(dt_tz[0].length(), 14);
            SimpleDateFormat dtIn = new SimpleDateFormat(formatFull);
            SimpleDateFormat dtOut = new SimpleDateFormat(formatFull.substring(0, dtOutLength) + formatTZ);
            dtIn.setTimeZone(tZone);
            dtOut.setTimeZone(tZone);
            Date d = ((DateFormat)dtIn).parse(dt, new ParsePosition(0));
            if (d != null) {
                strDate = dtOut.format(d);
            }
        }
        return strDate;
    }

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        return df.format(Calendar.getInstance().getTime());
    }

    public static boolean isDateOnly(String isoFormattedDate) {
        return isoFormattedDate.matches("\\d{8}(?:00{2,6}(?:\\.0{1,3})?)?(?:[-+]\\d{4})?");
    }

    public static String getISOTime(long milliseconds) {
        return DateTimeUtility.getISOTime(milliseconds, null);
    }

    public static String formatMDate(String isoDate) {
        if (isoDate != null && isoDate.length() >= 8) {
            isoDate = isoDate.split("-")[0];
            int isoYear = Integer.parseInt(isoDate.substring(0, 4)) - 1700;
            isoDate = isoYear + isoDate.substring(4);
        }
        return isoDate;
    }

    public static String getISOTime(long milliseconds, TimeZone timezone) {
        String format = "yyyyMMddHHmmss.SSSZ";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        if (null != timezone) {
            df.setTimeZone(timezone);
        }
        return df.format(new Date(milliseconds));
    }

    private static int contains(String str, String chars) {
        int idx = -1;
        String regex = new StringBuffer(".*[").append(chars).append("].*").toString();
        if (str.matches(regex)) {
            for (int i = 0; i < chars.length(); ++i) {
                idx = str.indexOf(chars.charAt(i));
                if (-1 == idx) continue;
                return idx;
            }
        }
        return idx;
    }

    public static long getMilliSecond(String isoTime) {
        SimpleDateFormat df;
        Date date;
        int tzOffset = DateTimeUtility.contains(isoTime, tzIndicators);
        String dateTime = 0 > tzOffset ? isoTime : isoTime.substring(0, tzOffset);
        StringBuffer format = new StringBuffer(formatFull.substring(0, dateTime.length()));
        if (-1 < tzOffset) {
            format.append(formatTZ);
        }
        if (null == (date = (df = new SimpleDateFormat(format.toString())).parse(isoTime, new ParsePosition(0)))) {
            throw new IllegalArgumentException("Invalid timeStr: " + isoTime);
        }
        return date.getTime();
    }

    public static boolean validateISOTime(String timeStamp) {
        Matcher match;
        int tsLength = timeStamp.length();
        if (23 >= tsLength && 4 <= tsLength && (match = iso8824_1987.matcher(timeStamp)).matches()) {
            TimeZone tz = null;
            String strTZ = match.group(9);
            if ("-0000".equals(strTZ)) {
                timeStamp = timeStamp.replace('-', '+');
            }
            if (null != strTZ) {
                tz = TimeZone.getTimeZone("GMT" + strTZ);
            }
            String ts = DateTimeUtility.getISOTime(DateTimeUtility.getMilliSecond(timeStamp), tz);
            if (null != strTZ) {
                int tzOffset = DateTimeUtility.contains(timeStamp, tzIndicators);
                int tstzOff = DateTimeUtility.contains(ts, tzIndicators);
                ts = ts.substring(0, tzOffset) + ts.substring(tstzOff);
            } else {
                ts = ts.substring(0, timeStamp.length());
            }
            return ts.equals(timeStamp);
        }
        return false;
    }

    public static String convertISOTimeFormat(String oldISO) {
        Matcher match = iso8601_1988.matcher(oldISO);
        if (!match.matches()) {
            throw new IllegalArgumentException("Invalid ISO 8601-1988 time format: " + oldISO);
        }
        String dateTime = match.group(1);
        String tzone = match.group(10) + match.group(11) + match.group(12);
        SimpleDateFormat dfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        if (null != tzone) {
            String tzoneStr = "GMT" + (formatTZ.equals(tzone) ? "+0000" : tzone);
            dfIn.setTimeZone(TimeZone.getTimeZone(tzoneStr));
        }
        Date dt = ((DateFormat)dfIn).parse(dateTime, new ParsePosition(0));
        SimpleDateFormat dfOut = new SimpleDateFormat(formatFull + (null != tzone ? formatTZ : ""));
        String outDate = dfOut.format(dt);
        return outDate;
    }

    public static String formatDBTime(String oTime) {
        String nTime;
        try {
            nTime = DateTimeUtility.convertISOTimeFormat(oTime);
        }
        catch (Exception e) {
            nTime = DateTimeUtility.getISOTime(DateTimeUtility.getMilliSecond(oTime));
        }
        nTime = nTime.substring(0, 14);
        return nTime;
    }

    public static String formatDBLongTime(String oTime) throws Exception {
        String nTime;
        try {
            nTime = DateTimeUtility.convertISOTimeFormat(oTime);
        }
        catch (Exception e) {
            nTime = DateTimeUtility.getISOTime(DateTimeUtility.getMilliSecond(oTime));
        }
        nTime = nTime.substring(0, 14) + nTime.substring(15, 18);
        return nTime.toString();
    }

    public static String formatTimeStamp(String oTime) {
        StringBuffer nTime = new StringBuffer(oTime.substring(0, 14));
        if (oTime.length() > 14) {
            nTime.append(".").append(oTime.substring(14));
        } else {
            nTime.append(".000");
        }
        String ct = DateTimeUtility.getCurrentTime();
        nTime.append(ct.substring(ct.length() - 5));
        return nTime.toString();
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("\tDateTimeUtility -d YYYYMMDDHH24MISS.SSS[-0500]  or");
        System.out.println("\tDateTimeUtility -t 1051765200000");
    }

    public static String formatISODate(String aDate, String aFormat) {
        int timeZoneIndex = -1;
        int zIndex = -1;
        String dateSansTimeZone = aDate;
        String inputFormat = "yyyy";
        String timeZone = "+0000";
        String formatSansTimeZone = aFormat;
        try {
            int dateLength;
            timeZoneIndex = aDate.indexOf(45);
            if (timeZoneIndex != -1 || (timeZoneIndex = aDate.indexOf(43)) != -1) {
                timeZone = aDate.substring(timeZoneIndex);
                dateSansTimeZone = aDate.substring(0, timeZoneIndex);
            }
            if ((dateLength = dateSansTimeZone.length()) > 4) {
                inputFormat = aDate.indexOf(46) != -1 ? formatFull : formatFull.substring(0, dateLength);
            }
            if ((zIndex = aFormat.indexOf(formatTZ)) != -1) {
                formatSansTimeZone = aFormat.substring(0, zIndex);
            }
            SimpleDateFormat dfInput = new SimpleDateFormat(inputFormat);
            SimpleDateFormat dfOutput = new SimpleDateFormat(formatSansTimeZone);
            dfInput.setLenient(false);
            dfOutput.setLenient(false);
            Date date = dfInput.parse(dateSansTimeZone);
            aDate = dfOutput.format(date);
            if (zIndex != -1) {
                aDate = aDate + timeZone;
            }
        }
        catch (Exception e) {
            IMSException.getIMSException("An error occurred while formatting the date: " + aDate, e);
        }
        return aDate;
    }

    public static Double isoTime2Double(String isoDate) {
        Double retVal;
        if (isoDate != null && isoDate.length() >= 4) {
            int dateMaxIndex = (isoDate = isoDate.split("-")[0].split("\\.")[0]).length() >= 8 ? 8 : isoDate.length();
            String datePart = isoDate.substring(0, dateMaxIndex) + "0000".substring(0, 8 - dateMaxIndex);
            String timePart = isoDate.length() > dateMaxIndex ? isoDate.substring(dateMaxIndex) : "0";
            datePart = Integer.parseInt(datePart.substring(0, 4)) - 1700 + datePart.substring(4);
            retVal = new Double(datePart + "." + timePart);
        } else {
            retVal = new Double(0.0);
        }
        return retVal;
    }

    public static String double2ISOTime(Double d) {
        StringBuffer sbISOTime = new StringBuffer();
        if (d != null) {
            String sd = d.toString();
            String[] parts = sd.split("\\.");
            if (parts.length == 2 && parts[0].length() == 7) {
                sbISOTime.append(Integer.parseInt(parts[0].substring(0, 3)) + 1700);
                int month = Integer.parseInt(parts[0].substring(3, 5));
                int day = Integer.parseInt(parts[0].substring(5, 7));
                if (month > 0) {
                    if (month < 10) {
                        sbISOTime.append("0");
                    }
                    sbISOTime.append(month);
                    if (day > 0) {
                        if (day < 10) {
                            sbISOTime.append("0");
                        }
                        sbISOTime.append(day);
                        if (Integer.parseInt(parts[1]) > 0) {
                            sbISOTime.append(parts[1]);
                            if (parts[1].length() == 1 || parts[1].length() == 3 || parts[1].length() == 5) {
                                sbISOTime.append("0");
                            }
                        }
                    }
                }
            } else {
                sbISOTime.append("0");
            }
        } else {
            sbISOTime.append("0");
        }
        return sbISOTime.toString();
    }

    public static void main(String[] args) {
        System.out.println("null = " + DateTimeUtility.isoTime2Double(null));
        System.out.println("0 = " + DateTimeUtility.isoTime2Double("0"));
        System.out.println("2006 = " + DateTimeUtility.isoTime2Double("2006"));
        System.out.println("200601 = " + DateTimeUtility.isoTime2Double("200601"));
        System.out.println("20060101 = " + DateTimeUtility.isoTime2Double("20060101"));
        System.out.println("2006010112 = " + DateTimeUtility.isoTime2Double("2006010112"));
        System.out.println("200601011225 = " + DateTimeUtility.isoTime2Double("200601011225"));
        System.out.println("20060101122552 = " + DateTimeUtility.isoTime2Double("20060101122552"));
        System.out.println("20060101122552.000 = " + DateTimeUtility.isoTime2Double("20060101122552.000"));
        System.out.println("20060101122552.000-700 = " + DateTimeUtility.isoTime2Double("20060101122552.000-700"));
        System.out.println("null = " + DateTimeUtility.double2ISOTime(null));
        System.out.println("0.0 = " + DateTimeUtility.double2ISOTime(new Double(0.0)));
        System.out.println("3060000.0 = " + DateTimeUtility.double2ISOTime(new Double(3060000.0)));
        System.out.println("3060100.0 = " + DateTimeUtility.double2ISOTime(new Double(3060100.0)));
        System.out.println("3060101.0 = " + DateTimeUtility.double2ISOTime(new Double(3060101.0)));
        System.out.println("3060101.1 = " + DateTimeUtility.double2ISOTime(new Double(3060101.1)));
        System.out.println("3060101.12 = " + DateTimeUtility.double2ISOTime(new Double(3060101.12)));
        System.out.println("3060101.122 = " + DateTimeUtility.double2ISOTime(new Double(3060101.122)));
        System.out.println("3060101.1225 = " + DateTimeUtility.double2ISOTime(new Double(3060101.1225)));
        System.out.println("3060101.12255 = " + DateTimeUtility.double2ISOTime(new Double(3060101.12255)));
        System.out.println("3060101.122552 = " + DateTimeUtility.double2ISOTime(new Double(3060101.122552)));
    }

    static {
        try {
            timezones = new Properties();
            timezones.load(new ClassPathResource("gov/va/med/hds/hdr/config/vista.tz").getInputStream());
        }
        catch (FileNotFoundException e) {
            IMSException.getIMSException("Missing file: vista.tz", e);
        }
        catch (IOException e) {
            IMSException.getIMSException("Unable to access vista.tz", e);
        }
        catch (Exception e) {
            IMSException.getIMSException("Exception loading vista.tz file", e);
        }
        iso8824_1987 = Pattern.compile("^((\\d{4})(?:(?<=\\d{4})(\\d{2})(?:(?<=\\d{6})(\\d{2})(?:(?<=\\d{8})(\\d{2})(?:(?<=\\d{10})(\\d{2})(?:(?<=\\d{12})(\\d{2})(?:\\.(\\d{1,3}))?)?)?)?)?)?)(([-+])(\\d{2})(?<=\\d{2})(\\d{2}))?$");
        iso8601_1988 = Pattern.compile("((\\d{4})-(\\d{2})-(\\d{2})(?:T(\\d{2}):(\\d{2})(?::(\\d{2})(?:\\.(\\d{1,3}))??)??)??)(([-+])(\\d{2}):(\\d{2})|Z)??");
    }
}

