/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.util;

import java.beans.BeanInfo;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class BeanHelper {
    public static final String TYPE_GETTER = "get";
    public static final String TYPE_SETTER = "set";
    private static final String NL = System.getProperty("line.separator");
    private static final Class[] primitiveTypes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, CharSequence.class, Date.class};
    private static ThreadLocal<List<Object>> tl = new ThreadLocal();

    public static final boolean isPrimitive(Class clazz) {
        boolean primitive = clazz.isPrimitive();
        if (!primitive) {
            for (int i = 0; i < primitiveTypes.length && !(primitive = primitiveTypes[i].isAssignableFrom(clazz)); ++i) {
            }
        }
        return primitive;
    }

    public static Method findMethod(PropertyDescriptor pd, String type, Class enclosingClass) {
        String propertyName = pd.getName();
        String methodName = type + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method method = null;
        try {
            Class[] classArray;
            if (TYPE_GETTER.equals(type)) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = pd.getPropertyType();
            }
            method = enclosingClass.getDeclaredMethod(methodName, classArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != method) {
            method.setAccessible(true);
        }
        return method;
    }

    public static void addNewValue(Object value, PropertyDescriptor pd, Object obj) throws Exception {
        try {
            String adder = BeanHelper.getAdderMethodName(pd, obj.getClass());
            new Statement(obj, adder, new Object[]{value}).execute();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unable to find adder method for property: " + pd.getName() + " Class: " + obj.getClass().getName());
        }
    }

    public static void setNewValue(Object value, PropertyDescriptor pd, Object obj) throws Exception {
        Class<?> enclosingClass = obj.getClass();
        String setterName = BeanHelper.getSetterMethodName(pd, enclosingClass);
        if (null != setterName) {
            new Statement(obj, setterName, new Object[]{value}).execute();
        } else {
            Field property = BeanHelper.getPropertyField(obj, pd.getName());
            if (null != property) {
                property.set(obj, value);
            }
        }
    }

    public static Class getActualClass(Object obj) {
        return obj instanceof HibernateProxy ? ((HibernateProxy)obj).getHibernateLazyInitializer().getPersistentClass() : (obj instanceof LazyInitializer ? ((LazyInitializer)obj).getPersistentClass() : obj.getClass());
    }

    public static PropertyDescriptor getProperty(Object obj, String name) {
        try {
            PropertyDescriptor[] properties = BeanHelper.getProperties(obj);
            for (int i = 0; i < properties.length; ++i) {
                if (!properties[i].getName().equals(name)) continue;
                return properties[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static PropertyDescriptor[] getProperties(Object obj) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(BeanHelper.getActualClass(obj), Object.class);
        return bi.getPropertyDescriptors();
    }

    public static String getGetterMethodName(PropertyDescriptor pd, Class enclosingClass) {
        Method getterMethod = pd.getReadMethod();
        if (null == getterMethod) {
            getterMethod = BeanHelper.findMethod(pd, TYPE_GETTER, enclosingClass);
        }
        String getterMethodName = null != getterMethod ? getterMethod.getName() : null;
        return getterMethodName;
    }

    public static String getSetterMethodName(PropertyDescriptor pd, Class enclosingClass) {
        Method setterMethod = pd.getWriteMethod();
        if (null == setterMethod) {
            setterMethod = BeanHelper.findMethod(pd, TYPE_SETTER, enclosingClass);
        }
        String setterMethodName = null != setterMethod ? setterMethod.getName() : null;
        return setterMethodName;
    }

    private static String getAdderMethodName(PropertyDescriptor pd, Class enclosingClass) {
        String adderMethodName = null;
        String propertyName = pd.getName();
        propertyName = propertyName.substring(0, propertyName.length() - 1);
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        adderMethodName = "add" + propertyName;
        return adderMethodName;
    }

    public static Field getPropertyField(Object obj, String propertyName) throws Exception {
        Class<?> enclosingClass = obj.getClass();
        Field property = enclosingClass.getDeclaredField(propertyName);
        do {
            if (null != property) {
                property.setAccessible(true);
                return property;
            }
            enclosingClass = enclosingClass.getSuperclass();
        } while (null == property && !enclosingClass.getName().equals(Object.class.getName()));
        return null;
    }

    public static Object getPropertyValue(PropertyDescriptor pd, Object obj) {
        String getterMethod = BeanHelper.getGetterMethodName(pd, BeanHelper.getActualClass(obj));
        if (null != getterMethod) {
            try {
                return new Expression(obj, getterMethod, null).getValue();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Field field = BeanHelper.getPropertyField(obj, pd.getName());
            return field.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int objectHashCode(Class objClass, Object[] objs) {
        int hashCode = BeanHelper.nameHash(objClass.getName());
        for (int i = 0; i < objs.length; ++i) {
            hashCode += null == objs[i] ? System.identityHashCode(null) : objs[i].hashCode();
        }
        return hashCode;
    }

    public static String objectToString(Object obj) {
        List<Object> visited = tl.get();
        if (null == visited) {
            visited = new ArrayList<Object>();
            tl.set(visited);
            visited.add(new Integer(0));
        }
        StringBuffer indent = new StringBuffer();
        int depth = (Integer)visited.remove(0) + 1;
        visited.add(0, new Integer(depth));
        for (int j = 0; j < depth; ++j) {
            indent.append(" ");
        }
        String name = obj.getClass().getName();
        StringBuffer sb = new StringBuffer(indent.toString()).append(name.substring(name.lastIndexOf(".") + 1)).append("(@").append(System.identityHashCode(obj)).append(")");
        if (!(obj instanceof Collection) && !visited.contains(obj)) {
            visited.add(obj);
            sb.append("[");
            try {
                PropertyDescriptor[] properties = BeanHelper.getProperties(obj);
                for (int i = 0; i < properties.length; ++i) {
                    sb.append(indent).append(properties[i].getName()).append(":").append(new Expression(obj, BeanHelper.getGetterMethodName(properties[i], obj.getClass()), null).getValue()).append(NL);
                }
            }
            catch (Exception e) {
                sb.append("Exception: ").append(e.getLocalizedMessage());
            }
            sb.append("]");
        }
        if (0 == --depth) {
            visited.clear();
            visited.add(new Integer(0));
        } else {
            visited.add(0, new Integer(depth));
        }
        return sb.append(NL).toString();
    }

    public static final boolean isNull(Object newVal) {
        if (null != newVal) {
            if (BeanHelper.isPrimitive(newVal.getClass())) {
                return false;
            }
            try {
                PropertyDescriptor[] properties = BeanHelper.getProperties(newVal);
                for (int i = 0; i < properties.length; ++i) {
                    if (!BeanHelper.mergeField(BeanHelper.getPropertyValue(properties[i], newVal))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static final boolean mergeField(Object newVal) {
        if (null == newVal) {
            return false;
        }
        if (newVal instanceof Collection) {
            return 0 < ((Collection)newVal).size();
        }
        if (newVal instanceof CharSequence) {
            return 0 < ((CharSequence)newVal).length();
        }
        if (!(newVal instanceof Number)) {
            return !BeanHelper.isNull(newVal);
        }
        return true;
    }

    public static final int nameHash(String className) {
        int hashCode = className.length();
        char[] chars = className.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            hashCode += chars[i];
        }
        return hashCode;
    }
}

