/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.properties;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyParseException;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.springframework.core.io.ClassPathResource;

public class PropertyMgr {
    public static final String PROPERTIES_FILENAME = "fhie_properties.xml";
    public static final String PROPERTIES_ROOT = "/properties/node";
    public static final String ID = "id";
    public static final String DOMAIN = "domain";
    public static final String ATTRIBUTE_SELECTOR = "@";
    public static final String ELEMENT_CHILD_PATH = "child::*";
    public static final String DEFAULT = "default";
    public static final String APP_NODE = "app_node_key";
    private static Document doc = null;
    private static Hashtable<String, PropertyMgr> managers = new Hashtable();
    public URL fileURL;
    private Element searchNode = null;
    private String fileName = "fhie_properties.xml";
    private Map<String, Object> propCache = null;
    private String navPath = null;

    public PropertyMgr(String filename, String rootXPath) throws PropertyParseException {
        if (filename == null) {
            throw new PropertyParseException(4, "file name is null");
        }
        if (rootXPath == null) {
            throw new PropertyParseException(8, "root path is null");
        }
        this.fileName = filename;
        this.navPath = rootXPath;
        this.init(rootXPath);
    }

    public PropertyMgr(String rootXPath) throws PropertyParseException {
        if (rootXPath == null) {
            throw new PropertyParseException(8, "root path is null");
        }
        this.navPath = rootXPath;
        this.init(rootXPath);
    }

    public static void addManager(String name, PropertyMgr pm) {
        if (name != null) {
            managers.put(name.toLowerCase(), pm);
        }
    }

    public static PropertyMgr getInstance() {
        return PropertyMgr.getInstance(null, null, null);
    }

    public static PropertyMgr getInstance(String pmName) {
        return PropertyMgr.getInstance(pmName, null, null);
    }

    public static PropertyMgr getInstance(String pmName, String root) {
        return PropertyMgr.getInstance(pmName, root, null);
    }

    public static PropertyMgr getInstance(String pmName, String root, String file) {
        PropertyMgr pm = managers.get(pmName = pmName == null ? (pmName = DEFAULT) : pmName.toLowerCase());
        if (null == pm) {
            pm = new PropertyMgr(null != file ? file : PROPERTIES_FILENAME, null != root ? root : PROPERTIES_ROOT);
            PropertyMgr.addManager(pmName, pm);
        }
        return pm;
    }

    public PropertyElement getProperty(String xpath) {
        return this.getProperty(xpath, this.searchNode, "");
    }

    public PropertyElement getProperty(String xpath, PropertyElement parent) {
        return this.getProperty(xpath, parent.getElement(), parent.getKey());
    }

    public PropertyElement getProperty(String xpath, Element parent, String parentkey) {
        String key;
        PropertyElement pe = null;
        if (null != parent && (pe = (PropertyElement)this.propCache.get(key = parent.getName() + "/" + parentkey + "/" + xpath)) == null) {
            Node o = parent.selectSingleNode(xpath);
            pe = o != null ? new PropertyElement(o) : new PropertyElement();
            this.propCache.put(key, pe);
        }
        return pe;
    }

    public PropertyElement[] getProperties(String xPath, Element parent, String parentkey) {
        String key = parent.getName() + "/" + parentkey + "/" + xPath;
        PropertyElement[] pe = (PropertyElement[])this.propCache.get(key);
        if (pe == null) {
            List nodes = parent.selectNodes(xPath);
            pe = new PropertyElement[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                pe[i] = new PropertyElement(nodes.get(i));
            }
        }
        return pe;
    }

    public PropertyElement[] getProperties(String xPath, PropertyElement parent) {
        return this.getProperties(xPath, parent.getElement(), parent.getKey());
    }

    public PropertyElement[] getProperties(String xPath) {
        return this.getProperties(xPath, this.searchNode, "");
    }

    public synchronized void setProperty(String xpath, String value) {
        PropertyElement pe = null;
        pe = new PropertyElement(this.searchNode.selectSingleNode(xpath));
        pe.setValue(value);
    }

    public void save() {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(this.fileURL.getPath()), format);
            writer.write(doc);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(String filename) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(this.fileName), format);
            writer.write(doc);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String createAttrSelector(String key, String value) {
        StringBuffer buf = new StringBuffer("[@" + key + "=\"" + value + "\"]");
        return buf.toString();
    }

    public void fileChanged(String filename) {
        if (this.fileName.equals(filename)) {
            this.init(this.navPath);
        }
    }

    protected void init(String xPath) {
        try {
            SAXReader reader;
            Node node;
            this.propCache = new Hashtable<String, Object>();
            this.fileURL = new ClassPathResource(this.fileName).getURL();
            if (null != this.fileURL && (node = (doc = (reader = new SAXReader()).read(this.fileURL)).getRootElement().selectSingleNode(xPath)) instanceof Element) {
                this.searchNode = (Element)node;
            }
        }
        catch (Exception ex) {
            throw new PropertyParseException(ex.toString());
        }
    }

    private static void printUsage() {
        System.out.println("java gov.fhie.common.properties.PropertyMgr <options>");
        System.out.println("    where options are:");
        System.out.println();
        System.out.println("    -f   Property filename.");
        System.out.println("    -h   Displays this message.");
        System.out.println("    -i   Run in interactive mode.");
        System.out.println("    -r   Set the root path, default is \"//properties\".");
        System.out.println("    -val Validate XML file against Schema and print status.");
    }

    public void readInput() {
        try {
            System.out.println("Running the property manager in interactive mode.");
            System.out.println("     Enter x to exit program.");
            while (true) {
                PropertyElement pe;
                System.out.print("Enter the path > ");
                DataInputStream dataIn = new DataInputStream(System.in);
                BufferedReader in = new BufferedReader(new InputStreamReader(dataIn));
                String input = in.readLine();
                if (input.equalsIgnoreCase("x") || input.equalsIgnoreCase("exit")) {
                    System.exit(0);
                }
                if ((pe = this.getProperty(input)) != null) {
                    System.out.println("The property " + pe.getNodeName() + " = " + pe.getValue());
                    continue;
                }
                System.out.println("Could not find the path: " + input);
            }
        }
        catch (IOException ex) {
            System.err.println("Can't read from `" + ex.getMessage() + "'");
            System.exit(1);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] argv) {
        try {
            String rootPath = "//properties";
            boolean validate = false;
            boolean interactive = false;
            String filename = PROPERTIES_FILENAME;
            if (argv.length > 0) {
                for (int i = 0; i < argv.length; ++i) {
                    if ("-h".equalsIgnoreCase(argv[i])) {
                        PropertyMgr.printUsage();
                        System.exit(0);
                        continue;
                    }
                    if ("-r".equalsIgnoreCase(argv[i])) {
                        rootPath = argv[++i];
                        continue;
                    }
                    if ("-f".equalsIgnoreCase(argv[i])) {
                        filename = argv[++i];
                        continue;
                    }
                    if ("-val".equalsIgnoreCase(argv[i])) {
                        validate = true;
                        continue;
                    }
                    if (!"-i".equalsIgnoreCase(argv[i])) continue;
                    interactive = true;
                }
            }
            PropertyMgr pm = new PropertyMgr(filename, rootPath);
            if (interactive) {
                pm.readInput();
                return;
            }
            if (!validate) return;
        }
        catch (Exception ex) {
            PropertyMgr.printUsage();
            System.err.println("The filename is incorrect.");
            System.exit(1);
        }
    }
}

