/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.properties;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class PropertyElement {
    private static final int ATTRIBUTE = 0;
    private static final int ELEMENT = 1;
    private int type = -1;
    private Object wrapped;
    private String propKey = null;

    public PropertyElement() {
        this.wrapped = null;
    }

    public boolean isEmpty() {
        return null == this.wrapped;
    }

    public PropertyElement(Object o) {
        if (o instanceof Element) {
            this.type = 1;
            this.wrapped = o;
        } else if (o instanceof Attribute) {
            this.type = 0;
            this.wrapped = o;
        }
    }

    public Element getElement() {
        return this.type == 1 ? (Element)this.wrapped : null;
    }

    public String getValue() {
        String value = null;
        switch (this.type) {
            case 1: {
                value = ((Element)this.wrapped).getText();
                break;
            }
            case 0: {
                value = ((Attribute)this.wrapped).getValue();
                break;
            }
        }
        return value;
    }

    public void setValue(String value) {
        switch (this.type) {
            case 1: {
                ((Element)this.wrapped).setText(value);
                break;
            }
            case 0: {
                ((Attribute)this.wrapped).setValue(value);
                break;
            }
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public PropertyElement[] getChildProperties() {
        Vector<PropertyElement> children = new Vector<PropertyElement>();
        if (this.wrapped != null && this.type == 1) {
            Iterator iter = ((Element)this.wrapped).elementIterator();
            while (iter.hasNext()) {
                children.add(new PropertyElement(iter.next()));
            }
        }
        return children.toArray(new PropertyElement[children.size()]);
    }

    public PropertyElement[] getChildProperties(String name) {
        Vector<PropertyElement> children = new Vector<PropertyElement>();
        if (this.wrapped != null && this.type == 1) {
            Iterator iter = ((Element)this.wrapped).elementIterator(name);
            while (iter.hasNext()) {
                children.add(new PropertyElement(iter.next()));
            }
        }
        return children.toArray(new PropertyElement[children.size()]);
    }

    public String getAttribute(String name) {
        String value = null;
        switch (this.type) {
            case 1: {
                value = ((Element)this.wrapped).attribute(name).getValue();
                break;
            }
            case 0: {
                Attribute a = (Attribute)this.wrapped;
                if (!a.getName().equals(name)) break;
                value = a.getValue();
                break;
            }
        }
        return value;
    }

    public void setAttribute(String name, String value) {
        switch (this.type) {
            case 1: {
                ((Element)this.wrapped).addAttribute(name, value);
                break;
            }
            case 0: {
                Attribute a = (Attribute)this.wrapped;
                if (!a.getName().equals(name)) break;
                a.setValue(value);
                break;
            }
        }
    }

    public List getAttributes() {
        List l = null;
        if (this.wrapped != null && this.type == 1) {
            l = ((Element)this.wrapped).attributes();
        }
        return l;
    }

    public String getNodeName() {
        String nodeName = null;
        switch (this.type) {
            case 1: {
                nodeName = ((Element)this.wrapped).getName();
                break;
            }
            case 0: {
                nodeName = ((Attribute)this.wrapped).getName();
                break;
            }
        }
        return nodeName;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasAttribute(String name) {
        return this.wrapped != null && this.type == 1 && ((Element)this.wrapped).attribute(name) != null;
    }

    public boolean hasAttributes() {
        return this.wrapped != null && this.type == 1 && ((Element)this.wrapped).attributes().size() > 0;
    }

    public void setKey(String key) {
        this.propKey = key;
    }

    public String getKey() {
        return this.propKey;
    }
}

