/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.logger;

import java.io.Serializable;
import java.text.MessageFormat;

public class ErrorCode
implements Serializable {
    private static final long serialVersionUID = 6390756464334908336L;
    private final String errorCode;
    private final String severity;
    private String message;
    private String[] defaultParams = new String[]{"", "", "", "", "", "", ""};
    private static final String FATAL_ERROR = "01";
    private static final String SEVERE_ERROR = "02";
    private static final String MAJOR_ERROR = "03";
    private static final String MINOR_ERROR = "04";
    private static final String WARN_ERROR = "05";
    public static final ErrorCode UNCL_000 = new ErrorCode("00.03.000", "Unexpected Unclassified exception: {0}.", "03");
    public static final ErrorCode UNCL_001 = new ErrorCode("00.01.001", "Initialized Interceptors failed.", "01");
    public static final ErrorCode UNCL_003 = new ErrorCode("00.02.003", "MessageLoaderException: {0}", "02");
    public static final ErrorCode UNCL_005 = new ErrorCode("00.03.005", "AccessDecision Object Exception {0}", "03");
    public static final ErrorCode UNCL_007 = new ErrorCode("00.05.007", "Transformer shutdown error: {0} ({1}).", "05");
    public static final ErrorCode UNCL_009 = new ErrorCode("00.05.009", "Thread {0} terminated during parse of {1}.", "05");
    public static final ErrorCode UNCL_011 = new ErrorCode("00.03.011", "Unable to send e-mail.", "03");
    public static final ErrorCode UNCL_013 = new ErrorCode("00.03.013", "Illegal Argument on call to {0}({1}).", "03");
    public static final ErrorCode UNCL_015 = new ErrorCode("00.01.015", "MessageDigest - No Algorithm Found \"SHA-1\"", "01");
    public static final ErrorCode GENM_000 = new ErrorCode("01.03.000", "Unexpected General Message exception: {0}.", "03");
    public static final ErrorCode GENM_001 = new ErrorCode("01.03.001", "Exception caught at {0}: {1}", "03");
    public static final ErrorCode GENM_003 = new ErrorCode("01.02.003", "Cannot Access the HL7 File Processing Directory, {0}. Check directory access permissions.", "02");
    public static final ErrorCode GENM_005 = new ErrorCode("01.02.005", "Problem encountered while processing files", "02");
    public static final ErrorCode GENM_007 = new ErrorCode("01.02.007", "Exception Occurred While removing file ID: {0}", "02");
    public static final ErrorCode GENM_009 = new ErrorCode("01.03.009", "Exception loading properties for FileHandler", "03");
    public static final ErrorCode GENM_011 = new ErrorCode("01.03.011", "FileHandlerMgr sleep is interrupted.", "03");
    public static final ErrorCode GENM_013 = new ErrorCode("01.03.013", "Error occurred during shutdown process", "03");
    public static final ErrorCode GENM_015 = new ErrorCode("01.03.015", "fileKey not found", "03");
    public static final ErrorCode GENM_017 = new ErrorCode("01.03.017", "Exception occurred while refreshing HL7 Threads", "03");
    public static final ErrorCode GENM_019 = new ErrorCode("01.03.019", "Problem during examination of tracking file.", "03");
    public static final ErrorCode GENM_021 = new ErrorCode("01.03.021", "FAILED To Renamed File: {0} to: {1}.", "03");
    public static final ErrorCode GENM_023 = new ErrorCode("01.03.023", "Security problem encountered while attempting to move processed file {0}.", "03");
    public static final ErrorCode GENM_025 = new ErrorCode("01.03.025", "Error occurred {0} at {1}", "03");
    public static final ErrorCode GENM_027 = new ErrorCode("01.03.027", "Unable to deleted tracking file: {0}", "03");
    public static final ErrorCode GENM_029 = new ErrorCode("01.05.029", "No value found in field {0} #={1} map={2}", "05");
    public static final ErrorCode GENM_031 = new ErrorCode("01.05.031", "Unable to process the message:\n{0}.", "05");
    public static final ErrorCode GENM_033 = new ErrorCode("01.03.033", "Exception when calling {0}: {1}.", "03");
    public static final ErrorCode HL7M_000 = new ErrorCode("02.03.000", "Unexpected HL7 exception: {0}.", "03");
    public static final ErrorCode HL7M_003 = new ErrorCode("02.03.003", "HL7RepositoryException caught - {0}.", "03");
    public static final ErrorCode HL7M_009 = new ErrorCode("02.03.009", "Invalid {0} parameter.", "03");
    public static final ErrorCode HL7M_011 = new ErrorCode("02.03.011", "Unable to send application ack for:\n {0}.", "03");
    public static final ErrorCode HL7M_013 = new ErrorCode("02.03.013", "Expected CA not received.\n{0}", "03");
    public static final ErrorCode HL7M_015 = new ErrorCode("02.03.015", "CA received for the incorrect message.  Control id expected: {0};Control id received: {1}.", "03");
    public static final ErrorCode OTHM_000 = new ErrorCode("04.03.000", "Unexpected Other Message exception: {0}.", "03");
    public static final ErrorCode OTHM_001 = new ErrorCode("04.03.001", "{0} caught when calling {1}.", "03");
    public static final ErrorCode OTHM_003 = new ErrorCode("04.03.003", "The {0} record {1} at facility {2} with encounter date {3} in file {4} is an exact duplicate of an existing record", "03");
    public static final ErrorCode OTHM_005 = new ErrorCode("04.03.005", "Error in {0}RepositoryWrapper.insertRecord on record number {0} in file {1}.", "03");
    public static final ErrorCode OTHM_007 = new ErrorCode("04.04.007", "Incorrect number of fields: {0} in file {1}.", "04");
    public static final ErrorCode OTHM_009 = new ErrorCode("04.03.009", "Cannot handle potential duplicate record {0} at facility {1} with encounter date {2} in file {3}.", "03");
    public static final ErrorCode OTHM_011 = new ErrorCode("04.03.011", "Problem encountered finding duplicate {0} messages.", "03");
    public static final ErrorCode GRPH_000 = new ErrorCode("05.03.000", "Unexpected Graph exception: {0}.", "03");
    public static final ErrorCode GRPH_001 = new ErrorCode("05.01.001", "Cannot initialize GraphCollectionMgr.", "01");
    public static final ErrorCode GRPH_003 = new ErrorCode("05.03.003", "An error occured while loading mapping file ''{0}''.", "03");
    public static final ErrorCode GRPH_005 = new ErrorCode("05.03.005", "An error occured while doing mapping for node ''{0}'' with value ''{1}''.", "03");
    public static final ErrorCode GRPH_007 = new ErrorCode("05.03.007", "An error occured while doing mapping for node ''{0}''.", "03");
    public static final ErrorCode GRPH_009 = new ErrorCode("05.05.009", "The GraphCollectionCORBAFacade delegate generated an application exception.", "05");
    public static final ErrorCode GRPH_011 = new ErrorCode("05.05.011", "CorrelationMgrImpl trying addGraphs call with parameters: {0}, SubCollectionType.PERSON, {1}, \"PARENT\", true", "05");
    public static final ErrorCode GRPH_013 = new ErrorCode("05.05.013", "Wrong policy for {0}", "05");
    public static final ErrorCode GRPH_015 = new ErrorCode("05.03.015", "Problem encountered during getGraph operation at {0} domain.", "03");
    public static final ErrorCode GRPH_017 = new ErrorCode("05.03.017", "Problem converting vector of graphs to array.", "03");
    public static final ErrorCode GRPH_019 = new ErrorCode("05.05.019", "Unable to create GraphCollection: {1}.", "05");
    public static final ErrorCode GRPH_021 = new ErrorCode("05.05.021", "Unable to add edge to graph.", "05");
    public static final ErrorCode GRPH_023 = new ErrorCode("05.05.023", "Skipping Privacy checking.", "05");
    public static final ErrorCode CLIN_000 = new ErrorCode("06.03.000", "Unexpected Clinical Graph exception: {0}", "03");
    public static final ErrorCode CLIN_001 = new ErrorCode("06.05.001", "Problem inserting field to DomainValue\n{0}", "05");
    public static final ErrorCode CLIN_003 = new ErrorCode("06.05.003", "Could not create Domain value: {0}", "05");
    public static final ErrorCode CLIN_005 = new ErrorCode("06.03.005", "Unable to convert message to graph: type {0} not converted/processed.", "03");
    public static final ErrorCode CLIN_007 = new ErrorCode("06.03.007", "Unable to convert message to graph: message control ID={0}, facility ID={1}, database clinical ID={2}, template name={3}.", "03");
    public static final ErrorCode CLIN_009 = new ErrorCode("06.03.009", "Unable to convert {0} message to graph: message type={1}, clinical date={2}, record number={3}.", "03");
    public static final ErrorCode CLIN_011 = new ErrorCode("06.03.011", "clinicalId is null during de-duplication:\n{0}", "03");
    public static final ErrorCode CLIN_013 = new ErrorCode("06.05.013", "Access to record is not allowed.", "05");
    public static final ErrorCode CLIN_015 = new ErrorCode("06.05.015", "Qualifier is not allowed.", "05");
    public static final ErrorCode PRSN_000 = new ErrorCode("07.03.000", "Unexpected Person Graph exception: {0}.", "03");
    public static final ErrorCode PRSN_001 = new ErrorCode("07.05.001", "Merge on domain {0} unable to perform corresponding move on parent domain.  This is likely because one of the IDs was not found at the parent domain.  That is not an error", "05");
    public static final ErrorCode PRSN_003 = new ErrorCode("07.03.003", "No Patient ID on getNext method", "03");
    public static final ErrorCode PRSN_005 = new ErrorCode("07.03.005", "An error occured while creating the graph.", "03");
    public static final ErrorCode PRSN_007 = new ErrorCode("07.03.007", "Correlated ID must be an int.", "03");
    public static final ErrorCode CRBA_000 = new ErrorCode("08.03.000", "Unexpected CORBA exception: {0}.", "03");
    public static final ErrorCode CRBA_001 = new ErrorCode("08.01.001", "InvalidName: RootPOA.", "01");
    public static final ErrorCode CRBA_003 = new ErrorCode("08.01.003", "Cannot activate the root POA manager.", "01");
    public static final ErrorCode CRBA_005 = new ErrorCode("08.04.005", "Cannot deactivate object", "04");
    public static final ErrorCode CRBA_007 = new ErrorCode("08.04.007", "GraphCollectionMgrCORBAProxy is null: target domain: {0}", "04");
    public static final ErrorCode CRBA_009 = new ErrorCode("08.04.009", "Exception occurred shutting down POAs.", "04");
    public static final ErrorCode CRBA_011 = new ErrorCode("08.02.011", "Unable to initialize the POA: Invalid Name.", "02");
    public static final ErrorCode CRBA_013 = new ErrorCode("08.02.013", "POA Object Not Active.", "02");
    public static final ErrorCode CRBA_015 = new ErrorCode("08.02.015", "POA Object Adapter Nonexistent.", "02");
    public static final ErrorCode CRBA_017 = new ErrorCode("08.02.017", "''NameService'' is a nil object reference.", "02");
    public static final ErrorCode CRBA_019 = new ErrorCode("08.02.019", "NameService initialization failure: {0} ({1}).", "02");
    public static final ErrorCode CRBA_021 = new ErrorCode("08.01.021", "Exception creating CORBA services.", "01");
    public static final ErrorCode CRBA_023 = new ErrorCode("08.02.023", "Orb is null.", "02");
    public static final ErrorCode CRBA_025 = new ErrorCode("08.02.025", "Unable to start Session POA: {0}.", "02");
    public static final ErrorCode CRBA_027 = new ErrorCode("08.01.027", "Network Failure.", "01");
    public static final ErrorCode CRBA_029 = new ErrorCode("08.02.029", "Naming Context is null.", "02");
    public static final ErrorCode PIDS_000 = new ErrorCode("09.03.000", "Unexpected PIDS exception: {0}", "03");
    public static final ErrorCode PIDS_001 = new ErrorCode("09.01.001", "Cannot create PIDS services", "01");
    public static final ErrorCode PIDS_003 = new ErrorCode("09.01.003", "Unexpected error occurred creating PIDS services", "01");
    public static final ErrorCode PIDS_005 = new ErrorCode("09.01.005", "Cannot create Captive PIDS services", "01");
    public static final ErrorCode PIDS_007 = new ErrorCode("09.01.007", "Unexpected error occurred creating Captive PIDS services", "01");
    public static final ErrorCode PIDS_009 = new ErrorCode("09.01.009", "Profile {0}: {1}\n", "01");
    public static final ErrorCode PIDS_011 = new ErrorCode("09.02.011", "An unrecoverable error was encountered while correlating the patient.\nDomain: {0}\nMessage: {1}\nReason: {2}", "02");
    public static final ErrorCode PIDS_013 = new ErrorCode("09.02.013", "An error was encountered while correlating the patient.", "02");
    public static final ErrorCode PIDS_015 = new ErrorCode("09.02.015", "Patient correlation has failed five times in a row.\nPutting patient correlation thread to sleep for five minutes.", "02");
    public static final ErrorCode PIDS_017 = new ErrorCode("09.03.017", "Error unmerging ID: {0} => {1}.", "03");
    public static final ErrorCode PIDS_019 = new ErrorCode("09.03.019", "MergeStruct {0}: DeprecatedID = {1}, PreferredID = {2}\n", "03");
    public static final ErrorCode PIDS_021 = new ErrorCode("09.03.021", "Problem encountered with the PersonGraphCollection.mergeGraphs", "03");
    public static final ErrorCode PIDS_023 = new ErrorCode("09.03.023", "Error deprecating ID: {0}.", "03");
    public static final ErrorCode PIDS_025 = new ErrorCode("09.03.025", "Error merging IDs: {0} => {1}.", "03");
    public static final ErrorCode PIDS_027 = new ErrorCode("09.03.027", "ids_to_unmerge {0} = {1}\n ", "03");
    public static final ErrorCode PIDS_029 = new ErrorCode("09.03.029", "ID is null: {0}({1}).", "03");
    public static final ErrorCode PIDS_031 = new ErrorCode("09.03.031", "Exception calling getSessionId() in Framework PIDS IdMgrImpl.", "03");
    public static final ErrorCode PIDS_033 = new ErrorCode("09.03.033", "Failed to locate VA IdentifyPerson IOR in the naming service.", "03");
    public static final ErrorCode COAS_000 = new ErrorCode("10.03.000", "Unexpected COAS exception {0}.", "03");
    public static final ErrorCode COAS_001 = new ErrorCode("10.03.001", "Exception {0}: {1}.", "03");
    public static final ErrorCode COAS_003 = new ErrorCode("10.04.003", "IGraphCollection (collection) is null.", "04");
    public static final ErrorCode COAS_005 = new ErrorCode("10.03.005", "Unable to convert Graph[{0}] to ObservationDataStruct ({1}).", "03");
    public static final ErrorCode COAS_007 = new ErrorCode("10.05.007", "Could not start COAS service.", "05");
    public static final ErrorCode ADT_000 = new ErrorCode("11.03.000", "Unexpected ADT exception: {0}.", "03");
    public static final ErrorCode ADT_001 = new ErrorCode("11.01.001", "MergeStruct {0}: DeprecatedID = {1}, PreferredID = {2}\n", "01");
    public static final ErrorCode ADT_003 = new ErrorCode("11.03.003", "SSN not found on first pass, this message will not be processed.", "03");
    public static final ErrorCode ADT_005 = new ErrorCode("11.03.005", "Problem communicating with VA SSN dump filename={0} ssn={1}.", "03");
    public static final ErrorCode ADT_007 = new ErrorCode("11.03.007", "Problem adding patient identifier domain={0}, id={1} to identifier list.", "03");
    public static final ErrorCode ADT_009 = new ErrorCode("11.03.009", "Problem getting patient data. XPath={0}", "03");
    public static final ErrorCode ADT_011 = new ErrorCode("11.03.011", "Unable to set patient data.", "03");
    public static final ErrorCode ADT_013 = new ErrorCode("11.05.013", "Duplicate link request:\n{0}.", "05");
    public static final ErrorCode ADT_015 = new ErrorCode("11.05.015", "Unlink Warning:  \n{0}.", "05");
    public static final ErrorCode ADT_017 = new ErrorCode("11.05.017", "Exception correlating patient: {0}\n{1}.", "03");
    public static final ErrorCode SESN_000 = new ErrorCode("13.03.000", "Unexpected Session exception: {0}.", "03");
    public static final ErrorCode SESN_001 = new ErrorCode("13.01.001", "Cannot initialize local session service.", "01");
    public static final ErrorCode SESN_003 = new ErrorCode("13.01.003", "Cannot get properties for SessionModes.", "01");
    public static final ErrorCode SESN_005 = new ErrorCode("13.03.005", "Invalid session state: {0}.", "03");
    public static final ErrorCode SESN_007 = new ErrorCode("13.03.007", "Cannot load maximum session policy", "03");
    public static final ErrorCode SESN_009 = new ErrorCode("13.03.009", "Missing/Invalid {0} ({1}).", "03");
    public static final ErrorCode SESN_011 = new ErrorCode("13.03.011", "Failed loading {0} values.", "03");
    public static final ErrorCode SESN_013 = new ErrorCode("13.04.013", "Maximum number of sessions reached.", "04");
    public static final ErrorCode SESN_015 = new ErrorCode("13.05.015", "Unable to instantiate the All_SessionsImpl instance.", "05");
    public static final ErrorCode SESN_017 = new ErrorCode("13.05.017", "Cannot remove {0} from LogProbeManager on shutdown.", "05");
    public static final ErrorCode SESN_019 = new ErrorCode("13.05.019", "Failed to end session", "05");
    public static final ErrorCode SESN_021 = new ErrorCode("13.05.021", "Root POA is not available.", "05");
    public static final ErrorCode SESN_023 = new ErrorCode("13.05.023", "Error in post invoke", "05");
    public static final ErrorCode SESN_025 = new ErrorCode("13.05.025", "SessionMemoryManager not Available", "05");
    public static final ErrorCode SESN_029 = new ErrorCode("13.03.029", "Failed to create session ID: {0}", "03");
    public static final ErrorCode SESN_031 = new ErrorCode("13.03.031", "Failed to start Session: {0} {1}", "03");
    public static final ErrorCode JMS_000 = new ErrorCode("14.03.000", "JMS exception: {0}.", "03");
    public static final ErrorCode JMS_001 = new ErrorCode("14.01.001", "Problem disconnecting from JMS.", "05");
    public static final ErrorCode JMS_002 = new ErrorCode("14.03.002", "Message receipt error.", "03");
    public static final ErrorCode JMS_003 = new ErrorCode("14.03.003", "There is a problem with the JMS connection.", "03");
    public static final ErrorCode JMS_004 = new ErrorCode("14.02.004", "Cannot setup transformer JMS listeners.", "02");
    public static final ErrorCode JMS_005 = new ErrorCode("14.02.005", "JMSException: {0}", "02");
    public static final ErrorCode JMS_006 = new ErrorCode("14.03.006", "Cannot Receive Framework Messages.", "03");
    public static final ErrorCode JMS_008 = new ErrorCode("14.05.008", "Error creating log session.", "05");
    public static final ErrorCode JMS_009 = new ErrorCode("14.05.009", "Cannot remove All_Sessions from LogProbeManager on shutdown.", "05");
    public static final ErrorCode JMS_010 = new ErrorCode("14.05.010", "Exception removing {1}.", "05");
    public static final ErrorCode JMS_011 = new ErrorCode("14.02.011", "JMS message retrieval exception({0}): {1}", "02");
    public static final ErrorCode JMS_013 = new ErrorCode("14.03.013", "JMS initialization error: {1}", "03");
    public static final ErrorCode JMS_015 = new ErrorCode("14.05.015", "JMS message loader received exception from JMS sub-system.", "05");
    public static final ErrorCode JMS_017 = new ErrorCode("14.05.017", "JMS could not re-establish a connection to the JMS sub-system.", "05");
    public static final ErrorCode JMS_019 = new ErrorCode("14.05.019", "An error was encountered while releasing JMS resources.", "05");
    public static final ErrorCode JMS_021 = new ErrorCode("14.05.021", "Redelivered message failed. Retry count: {0}", "05");
    public static final ErrorCode TERM_000 = new ErrorCode("15.03.000", "Unexpected Mediation exception: {0}.", "03");
    public static final ErrorCode TERM_001 = new ErrorCode("15.04.001", "No TerminologyService for domain {0}", "04");
    public static final ErrorCode TERM_003 = new ErrorCode("15.04.003", "Invalid template ''{0}'' AuthorityID: {1}", "04");
    public static final ErrorCode TERM_005 = new ErrorCode("15.04.005", "Invalid source CodingSchemeID {0} in {1}_{2}_{3}", "04");
    public static final ErrorCode TERM_007 = new ErrorCode("15.04.007", "Invalid source CodedElement code {0} in {1} for {2}_{3}_{4}", "04");
    public static final ErrorCode TERM_009 = new ErrorCode("15.04.009", "Invalid Mediation for {0} in {1} for {2}_{3}_{4}", "04");
    public static final ErrorCode TERM_011 = new ErrorCode("15.04.011", "Invalid CodingSchemeID {0} for {1}_{2}_{3}", "04");
    public static final ErrorCode TERM_013 = new ErrorCode("15.04.013", "No PreferredText defined in TS for {0} in {1}_{2}_{3}_{4}", "04");
    public static final ErrorCode TERM_015 = new ErrorCode("15.05.015", "Invalid CodedElement code {0} for {1}_{2}_{3}_{4}.", "05");
    public static final ErrorCode TERM_019 = new ErrorCode("15.05.019", "No vocabulary Domain for {0} to mediate in template {1}.", "05");
    public static final ErrorCode TERM_021 = new ErrorCode("15.05.021", "No such {0} mediating graph {1} csID={2}.", "05");
    public static final ErrorCode BTCH_000 = new ErrorCode("16.03.000", "Unexpected Batch exception: {0}.", "03");
    public static final ErrorCode BTCH_001 = new ErrorCode("16.04.001", "Shutdown interrupted", "04");
    public static final ErrorCode BTCH_003 = new ErrorCode("16.04.003", "Exception reading property {0} in refreshHL7Threads().", "04");
    public static final ErrorCode BTCH_005 = new ErrorCode("16.03.005", "Problem with {0}FileReader run loop.", "03");
    public static final ErrorCode BTCH_007 = new ErrorCode("16.03.007", "Error processing file: {0}", "03");
    public static final ErrorCode BTCH_009 = new ErrorCode("16.03.009", "Error processing message\n{0}\nFrom File - {1}.", "03");
    public static final ErrorCode BTCH_011 = new ErrorCode("16.03.011", "File name starts with ''0,0,'': {1}.", "03");
    public static final ErrorCode BTCH_013 = new ErrorCode("16.03.013", "File not found: {0}.", "03");
    public static final ErrorCode BTCH_015 = new ErrorCode("16.03.015", "File starts with ''No data found'': {0}.", "03");
    public static final ErrorCode BTCH_017 = new ErrorCode("16.03.017", "Found bad char at line #{0}.", "03");
    public static final ErrorCode BTCH_019 = new ErrorCode("16.03.019", "Encountered unexpected {0} of block character on line {1} of file {2}.", "03");
    public static final ErrorCode BTCH_021 = new ErrorCode("16.03.021", "Problem encountered pulling duplicates.", "03");
    public static final ErrorCode BTCH_023 = new ErrorCode("16.05.023", "Exception while closing: {1}.", "05");
    public static final ErrorCode BTCH_025 = new ErrorCode("16.03.025", "File ended while system was still expecting another end of block character. File may be truncated: {0}.", "03");
    public static final ErrorCode BTCH_027 = new ErrorCode("16.03.027", "IO problem while scanning file: {0}", "03");
    public static final ErrorCode BTCH_029 = new ErrorCode("16.03.029", "Execption caught while freeing HL7 Threads: {0}", "03");
    public static final ErrorCode BTCH_031 = new ErrorCode("16.03.031", "File {0} appears to be truncated", "03");
    public static final ErrorCode JDBC_000 = new ErrorCode("17.03.000", "Unexpected JDBC exception: {0}.", "03");
    public static final ErrorCode JDBC_001 = new ErrorCode("17.03.001", "SQLException caught when saving statistics data", "03");
    public static final ErrorCode JDBC_003 = new ErrorCode("17.03.003", "SQLException caught when {0} endProcessTime", "03");
    public static final ErrorCode JDBC_005 = new ErrorCode("17.03.005", "Exception caught releasing connection to pool", "03");
    public static final ErrorCode JDBC_007 = new ErrorCode("17.03.007", "No DBConnection available", "03");
    public static final ErrorCode JDBC_009 = new ErrorCode("17.03.009", "Can''t release DBConnection", "03");
    public static final ErrorCode JDBC_011 = new ErrorCode("17.05.011", "Can''t close file reader.", "05");
    public static final ErrorCode JDBC_013 = new ErrorCode("17.03.013", "SQLException caught when saving statistics data.", "03");
    public static final ErrorCode JDBC_015 = new ErrorCode("17.03.015", "SQLException caught when save endProcessTime.", "03");
    public static final ErrorCode JDBC_017 = new ErrorCode("17.03.017", "SQLException caught when populating ProcessTime", "03");
    public static final ErrorCode JDBC_019 = new ErrorCode("17.03.019", "SQLException when calling {0}. {1}", "03");
    public static final ErrorCode JDBC_021 = new ErrorCode("17.03.021", "IOException in {0} storing CLOB: {1}.", "03");
    public static final ErrorCode JDBC_023 = new ErrorCode("17.03.023", "Exception getting datasource connection {0} from pool.", "03");
    public static final ErrorCode JDBC_025 = new ErrorCode("17.03.025", "Can''t get the resultSet for facility={0},msgId={1} when read for update to store the clob\n{2}.", "03");
    public static final ErrorCode JDBC_027 = new ErrorCode("17.03.027", "Can''t get the message from the {0} result set.", "03");
    public static final ErrorCode JDBC_029 = new ErrorCode("17.02.029", "Rollback failed.", "02");
    public static final ErrorCode JDBC_031 = new ErrorCode("17.05.031", "SQLException: Unique Constraint Violation (Duplicate message):\n{0}.", "05");
    public static final ErrorCode CMPI_000 = new ErrorCode("18.03.000", "Unexpected Correlation exception: {0}.", "03");
    public static final ErrorCode CMPI_001 = new ErrorCode("18.03.001", "Exception caught when adding patient id to DoD MPI.", "03");
    public static final ErrorCode CMPI_003 = new ErrorCode("18.03.003", "MPI STUB Exception: {0}.", "03");
    public static final ErrorCode SRVR_000 = new ErrorCode("20.03.000", "Unexpected RPC processing exception. The entry point '{0}' is not configured within the application.", "03");
    public static final ErrorCode SRVR_001 = new ErrorCode("20.03.001", "Unexpected error while trying to start server named '{0}'.", "03");
    public static final ErrorCode SRVR_003 = new ErrorCode("20.03.003", "An error occurred while reading request message: WhatCode: {0}; MessageControlID: {1}; SendingApplication: {2}; ReceivingApplication: {3}.", "03");
    public static final ErrorCode SRVR_004 = new ErrorCode("20.03.004", "An error occurred creating command: WhatCode: {0}; MessageControlID: {1}; SendingApplication: {2}; ReceivingApplication: {3}.", "03");
    public static final ErrorCode SRVR_005 = new ErrorCode("20.03.005", "An error occurred executing command: WhatCode: {0}; MessageControlID: {1}; SendingApplication: {2}; ReceivingApplication: {3}.", "03");
    public static final ErrorCode SRVR_006 = new ErrorCode("20.03.006", "An error occurred processing response: WhatCode: {0}; MessageControlID: {1}; SendingApplication: {2}; ReceivingApplication: {3}.", "03");
    public static final ErrorCode SRVR_007 = new ErrorCode("20.03.007", "One or more errors occurred collecting patient observations: {0}.", "03");

    public ErrorCode(String id, String msg, String severity) {
        this.errorCode = null != id ? id : "00.00.001";
        this.message = null != msg ? msg : "UNCLASSIFIED: Unknown Exception occurred.";
        this.severity = null != severity ? severity : "0";
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getSeverity() {
        return this.severity;
    }

    public final ErrorCode createError(String msg, String[] params) {
        if (null != params) {
            System.arraycopy(params, 0, this.defaultParams, 0, params.length);
        }
        ErrorCode error = (ErrorCode)this.clone();
        if (null != msg) {
            error.setMessage(msg);
        }
        error.setMessage(MessageFormat.format(error.getMessage(), this.defaultParams));
        return error;
    }

    public final ErrorCode createError(String[] params) {
        return this.createError(null, params);
    }

    public Object clone() {
        return new ErrorCode(this.errorCode, this.message, this.severity);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ErrorCode)) {
            return false;
        }
        ErrorCode error = (ErrorCode)obj;
        if (!super.equals(obj)) {
            return this.errorCode.equals(error.getErrorCode());
        }
        return true;
    }

    public String toString() {
        return new StringBuffer(this.severity).append(": ").append(this.message).append("; error code: ").append(this.errorCode).toString();
    }
}

