/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7.parser;

import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.AbstractEscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.DelimiterEscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.EscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserListener;
import gov.va.med.hds.hdr.hl7.parser.HexEscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class HL7MessageParser {
    private static final int DELIMETERS_FIELD_INDEX = 2;
    private static final int M_SEGMENT_TYPE_FIELD = 1;
    private static final int M_PROCESSING_FIELD = 2;
    private static final int M_PROCESSING_COMPONENT = 4;
    private static final int M_PROCESSING_SUBCOMPONENT = 8;
    private static final int M_PROCESSING_ESCSEQUENCE = 16;
    protected String message = null;
    private StringBuffer escapedText = null;
    private int stateMask = 0;
    private StringBuffer currentSegmentName = null;
    private HL7MessageParserEvent event = null;
    private StringBuffer currentFieldText = null;
    private int fieldIndex = 0;
    private int repeatCount = 0;
    private StringBuffer currentComponentText = null;
    private int componentIndex = 0;
    private StringBuffer currentSubcomponentText = null;
    private int subcomponentIndex = 0;
    private List<HL7MessageParserListener> parserEventListeners = null;
    private HL7MessageInfo messageInfo = null;
    private char[] buff = null;
    private int i = 0;
    private Map<Pattern, EscapeSequenceHandler> escSeqHandlers = null;
    private final EscapeSequenceHandler defaultEscHandler;
    private final String escapePattern = "^\\{0}(?:[HNFSTRE]|X(?:[0-9a-fA-F]{2})+|Z.+|\\.(?:br|fi|nf|ce)|\\.(?:sp|in|ti|sk)[+-]?\\d*)\\{0}.*";
    private Pattern escapeSeq;

    public HL7MessageParser(String message) throws MessageParserException {
        this.setMessage(message, new HL7MessageInfoImpl(message));
        this.defaultEscHandler = new DefaultEscapeHandler(this.messageInfo);
    }

    public HL7MessageParser(String message, HL7MessageInfo messageInfo) throws MessageParserException {
        this.setMessage(message, messageInfo);
        this.defaultEscHandler = new DefaultEscapeHandler(messageInfo);
    }

    private void initialize() {
        this.i = 0;
        this.stateMask = 0;
        this.repeatCount = 0;
        this.fieldIndex = 0;
        this.componentIndex = 0;
        this.subcomponentIndex = 0;
        this.buff = null;
        this.message = null;
        this.messageInfo = null;
        this.escapedText = new StringBuffer();
        this.event = new HL7MessageParserEvent(this);
        this.currentSegmentName = new StringBuffer();
        this.currentFieldText = new StringBuffer();
        this.currentComponentText = new StringBuffer();
        this.currentSubcomponentText = new StringBuffer();
        this.parserEventListeners = new ArrayList<HL7MessageParserListener>();
        this.escSeqHandlers = new Hashtable<Pattern, EscapeSequenceHandler>();
    }

    /*
     * Unable to fully structure code
     */
    public void parseMessage() throws MessageParserException {
        this.buff = this.message.toCharArray();
        this.setMask(1);
        this.i = 0;
        while (this.i < this.buff.length) {
            block18: {
                block19: {
                    block17: {
                        if (!this.isFieldDelimeter(this.buff[this.i]) || !this.isMasked(1)) break block17;
                        this.fireBeginSegmentEvent();
                        break block18;
                    }
                    if (this.isMasked(1)) {
                        this.currentSegmentName.append(this.buff[this.i]);
                    }
                    if (!this.isEndSegment(this.buff[this.i])) break block19;
                    this.fireEndSegmentEvent();
                    break block18;
                }
                delimitersField = this.isDelimetersField();
                if (delimitersField || !this.isEscapeCharacter(this.buff[this.i])) ** GOTO lbl-1000
                escCandidate = new String(this.buff, this.i, this.buff.length - this.i);
                if (this.isMasked(16) || this.isEscapeSequence(StringHelper.split(escCandidate, HL7MessageInfo.LINE_DELIMETER)[0])) {
                    this.onEscapeCharacter();
                } else if (this.isMasked(16)) {
                    this.escapedText.append(this.buff[this.i]);
                } else if (this.isFieldDelimeter(this.buff[this.i])) {
                    this.fireEndFieldEvent();
                    this.fireBeginFieldEvent();
                } else if (!delimitersField && this.isRepetitionSeparator(this.buff[this.i])) {
                    this.fireRepeatingFieldEvent();
                } else {
                    if (this.isMasked(2)) {
                        this.currentFieldText.append(this.buff[this.i]);
                    }
                    if (!delimitersField && this.isComponentSeparator(this.buff[this.i])) {
                        this.fireEndComponentEvent();
                        this.fireBeginComponentEvent();
                    } else {
                        if (this.isMasked(4)) {
                            this.currentComponentText.append(this.buff[this.i]);
                        }
                        if (!delimitersField && this.isSubcomponentSeparator(this.buff[this.i])) {
                            this.fireEndSubcomponentEvent();
                            this.fireBeginSubcomponentEvent();
                        } else if (this.isMasked(8)) {
                            this.currentSubcomponentText.append(this.buff[this.i]);
                        }
                    }
                }
            }
            ++this.i;
        }
    }

    private boolean isEscapeSequence(String buff) {
        if (null == this.escapeSeq) {
            String escPat = MessageFormat.format("^\\{0}(?:[HNFSTRE]|X(?:[0-9a-fA-F]{2})+|Z.+|\\.(?:br|fi|nf|ce)|\\.(?:sp|in|ti|sk)[+-]?\\d*)\\{0}.*", this.messageInfo.getEscapeCharacter());
            this.escapeSeq = Pattern.compile(escPat, 32);
        }
        return this.escapeSeq.matcher(buff).matches();
    }

    public String getCurrentField() {
        StringBuffer fieldText = new StringBuffer(this.currentFieldText.toString());
        if (!(this.isFieldDelimeter(this.buff[this.i]) || this.isEndSegment(this.buff[this.i]) || this.isRepetitionSeparator(this.buff[this.i]))) {
            int buffIdx = this.i + 1;
            while (!(this.isFieldDelimeter(this.buff[buffIdx]) || this.isEndSegment(this.buff[buffIdx]) || this.isRepetitionSeparator(this.buff[buffIdx]))) {
                fieldText.append(this.buff[buffIdx]);
                ++buffIdx;
            }
        }
        return fieldText.toString();
    }

    public String getCurrentSegment() {
        int endIdx;
        String segment = null;
        int beginIdx = this.i;
        if (!this.isEndSegment(this.buff[endIdx])) {
            for (endIdx = this.i; endIdx < this.buff.length; ++endIdx) {
                if (!this.isEndSegment(this.buff[endIdx])) continue;
                --endIdx;
                break;
            }
        }
        while (beginIdx > 0) {
            if (this.isEndSegment(this.buff[beginIdx])) {
                ++beginIdx;
                break;
            }
            --beginIdx;
        }
        segment = this.message.substring(beginIdx, endIdx);
        return segment;
    }

    private boolean isFieldDelimeter(char c) {
        return this.messageInfo.getFieldDelimeter().charAt(0) == c;
    }

    private boolean isRepetitionSeparator(char c) {
        return this.messageInfo.getRepetitionSeparator().charAt(0) == c;
    }

    private boolean isComponentSeparator(char c) {
        return this.messageInfo.getComponentSeparator().charAt(0) == c;
    }

    private boolean isSubcomponentSeparator(char c) {
        return this.messageInfo.getSubcomponentSeparator().charAt(0) == c;
    }

    private boolean isMessageHeaderSegment() {
        return "MSH".equals(this.currentSegmentName.toString());
    }

    public void addEscapeSequenceHandler(EscapeSequenceHandler esh) {
        this.escSeqHandlers.put(Pattern.compile(esh.getSequenceType()), esh);
    }

    private EscapeSequenceHandler getEscapeSequenceHandler(String escSeq) {
        Set<Map.Entry<Pattern, EscapeSequenceHandler>> keyValSet = this.escSeqHandlers.entrySet();
        for (Map.Entry<Pattern, EscapeSequenceHandler> handler : keyValSet) {
            if (!handler.getKey().matcher(escSeq).matches()) continue;
            return handler.getValue();
        }
        return null;
    }

    private void onEscapeCharacter() {
        if (this.escSeqHandlers.isEmpty()) {
            this.addEscapeSequenceHandler(new DelimiterEscapeSequenceHandler(this.messageInfo));
            this.addEscapeSequenceHandler(new HexEscapeSequenceHandler(this.messageInfo));
        }
        if (!this.isMasked(16)) {
            this.setMask(16);
        } else {
            EscapeSequenceHandler esh = this.getEscapeSequenceHandler(this.escapedText.toString());
            String s = null != esh ? esh.handleSequence(this.escapedText.toString()) : this.defaultEscHandler.handleSequence(this.escapedText.toString());
            this.escapedText = new StringBuffer();
            if (this.isMasked(2)) {
                this.currentFieldText.append(s);
            }
            if (this.isMasked(4)) {
                this.currentComponentText.append(s);
            }
            if (this.isMasked(8)) {
                this.currentSubcomponentText.append(s);
            }
            this.resetMask(16);
        }
    }

    private boolean isEscapeCharacter(char c) {
        return this.messageInfo.getEscapeCharacter().charAt(0) == c;
    }

    private boolean isEndSegment(char c) {
        return HL7MessageInfo.LINE_DELIMETER.charAt(0) == c;
    }

    private boolean isDelimetersField() {
        return "MSH".equalsIgnoreCase(this.currentSegmentName.toString()) && this.fieldIndex == 2;
    }

    private void setMask(int mask) {
        this.stateMask |= mask;
    }

    private void resetMask(int mask) {
        this.stateMask ^= mask;
    }

    private boolean isMasked(int mask) {
        return (this.stateMask & mask) == mask;
    }

    public void addParserEventListener(HL7MessageParserListener listener) {
        this.parserEventListeners.add(listener);
    }

    private void loadEvent(String text) {
        this.event.setFieldIndex(this.fieldIndex);
        this.event.setComponentIndex(this.componentIndex);
        this.event.setSubcomponentIndex(this.subcomponentIndex);
        this.event.setRepeat(this.repeatCount);
        this.event.setSegmentName(this.currentSegmentName.toString());
        this.event.setText(text);
    }

    private void fireBeginSegmentEvent() {
        if (this.event == null) {
            this.event = new HL7MessageParserEvent(this);
        }
        if (this.isMessageHeaderSegment()) {
            ++this.fieldIndex;
        }
        this.loadEvent("");
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().beginSegment(this.event);
        }
        this.resetMask(1);
        this.fireBeginFieldEvent();
    }

    private void fireEndSegmentEvent() {
        this.fireEndFieldEvent();
        this.fieldIndex = 0;
        this.loadEvent("");
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().endSegment(this.event);
        }
        this.setMask(1);
        this.currentSegmentName = new StringBuffer();
    }

    private void fireBeginFieldEvent() {
        ++this.fieldIndex;
        this.currentFieldText = new StringBuffer();
        this.setMask(2);
        this.loadEvent("");
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().beginField(this.event);
        }
        this.fireBeginComponentEvent();
    }

    private void fireRepeatingFieldEvent() {
        this.fireEndComponentEvent();
        this.componentIndex = 0;
        ++this.repeatCount;
        this.loadEvent(this.currentFieldText.toString());
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().repeatField(this.event);
        }
        this.currentFieldText = new StringBuffer();
        this.componentIndex = 0;
        this.fireBeginComponentEvent();
    }

    private void fireEndFieldEvent() {
        this.fireEndComponentEvent();
        this.componentIndex = 0;
        this.repeatCount = 0;
        if (this.isMasked(2)) {
            this.loadEvent(this.currentFieldText.toString());
            Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
            while (iter.hasNext()) {
                iter.next().endField(this.event);
            }
            this.resetMask(2);
        }
    }

    private void fireBeginComponentEvent() {
        ++this.componentIndex;
        this.currentComponentText = new StringBuffer();
        this.setMask(4);
        this.loadEvent("");
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().beginComponent(this.event);
        }
        this.fireBeginSubcomponentEvent();
    }

    private void fireEndComponentEvent() {
        this.fireEndSubcomponentEvent();
        this.subcomponentIndex = 0;
        if (this.isMasked(4)) {
            this.loadEvent(this.currentComponentText.toString());
            Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
            while (iter.hasNext()) {
                iter.next().endComponent(this.event);
            }
            this.resetMask(4);
        }
    }

    private void fireBeginSubcomponentEvent() {
        ++this.subcomponentIndex;
        this.currentSubcomponentText = new StringBuffer();
        this.setMask(8);
        this.loadEvent("");
        Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
        while (iter.hasNext()) {
            iter.next().beginSubcomponent(this.event);
        }
    }

    private void fireEndSubcomponentEvent() {
        if (this.isMasked(8)) {
            this.loadEvent(this.currentSubcomponentText.toString());
            Iterator<HL7MessageParserListener> iter = this.parserEventListeners.iterator();
            while (iter.hasNext()) {
                iter.next().endSubcomponent(this.event);
            }
            this.resetMask(8);
        }
    }

    public HL7MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public void setMessageInfo(HL7MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) throws MessageParserException {
        this.setMessage(message, null);
    }

    public void setMessage(String message, HL7MessageInfo messageInfo) throws MessageParserException {
        this.initialize();
        if (message == null || message.length() == 0) {
            throw new MessageParserException("Message parameter passed in may not be a null or zero-length String object.");
        }
        if (messageInfo == null) {
            messageInfo = new HL7MessageInfoImpl(message);
        }
        this.message = message;
        this.messageInfo = messageInfo;
    }

    private final class DefaultEscapeHandler
    extends AbstractEscapeSequenceHandler {
        public DefaultEscapeHandler(HL7MessageInfo msgInfo) {
            super(msgInfo);
        }

        public String getSequenceType() {
            return "(?:[HNFSTRE]|X(?:[0-9a-fA-F]{2})+|Z.+|\\.(?:br|fi|nf|ce)|\\.(?:sp|in|ti|sk)[+-]?\\d*)";
        }
    }
}

