/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;

public class HL7MessageInfoImpl
implements HL7MessageInfo {
    private static final int FIELD_DELIMITER_IDX = 3;
    private static final int COMPONENT_SEPARATOR_IDX = 4;
    private static final int REPETITION_SEPARATOR_IDX = 5;
    private static final int ESCAPE_CHARACTER_IDX = 6;
    private static final int SUBCOMPONENT_SEPARATOR_IDX = 7;
    private static final int VERSION_FIELD_IDX = 11;
    private static final String DEF_FIELD_DELIMETER = "^";
    private static final String DEF_COMPONENT_SEPARATOR = "\\";
    private static final String DEF_REPETITION_SEPARATOR = "|";
    private static final String DEF_ESCAPE_CHARACTER = "~";
    private static final String DEF_SUBCOMPONENT_SEPARATOR = "&";
    private static final String DEF_VERIONS_NUMBER = "2.4";
    private String fieldDelimeter = "^";
    private String componentSeparator = "\\";
    private String repetitionSeparator = "|";
    private String escapeCharacter = "~";
    private String subcomponentSeparator = "&";
    private String version = "2.4";

    public static String getFieldDelimeter(String message) {
        if (message != null && !"".equals(message)) {
            return message.charAt(3) + "";
        }
        return DEF_FIELD_DELIMETER;
    }

    public static String getComponentSeparator(String message) {
        if (message != null && !"".equals(message)) {
            return message.charAt(4) + "";
        }
        return DEF_COMPONENT_SEPARATOR;
    }

    public static String getRepetitionSeparator(String message) {
        if (message != null && !"".equals(message)) {
            return message.charAt(5) + "";
        }
        return DEF_REPETITION_SEPARATOR;
    }

    public static String getEscapeCharacter(String message) {
        if (message != null && !"".equals(message)) {
            return message.charAt(6) + "";
        }
        return DEF_ESCAPE_CHARACTER;
    }

    public static String getSubcomponentSeparator(String message) {
        if (message != null && !"".equals(message)) {
            return message.charAt(7) + "";
        }
        return DEF_SUBCOMPONENT_SEPARATOR;
    }

    public static String getVersion(String message) {
        String version = "";
        if (message != null && !"".equals(message)) {
            char[] buff = message.toCharArray();
            char fieldDelimeter = HL7MessageInfoImpl.getFieldDelimeter(message).charAt(0);
            char componentSeparator = HL7MessageInfoImpl.getComponentSeparator(message).charAt(0);
            char subcomponentSeparator = HL7MessageInfoImpl.getSubcomponentSeparator(message).charAt(0);
            boolean copy = false;
            int j = 0;
            for (int i = 0; !(i >= buff.length || buff[i] == HL7MessageInfo.LINE_DELIMETER.charAt(0) || copy && buff[i] == componentSeparator || copy && buff[i] == subcomponentSeparator); ++i) {
                if (copy && buff[i] != fieldDelimeter) {
                    version = version + buff[i];
                    continue;
                }
                if (buff[i] == fieldDelimeter) {
                    boolean bl = copy = ++j == 11;
                }
                if (!copy && version.length() > 0) break;
            }
        }
        return version.length() > 0 ? version : DEF_VERIONS_NUMBER;
    }

    public HL7MessageInfoImpl() {
    }

    public HL7MessageInfoImpl(String message) {
        this.init(message);
    }

    private void init(String mshSegment) {
        if (mshSegment != null && mshSegment.startsWith("MSH")) {
            this.setComponentSeparator(HL7MessageInfoImpl.getComponentSeparator(mshSegment));
            this.setEscapeCharacter(HL7MessageInfoImpl.getEscapeCharacter(mshSegment));
            this.setFieldDelimeter(HL7MessageInfoImpl.getFieldDelimeter(mshSegment));
            this.setRepetitionSeparator(HL7MessageInfoImpl.getRepetitionSeparator(mshSegment));
            this.setSubcomponentSeparator(HL7MessageInfoImpl.getSubcomponentSeparator(mshSegment));
            this.setVersion(HL7MessageInfoImpl.getVersion(mshSegment));
        }
    }

    public String getComponentSeparator() {
        return this.componentSeparator;
    }

    public void setComponentSeparator(String componentSeparator) {
        this.componentSeparator = componentSeparator;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public String getFieldDelimeter() {
        return this.fieldDelimeter;
    }

    public void setFieldDelimeter(String fieldDelimeter) {
        this.fieldDelimeter = fieldDelimeter;
    }

    public String getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public void setRepetitionSeparator(String repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator;
    }

    public String getSubcomponentSeparator() {
        return this.subcomponentSeparator;
    }

    public void setSubcomponentSeparator(String subcomponentSeparator) {
        this.subcomponentSeparator = subcomponentSeparator;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

