/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.testharness.util.TemplateJarHelper;
import gov.va.med.cds.testharness.xml.XmlValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlValidator {
    private static Log logger = LogFactory.getLog(XmlValidator.class);
    private static String templateCachePath;

    public static void setTemplateCachePath(String templateCachePath) {
        XmlValidator.templateCachePath = templateCachePath;
    }

    public static void validateXml(String xml, String templateId) throws XmlValidationException, TransformerConfigurationException, IOException {
        XmlValidator.validateXml(xml, templateId, "Clinicaldata");
    }

    public static void validateXml(String xml, String templateId, String schemaNamespace) throws XmlValidationException, TransformerConfigurationException, IOException {
        try {
            TemplateJarHelper.unjar(templateCachePath, templateId);
        }
        catch (IOException e) {
            throw new XmlValidationException("Error extracting template schema files.", e);
        }
        String pathToXsd = String.format("%s %s/%s/template/%s.xsd", schemaNamespace, templateCachePath, templateId, templateId);
        XmlValidator.validate(xml, pathToXsd);
    }

    private static void validate(String xml, String xsdPath, XMLErrorHandler errorHandler) throws XmlValidationException {
        SAXReader reader = new SAXReader();
        reader.setErrorHandler((ErrorHandler)errorHandler);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)xsdPath);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setValidation(true);
            reader.read((InputStream)is);
        }
        catch (SAXException e) {
            throw new XmlValidationException(e);
        }
        catch (DocumentException e) {
            throw new XmlValidationException(e);
        }
        catch (Exception exception) {
            throw new XmlValidationException(exception);
        }
    }

    private static void validate(String xml, String xsdPath) throws XmlValidationException {
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        XmlValidator.validate(xml, xsdPath, errorHandler);
        if (errorHandler.getErrors().elements().size() > 0) {
            throw new XmlValidationException(errorHandler.getErrors().asXML());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validation Success \n" + errorHandler.getErrors().asXML()));
        }
    }
}

