/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VitalsBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    private static final int RECORD_VERSION = 12345;
    private int IDX;
    public static final String[] OBSERVATION_METHODS = new String[]{"Method 1", "Method 2", "Method 3", "Method 4"};
    public static final String[] QUALIFIERS = new String[]{"Qualifier 1", "Qualifier 2", "Qualifier 3", "Qualifier 4"};
    public static final String[] OBSERVED_CHARACTERITICS = new String[]{"Characteristic 1", "Characteristic 2", "Characteristic 3", "Characteristic 4"};

    public VitalsBuilder() {
    }

    public VitalsBuilder(Random random) {
        super(random);
    }

    public Element makeVital() {
        return this.makeVital("vitalSignObservationEvents", null);
    }

    public List<Element> makeVitals(int number) {
        return this.makeVitals(number, null);
    }

    public List<Element> makeVitals(int number, Element patient) {
        ArrayList<Element> vitals = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            vitals.add(this.makeVital("vitalSignObservationEvents", patient));
        }
        return vitals;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeVital("vitalSignObservationEvents", personIdentifier);
    }

    public Element makeVital(String elementName, Element patient) {
        ++this.IDX;
        Element newVitalSignObservationEvent = DocumentHelper.createElement((String)elementName);
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
        newVitalSignObservationEvent.add(newRecordIdentifier);
        Element newPatient = this.createPatientLite("patient");
        if (patient != null) {
            newPatient.element("identifier").element("identity").setText(patient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patient.elementText("assigningAuthority"));
        }
        newVitalSignObservationEvent.add(newPatient);
        Element newObservationTime = this.createPointInTime("observationTime");
        newVitalSignObservationEvent.add(newObservationTime);
        Element newObservationMethod = this.createHL72CodedElementLite("observationMethod", "ObservationMethod", OBSERVATION_METHODS);
        newVitalSignObservationEvent.add(newObservationMethod);
        Element newObservedCharacteristic = this.createHL72CodedElementLite("observedCharacteristic", "ObservedCharacteristic", OBSERVED_CHARACTERITICS);
        newVitalSignObservationEvent.add(newObservedCharacteristic);
        Element newCollectionSessionTime = this.createFixedPointInTime("collectionSessionTime");
        newVitalSignObservationEvent.add(newCollectionSessionTime);
        newVitalSignObservationEvent.addElement("status").addText("Status");
        Element newSupplementalOxygen = this.makeOxygenAdministration("supplementalOxygen");
        newVitalSignObservationEvent.add(newSupplementalOxygen);
        Element author = this.createPractitionerParticipationLite("author", "Author Comment", AUTHOR_IDS);
        newVitalSignObservationEvent.add(author);
        Element newHomeTelehealthMonitor = this.makeHomeTelehealthMonitor("homeTelehealthMonitor");
        newVitalSignObservationEvent.add(newHomeTelehealthMonitor);
        Element newHospitalLocationIdentifier = VitalsBuilder.createHL72LocationIdentifier("hospitalLocationIdentifier");
        newVitalSignObservationEvent.add(newHospitalLocationIdentifier);
        Element newDivision = this.createHL72CodedElementLite("division", "Division");
        newVitalSignObservationEvent.add(newDivision);
        Element newOrderingFacilityIdentifier = this.createHL72OrganizationIdentifier("orderingFacilityIdentifier");
        newVitalSignObservationEvent.add(newOrderingFacilityIdentifier);
        Element newStopCode = this.createHL72CodedElementLite("stopCode", "StopCode", "StopCode");
        newVitalSignObservationEvent.add(newStopCode);
        Element newVitalSignObservation = this.makeVitalSignObservation("vitalSignObservation");
        newVitalSignObservationEvent.add(newVitalSignObservation);
        Element newErrorEnterer = this.createPractitionerParticipationLite("errorEnterer", "ErrorEnterer Comment", AUTHOR_IDS);
        newVitalSignObservationEvent.add(newErrorEnterer);
        Element newErrorReason1 = this.makeErrorReason("errorReason", "Reason 1");
        newVitalSignObservationEvent.add(newErrorReason1);
        Element newErrorReason2 = this.makeErrorReason("errorReason", "Reason 2");
        newVitalSignObservationEvent.add(newErrorReason2);
        Element newRecordSource = this.createHL72FacilityIdentifier("recordSource");
        newVitalSignObservationEvent.add(newRecordSource);
        newVitalSignObservationEvent.addElement("recordVersion").addText("12345");
        Element newRecordUpdateTime = this.createPointInTime("recordUpdateTime");
        newVitalSignObservationEvent.add(newRecordUpdateTime);
        return newVitalSignObservationEvent;
    }

    public void printVitals(List<Element> listOfResults) {
        this.printDomainRecords(listOfResults);
    }

    public void printVitals(List<Element> listOfResults, Logger aLogger) {
        this.printDomainRecords(listOfResults, aLogger);
    }

    protected void printVital(Element vital) {
        this.printDomainRecord(vital);
    }

    protected void printVital(Element vital, Logger aLogger) {
        this.printDomainRecord(vital, aLogger);
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }

    private Element makeHomeTelehealthMonitor(String elementName) {
        Element newHomeTelehealthMonitor = DocumentHelper.createElement((String)elementName);
        newHomeTelehealthMonitor.addElement("vendor").addText("Vendor");
        newHomeTelehealthMonitor.addElement("homeAppliance").addText("HomeAppliance");
        newHomeTelehealthMonitor.addElement("measurementDevice").addText("MeasurementDevice");
        return newHomeTelehealthMonitor;
    }

    private Element makeOxygenAdministration(String elementName) {
        Element newOxygenAdministration = DocumentHelper.createElement((String)elementName);
        newOxygenAdministration.addElement("flowRateValue").addText("FlowRateValue");
        Element newFlowRateUnit = this.createHL72CodedElementLite("flowRateUnit", "VistaFlowRateUnit", "FlowRateUnit 1");
        newOxygenAdministration.add(newFlowRateUnit);
        newOxygenAdministration.addElement("concentrationValue").addText("ConcentrationValue");
        Element newConcentrationUnit = this.createHL72CodedElementLite("concentrationUnit", "VistaConcentrationUnit", "ConcentrationUnit 1");
        newOxygenAdministration.add(newConcentrationUnit);
        return newOxygenAdministration;
    }

    private Element makeVitalSignObservation(String elementName) {
        Element newVitalSignObservation = DocumentHelper.createElement((String)elementName);
        newVitalSignObservation.addElement("value").addText("Value");
        Element newUnit = this.createHL72CodedElementLite("unit", "Unit");
        newVitalSignObservation.add(newUnit);
        Element vitalSignQualifier1 = DocumentHelper.createElement((String)"qualifier");
        Element newVitalSignQualifierValue1 = this.createHL72CodedElementLite("value", "Qualifier1", QUALIFIERS);
        vitalSignQualifier1.add(newVitalSignQualifierValue1);
        newVitalSignObservation.add(vitalSignQualifier1);
        Element vitalSignQualifier2 = DocumentHelper.createElement((String)"qualifier");
        Element newVitalSignQualifierValue2 = this.createHL72CodedElementLite("value", "Qualifier2", QUALIFIERS);
        vitalSignQualifier2.add(newVitalSignQualifierValue2);
        newVitalSignObservation.add(vitalSignQualifier2);
        return newVitalSignObservation;
    }

    private Element makeErrorReason(String elementName, String reason) {
        Element newErrorReason = DocumentHelper.createElement((String)elementName);
        Element newReason = this.createHL72CodedElementLite("reason", reason);
        newErrorReason.add(newReason);
        return newErrorReason;
    }
}

