/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OutpatientMedicationPromiseBuilder
extends AbstractEntryPointBuilder {
    private static int OUTPATIENT_MEDICATION_PROMISE_IDX = 10000;
    public static final String[] DATA_ENTERER_IDS = new String[]{"test_IDS_1", "test_IDS_2", "test_IDS_3"};
    public static final String[] PHARMACIST_IDS = new String[]{"test_IDS_6001", "test_IDS_6002", "test_IDS_6003"};
    public static final String[] FINISHER_IDS = new String[]{"test_FINISHERID_7001", "test_FINISHERID_7002", "test_FINISHERID_7003"};
    public static final String[] RESPONSIBLE_PHYSICIAN_IDS = new String[]{"test_IDS_9001", "test_IDS_9002", "test_IDS_9003"};
    public static final String[] RENEWER_IDS = new String[]{"test_IDS_10001", "test_IDS_10002", "test_IDS_10003"};
    public static final String[] VERIFYING_PHARMACIST_IDS = new String[]{"test_IDS_11001", "test_IDS_11002", "test_IDS_11003"};
    public static final String[] ATTENDING_PHYSICIAN_IDS = new String[]{"test_IDS_12001", "test_IDS_12002", "test_IDS_12003"};
    public static final String[] COSIGNER_IDS = new String[]{"test_IDS_13001", "test_IDS_13002", "test_IDS_13003"};
    public static final String[] FILLER_IDS = new String[]{"test_IDS_14001", "test_IDS_14002", "test_IDS_14003"};
    public static final String[] CANCELLER_IDS = new String[]{"test_IDS_15001", "test_IDS_15002", "test_IDS_15003"};
    public static final String[] CURRENTPROVIDER_IDS = new String[]{"test_PROVIDERD_7001", "test_PROVIDERID_7002", "test_PROVIDERID_7003"};
    public static final String[] INITIATOR_IDS = new String[]{"test_INITIATOR_17001", "test_INITIATOR_17002", "test_INITIATOR_17003"};

    public OutpatientMedicationPromiseBuilder() {
    }

    public OutpatientMedicationPromiseBuilder(Random aRandom) {
        super(aRandom);
    }

    public Element makeInsertPharmacy() {
        return this.makePharmacy();
    }

    public List<Element> makeInsertPharmacies(int count) {
        return this.makePharmacies(count);
    }

    public Element makePharmacy() {
        return this.makePharmacy(null);
    }

    public Element makePharmacy(Element patientIdentifier) {
        Element pharmacy = this.createPharmacy(OUTPATIENT_MEDICATION_PROMISE_IDX++, patientIdentifier);
        return pharmacy;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makePharmacy(personIdentifier);
    }

    public List<Element> makePharmacies(int number) {
        return this.makePharmacies(number, null);
    }

    public List<Element> makePharmacies(int number, Element personIdentifier) {
        ArrayList<Element> pharmacies = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            pharmacies.add(this.makePharmacy(personIdentifier));
        }
        return pharmacies;
    }

    public Element makePharmacyWithDispenses(Element outpatientMedicationPromise, String dispenseType, int dispenseRecordCount) {
        this.createDispenses(outpatientMedicationPromise, OUTPATIENT_MEDICATION_PROMISE_IDX++, dispenseType, dispenseRecordCount);
        return outpatientMedicationPromise;
    }

    public List<Element> makeDispensesElementsForPharmacy(String dispenseType, int dispenseRecordCount) {
        ArrayList<Element> dispenseElements = new ArrayList<Element>();
        if (dispenseType.equalsIgnoreCase("All")) {
            int i;
            dispenseElements.add(this.createOutpatientMedicationDispense("originalDispense", "Original", dispenseRecordCount));
            for (i = 0; i < dispenseRecordCount; ++i) {
                dispenseElements.add(this.createOutpatientMedicationDispense("refillDispense", "Refill", i));
            }
            for (i = 0; i < dispenseRecordCount; ++i) {
                dispenseElements.add(this.createOutpatientMedicationDispense("partialDispense", "Partial", i));
            }
        } else {
            for (int i = 0; i < dispenseRecordCount; ++i) {
                dispenseElements.add(this.createOutpatientMedicationDispense(this.getDispenseElementName(dispenseType), dispenseType, i));
            }
        }
        return dispenseElements;
    }

    public Element makeCurrentProviderForPharmacy() {
        return this.createPractitionerLite("currentProvider", CURRENTPROVIDER_IDS);
    }

    public Element makeCurrentProviderCommentsForPharmacy(String comment) {
        return this.createComment("currentProviderComments", comment);
    }

    public Element makeCancelDateElementForPharmacy(int cancelDateYearOffset) {
        GregorianCalendar sysDate = null;
        Date cancelDt = null;
        if (cancelDateYearOffset != 0) {
            sysDate = new GregorianCalendar();
            sysDate.add(1, cancelDateYearOffset);
            cancelDt = sysDate.getTime();
        }
        return this.createCancelAct("cancel", cancelDt);
    }

    public Element makeExpiryDateElementForPharmacy(int expireDateYearOffset) {
        GregorianCalendar sysDate = null;
        Date expireDt = null;
        if (expireDateYearOffset != 0) {
            sysDate = new GregorianCalendar();
            sysDate.add(1, expireDateYearOffset);
            expireDt = sysDate.getTime();
        }
        return this.createPointInTime("expirationDate", expireDt);
    }

    private Element createPharmacy(int id, Element personIdentifier) {
        Element outpatientMedicationPromise = DocumentHelper.createElement((String)"outpatientMedicationPromises");
        this.setOutpatientMedicationPromiseValues(outpatientMedicationPromise, id, personIdentifier);
        return outpatientMedicationPromise;
    }

    private void createDispenses(Element outpatientMedicationPromise, int id, String dispenseType, int dispenseRecordCount) {
        if (dispenseType.equalsIgnoreCase("All")) {
            int i;
            if (outpatientMedicationPromise.element("originalDispense") == null) {
                outpatientMedicationPromise.add(this.createOutpatientMedicationDispense("originalDispense", "Original", id));
            }
            for (i = 0; i < dispenseRecordCount; ++i) {
                outpatientMedicationPromise.add(this.createOutpatientMedicationDispense("refillDispense", "Refill", id));
            }
            for (i = 0; i < dispenseRecordCount; ++i) {
                outpatientMedicationPromise.add(this.createOutpatientMedicationDispense("partialDispense", "Partial", id));
            }
        } else {
            for (int i = 0; i < dispenseRecordCount; ++i) {
                outpatientMedicationPromise.add(this.createOutpatientMedicationDispense(this.getDispenseElementName(dispenseType), dispenseType, id));
            }
        }
    }

    private String getDispenseElementName(String dispenseType) {
        if ("Original".equals(dispenseType)) {
            return "originalDispense";
        }
        if ("Refill".equals(dispenseType)) {
            return "refillDispense";
        }
        if ("Partial".equals(dispenseType)) {
            return "partialDispense";
        }
        throw new IllegalArgumentException(String.format("Invalid method parameter. Dispense type of '%s' is not valid.", dispenseType));
    }

    private void setOutpatientMedicationPromiseValues(Element outpatientMedicationPromise, int id, Element personIdentifier) {
        outpatientMedicationPromise.add(this.createHL72EntityIdentifier("recordIdentifier", id));
        outpatientMedicationPromise.add(this.createSimpleStringElement("pdtsPrescriptionId", "PdtsPrescriptionId"));
        outpatientMedicationPromise.add(this.createSimpleStringElement("prescriptionId", "PrescriptionId"));
        outpatientMedicationPromise.add(this.createSimpleStringElement("pharmacyPatientType", "PharmacyPatientType"));
        outpatientMedicationPromise.add(this.createSpecialDrugTracking("specialDrugTracking", "SpecialDrugTracking"));
        outpatientMedicationPromise.add(this.createPractitionerParticipationLite("dataEnterer", "DataEnterer", DATA_ENTERER_IDS));
        outpatientMedicationPromise.add(this.createPharmacyRequest("pharmacyRequest"));
        Element newPatient = this.createPatientLite("patient");
        if (personIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(personIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(personIdentifier.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(personIdentifier.elementText("assigningAuthority"));
        }
        outpatientMedicationPromise.add(newPatient);
        outpatientMedicationPromise.add(this.createPointInTime("expirationDate"));
        outpatientMedicationPromise.add(this.createPointInTime("lastDispenseDate"));
        outpatientMedicationPromise.add(this.createSimpleIntegerElement("numberOfRefillsAuthorized", 2));
        outpatientMedicationPromise.elements().addAll(this.createSimpleStringElements("patientInstructions", "PatientInstructions", 2));
        outpatientMedicationPromise.elements().addAll(this.createSimpleStringElements("otherPatientInstructions", "OtherPatientInstructions", 2));
        outpatientMedicationPromise.elements().addAll(this.createSimpleStringElements("expandedPatientInstructions", "ExpandedPatientInstructions", 2));
        outpatientMedicationPromise.elements().addAll(this.createSimpleStringElements("pharmacyInstructions", "PharmacyInstructions", 2));
        outpatientMedicationPromise.elements().addAll(this.createSimpleStringElements("sig", "Sig", 2));
        outpatientMedicationPromise.add(this.createHL72CodedElementLite("digitalSignatureIndicator", "DigitalSignatureIndicator"));
        outpatientMedicationPromise.add(this.createHL72CodedElementLite("copayTransactionType", "CopayTransactionType"));
        outpatientMedicationPromise.add(this.createHL72CodedElementLite("transitionalRxBenefit", "TransitionalRxBenefit"));
        outpatientMedicationPromise.add(this.createTreatmentFactor("treatmentFactor"));
        this.createDispenses(outpatientMedicationPromise, id, "All", 2);
        outpatientMedicationPromise.add(this.createCancelAct("cancel"));
        outpatientMedicationPromise.add(this.createMedicationInstructionComponent("medicationInstructions"));
        outpatientMedicationPromise.add(this.createMedicationInstructionComponent("medicationInstructions"));
        outpatientMedicationPromise.add(this.createPractitionerParticipationLite("finisher", "Finisher Comment", FINISHER_IDS));
        outpatientMedicationPromise.add(this.createActivityLog("activityLog"));
        outpatientMedicationPromise.add(this.createActivityLog("activityLog"));
        outpatientMedicationPromise.add(this.createHL72FacilityIdentifier("recordSource"));
        outpatientMedicationPromise.add(this.createSimpleIntegerElement("recordVersion", id));
        outpatientMedicationPromise.add(this.createPointInTime("recordUpdateTime"));
    }

    public void printPharmacies(List<Element> listOfResults) {
        this.printDomainRecords(listOfResults);
    }

    public void printPharmacies(List<Element> listOfResults, Logger logger) {
        this.printDomainRecords(listOfResults, logger);
    }

    protected void printPharmacy(Element outpatientMedicationPromise) {
        this.printDomainRecord(outpatientMedicationPromise);
    }

    protected void printPharmacy(Element outpatientMedicationPromise, Logger logger) {
        this.printDomainRecord(outpatientMedicationPromise, logger);
    }

    @Override
    public String fillPrintBuffer(Object obj) {
        String returnString = "";
        if (obj != null && obj instanceof Element) {
            returnString = ((Element)obj).asXML();
        }
        return returnString;
    }

    private Element createPharmacyRequest(String elementName) {
        Element newPharmacyRequest = DocumentHelper.createElement((String)elementName);
        newPharmacyRequest.add(this.createPractitionerParticipationLite("cosigner", "Cosigner", COSIGNER_IDS));
        newPharmacyRequest.add(this.createMedicine("orderedMedication", "OrderedMedication"));
        newPharmacyRequest.add(this.createHL72EntityIdentifier("genericRequestIdentifier"));
        newPharmacyRequest.add(OutpatientMedicationPromiseBuilder.createHL72LocationIdentifier("orderLocationIdentifier"));
        newPharmacyRequest.add(this.createPharmacyOrderableItem("orderedItem", "OrderedItem"));
        newPharmacyRequest.add(this.createHL72OrganizationIdentifier("orderingInstitutionIdentifier"));
        newPharmacyRequest.add(this.createPointInTime("orderDate"));
        newPharmacyRequest.add(this.createSimpleStringElement("status", "Status"));
        newPharmacyRequest.add(this.createHL72CodedElementLite("statusModifier", "StatusModifier"));
        return newPharmacyRequest;
    }

    private Element createPharmacyOrderableItem(String elementName, String type) {
        Element newPharmacyOrderableItem = DocumentHelper.createElement((String)elementName);
        newPharmacyOrderableItem.add(this.createHL72CodedElementLite("itemCode", type + " Item"));
        newPharmacyOrderableItem.add(this.createHL72CodedElementLite("dosageFormCode", "DosageForm"));
        return newPharmacyOrderableItem;
    }

    private Element createSpecialDrugTracking(String elementName, String type) {
        Element newSpecialDrugTracking = DocumentHelper.createElement((String)elementName);
        Element newTotalDailyDosage = this.createPhysicalQuantity("totalDailyDosage");
        newSpecialDrugTracking.add(newTotalDailyDosage);
        newSpecialDrugTracking.add(this.createWbcObservation("wbcObservation", "10.0"));
        return newSpecialDrugTracking;
    }

    private Element createMedicine(String elementName, String type) {
        Element newMedicine = DocumentHelper.createElement((String)elementName);
        newMedicine.add(this.createHL72CodedElementLite("cmopDrugCode", type + " CmopDrugCd"));
        newMedicine.add(this.createHL72CodedElement("medicationCode", " Med Alt Code"));
        newMedicine.add(this.createHL72CodedElementLite("otcCode", type + " NDFCd"));
        newMedicine.add(this.createHL72CodedElementLite("tradeName", type + " TradeNm"));
        return newMedicine;
    }

    private Element createWbcObservation(String elementName, String count) {
        Element newWbcObservation = DocumentHelper.createElement((String)elementName);
        newWbcObservation.add(this.createPhysicalQuantity("count", count));
        newWbcObservation.add(this.createPointInTime("testDate"));
        return newWbcObservation;
    }

    private Element createActivityLog(String elementName) {
        Element newActivityLog = DocumentHelper.createElement((String)elementName);
        newActivityLog.add(this.createPointInTime("activityDate"));
        newActivityLog.add(this.createHL72CodedElementLite("reason", "Reason"));
        newActivityLog.add(this.createPractitionerParticipationLite("initiator", "Initiator Comment", INITIATOR_IDS));
        newActivityLog.add(this.createSimpleStringElement("comment", "ActivityLog Comment"));
        return newActivityLog;
    }

    private Element createCancelAct(String elementName, Date date) {
        Element newCancelAct = DocumentHelper.createElement((String)elementName);
        newCancelAct.add(this.createPointInTime("cancelDate", date));
        newCancelAct.elements().addAll(this.createSimpleStringElements("comments", "CancelAct_Comment", 2));
        return newCancelAct;
    }

    private Element createCancelAct(String elementName) {
        return this.createCancelAct(elementName, new Date());
    }

    private Element createMedicationInstructionComponent(String elementName) {
        Element newMedicationInstructionComponent = DocumentHelper.createElement((String)elementName);
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("conjunction", "Conjunction"));
        newMedicationInstructionComponent.add(this.createSimpleStringElement("dispenseUnitsPerDose", "15.0"));
        newMedicationInstructionComponent.add(this.createSimpleStringElement("dosageOrdered", "DosageOrdered"));
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("noun", "Noun"));
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("route", "Route"));
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("schedule", "Schedule"));
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("verb", "Verb"));
        newMedicationInstructionComponent.add(this.createHL72CodedElementLite("giveUnits", "VistaGiveUnits"));
        newMedicationInstructionComponent.add(this.createSimpleStringElement("intendedDuration", "IntendedDuration"));
        return newMedicationInstructionComponent;
    }

    private Element createTreatmentFactor(String elementName) {
        Element newTreatmentFactor = DocumentHelper.createElement((String)elementName);
        newTreatmentFactor.add(this.createHL72CodedElementLite("factor", "Factor"));
        newTreatmentFactor.add(this.createHL72CodedElementLite("factorValue", "FactorValue"));
        return newTreatmentFactor;
    }

    public Element createOutpatientMedicationDispense(String elementName, String type, int id) {
        Element newOutpatientMedicationDispense = DocumentHelper.createElement((String)elementName);
        newOutpatientMedicationDispense.elements().addAll(this.createSimpleStringElements("comments", "Comments", 2));
        newOutpatientMedicationDispense.add(this.createPointInTime("dispenseDate"));
        newOutpatientMedicationDispense.add(this.createPointInTime("fillDate"));
        newOutpatientMedicationDispense.add(this.createPhysicalQuantity("quantityDispensed"));
        newOutpatientMedicationDispense.add(this.createPractitionerLite("currentProvider", CURRENTPROVIDER_IDS));
        newOutpatientMedicationDispense.elements().addAll(this.createSimpleStringElements("currentProviderComments", "ProviderComments", 2));
        newOutpatientMedicationDispense.add(this.createPointInTime("loginDate"));
        newOutpatientMedicationDispense.add(this.createSimpleStringElement("daysSupply", "5"));
        newOutpatientMedicationDispense.add(this.createHL72EntityIdentifier("identifier", id));
        newOutpatientMedicationDispense.add(this.createHL72CodedElementLite("levelOfUnderstanding", "LevelOfUnderstanding"));
        newOutpatientMedicationDispense.add(this.createSimpleStringElement("mailWindow", "MailWindow"));
        newOutpatientMedicationDispense.add(this.createPointInTime("releaseDate"));
        newOutpatientMedicationDispense.add(this.createHL72CodedElementLite("wasPatientCounseled", "WasPatientCounseled"));
        newOutpatientMedicationDispense.add(OutpatientMedicationPromiseBuilder.createPharmacyDivision("division", "DivisionId", "NcpdpId"));
        newOutpatientMedicationDispense.add(this.createDispensedDrugInstance("dispensedDrug", type));
        newOutpatientMedicationDispense.add(this.createPractitionerParticipationLite("pharmacist", "Pharmacist Comment", PHARMACIST_IDS));
        newOutpatientMedicationDispense.add(this.createHL72CodedElementLite("cmopEventStatus", "CmopEventStatus"));
        newOutpatientMedicationDispense.add(this.createSimpleIntegerElement("numberOfRefillsRemaining", 13));
        return newOutpatientMedicationDispense;
    }

    private Element createDispensedDrugInstance(String elementName, String type) {
        Element newDispensedDrugInstance = DocumentHelper.createElement((String)elementName);
        newDispensedDrugInstance.add(this.createMoney("drugUnitPrice"));
        newDispensedDrugInstance.add(this.createPointInTime("expirationDate"));
        newDispensedDrugInstance.add(this.createSimpleStringElement("lotId", type + "newLotId"));
        newDispensedDrugInstance.add(this.createHL72CodedElementLite("ndc", type + "Ndc"));
        return newDispensedDrugInstance;
    }
}

