/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAVitalsBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    private static final int RECORD_VERSION = 12345;
    private String recordIdentifierIdentity;
    private String[] qualifierRecordIdentifiers;
    private int IDX;
    public static final String[] OBSERVATION_METHODS = new String[]{"Method 1", "Method 2", "Method 3", "Method 4"};
    public static final String[] OBSERVED_CHARACTERITICS = new String[]{"Characteristic 1", "Characteristic 2", "Characteristic 3", "Characteristic 4"};
    public static final String[] QUALIFIERS_OLD = new String[]{"Qualifier-1", "Qualifier-2", "Qualifier-3", "Qualifier-4"};
    public static final String[][] QUALIFIERS = new String[][]{{"4688703", "SITTING", "99VA120.52"}, {"4500643", "STANDING", "99VA120.52"}, {"4688663", "LYING", "99VA120.52"}, {"4500642", "ORAL", "99VA120.52"}};

    public HAVitalsBuilder() {
    }

    public HAVitalsBuilder(Random random) {
        super(random);
    }

    public HAVitalsBuilder(String recordIdentifierIdentity) {
        this.recordIdentifierIdentity = recordIdentifierIdentity;
    }

    public HAVitalsBuilder(String recordIdentifierIdentity, String[] qualifierRecordIdentifiers) {
        this.recordIdentifierIdentity = recordIdentifierIdentity;
        this.qualifierRecordIdentifiers = qualifierRecordIdentifiers;
    }

    public List<Element> makeVitals(int number) {
        return this.makeVitals(number, null);
    }

    public List<Element> makeVitals(int number, Element patient) {
        return this.makeVitals(number, patient, true);
    }

    public List<Element> makeVitals(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> vitals = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            vitals.add(this.makeVital("vitalSignObservationEvent", patient, updateRecordXml));
        }
        return vitals;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeVital("vitalSignObservationEvent", personIdentifier);
    }

    public Element makeVital(String elementName, Element patientIdentifier) {
        return this.makeVital(elementName, patientIdentifier, false);
    }

    public Element makeVital(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newVitalSignObservationEvent = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patientIdentifier.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patientIdentifier.elementText("assigningAuthority"));
        }
        newVitalSignObservationEvent.add(newPatient);
        if (updateRecordXml) {
            if (this.recordIdentifierIdentity != null) {
                newVitalSignObservationEvent.add(this.createHL72EntityIdentifier("recordIdentifier", this.recordIdentifierIdentity));
            } else {
                newVitalSignObservationEvent.add(this.createHL72EntityIdentifier("recordIdentifier", this.IDX));
            }
        }
        Element newObservationTime = this.createFixedPointInTime("observationTime");
        newVitalSignObservationEvent.add(newObservationTime);
        Element newObservationMethod = this.createHL72CodedElementLite("observationMethod", "ObservationMethod", OBSERVATION_METHODS);
        newVitalSignObservationEvent.add(newObservationMethod);
        Element newObservedCharacteristic = this.createHL72CodedElementLite("observedCharacteristic", "ObservedCharacteristic", OBSERVED_CHARACTERITICS);
        newVitalSignObservationEvent.add(newObservedCharacteristic);
        Element newCollectionSessionTime = this.createFixedPointInTime("collectionSessionTime");
        newVitalSignObservationEvent.add(newCollectionSessionTime);
        newVitalSignObservationEvent.addElement("status").addText("Status");
        Element newSupplementalOxygen = this.makeOxygenAdministration("supplementalOxygen");
        newVitalSignObservationEvent.add(newSupplementalOxygen);
        Element newHomeTelehealthMonitor = updateRecordXml && this.recordIdentifierIdentity != null ? this.makeHomeTelehealthMonitor("homeTelehealthMonitor", updateRecordXml) : this.makeHomeTelehealthMonitor("homeTelehealthMonitor");
        newVitalSignObservationEvent.add(newHomeTelehealthMonitor);
        Element newVitalSignObservation = this.makeVitalSignObservation("vitalSignObservation");
        newVitalSignObservationEvent.add(newVitalSignObservation);
        return newVitalSignObservationEvent;
    }

    public Element makePatientEnteredVitalSign(String elementName, Element patientIdentifier, int countPatientEnteredVitalSigns, int countObservations, boolean updateRecordXml) {
        Element patientEnteredVitalSigns = DocumentHelper.createElement((String)"patientEnteredVitalSigns");
        for (int i = 0; i < countPatientEnteredVitalSigns; ++i) {
            Element patientEnteredVitalSign = DocumentHelper.createElement((String)"patientEnteredVitalSign");
            List<Element> vitalSignObservationEvents = this.makeVitals(countObservations, patientIdentifier, updateRecordXml);
            for (Element vitalSignObservationEvent : vitalSignObservationEvents) {
                patientEnteredVitalSign.add(vitalSignObservationEvent);
            }
            patientEnteredVitalSign.addElement("dataEnterer").addText("DataEnterer9876");
            String comment = "This is a patient entered vital sign comment.";
            if (updateRecordXml) {
                comment = "This is a patient entered vital sign UPDATED comment.";
            }
            patientEnteredVitalSign.addElement("comments").addText(comment);
            patientEnteredVitalSigns.add(patientEnteredVitalSign);
        }
        return patientEnteredVitalSigns;
    }

    public Element makePatientEnteredVitalSign(String elementName, Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element patientEnteredVitalSigns = DocumentHelper.createElement((String)"patientEnteredVitalSigns");
        Element patientEnteredVitalSign = DocumentHelper.createElement((String)"patientEnteredVitalSign");
        List<Element> vitalSignObservationEvents = this.makeVitals(countObservations, patientIdentifier, updateRecordXml);
        for (Element vitalSignObservationEvent : vitalSignObservationEvents) {
            patientEnteredVitalSign.add(vitalSignObservationEvent);
        }
        patientEnteredVitalSign.addElement("dataEnterer").addText("DataEnterer9876");
        String comment = "This is a patient entered vital sign comment.";
        if (updateRecordXml) {
            comment = "This is a patient entered vital sign UPDATED comment.";
        }
        patientEnteredVitalSign.addElement("comments").addText(comment);
        patientEnteredVitalSigns.add(patientEnteredVitalSign);
        return patientEnteredVitalSigns;
    }

    public Element makePatientEnteredVitalSign(String elementName, String recordIdentifier, String recordStatus) {
        Element patientEnteredVitalSigns = DocumentHelper.createElement((String)"patientEnteredVitalSigns");
        Element patientEnteredVitalSign = DocumentHelper.createElement((String)"patientEnteredVitalSign");
        Element newVitalSignObservationEvent = DocumentHelper.createElement((String)"vitalSignObservationEvent");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newVitalSignObservationEvent.add(newRecordIdentifier);
        patientEnteredVitalSign.add(newVitalSignObservationEvent);
        patientEnteredVitalSign.addElement("recordStatus").addText(recordStatus);
        patientEnteredVitalSigns.add(patientEnteredVitalSign);
        return patientEnteredVitalSigns;
    }

    public void printVitals(List<Element> listOfResults) {
        this.printDomainRecords(listOfResults);
    }

    public void printVitals(List<Element> listOfResults, Logger aLogger) {
        this.printDomainRecords(listOfResults, aLogger);
    }

    protected void printVital(Element vital) {
        this.printDomainRecord(vital);
    }

    protected void printVital(Element vital, Logger aLogger) {
        this.printDomainRecord(vital, aLogger);
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }

    private Element makeHomeTelehealthMonitor(String elementName, boolean updateRecordXml) {
        Element newHomeTelehealthMonitor = DocumentHelper.createElement((String)elementName);
        newHomeTelehealthMonitor.addElement("vendor").addText("UpdatedVendor");
        newHomeTelehealthMonitor.addElement("homeAppliance").addText("UpdatedHomeAppliance");
        newHomeTelehealthMonitor.addElement("measurementDevice").addText("UpdatedMeasurementDevice");
        return newHomeTelehealthMonitor;
    }

    private Element makeHomeTelehealthMonitor(String elementName) {
        Element newHomeTelehealthMonitor = DocumentHelper.createElement((String)elementName);
        newHomeTelehealthMonitor.addElement("vendor").addText("Vendor");
        newHomeTelehealthMonitor.addElement("homeAppliance").addText("HomeAppliance");
        newHomeTelehealthMonitor.addElement("measurementDevice").addText("MeasurementDevice");
        return newHomeTelehealthMonitor;
    }

    private Element makeOxygenAdministration(String elementName) {
        Element newOxygenAdministration = DocumentHelper.createElement((String)elementName);
        newOxygenAdministration.addElement("flowRateValue").addText("FlowRateValue");
        Element newFlowRateUnit = this.createHL72CodedElementLite("flowRateUnit", "VistaFlowRateUnit", "FlowRateUnit 1");
        newOxygenAdministration.add(newFlowRateUnit);
        newOxygenAdministration.addElement("concentrationValue").addText("ConcentrationValue");
        Element newConcentrationUnit = this.createHL72CodedElementLite("concentrationUnit", "VistaConcentrationUnit", "ConcentrationUnit 1");
        newOxygenAdministration.add(newConcentrationUnit);
        return newOxygenAdministration;
    }

    private Element makeVitalSignObservation(String elementName) {
        Element newVitalSignObservation = DocumentHelper.createElement((String)elementName);
        newVitalSignObservation.addElement("value").addText("Value");
        Element newUnit = this.createHL72CodedElementLite("unit", "Unit");
        newVitalSignObservation.add(newUnit);
        newVitalSignObservation.addElement("internationalValue").addText("InternationalValue");
        Element newInternationalUnit = this.createHL72CodedElementLite("internationalUnit", "InternationalUnit");
        newVitalSignObservation.add(newInternationalUnit);
        Element vitalSignQualifiers = DocumentHelper.createElement((String)"qualifiers");
        Element vitalSignQualifier1 = DocumentHelper.createElement((String)"qualifier");
        int index = 0;
        Element newVitalSignQualifierValue1 = this.createHL72CodedElementLite("value", QUALIFIERS, index);
        vitalSignQualifier1.add(newVitalSignQualifierValue1);
        vitalSignQualifiers.add(vitalSignQualifier1);
        int n = index = this.recordIdentifierIdentity == null ? 0 : 1;
        if (index == 1) {
            Element vitalSignQualifier2 = DocumentHelper.createElement((String)"qualifier");
            Element newVitalSignQualifierValue2 = this.createHL72CodedElementLite("value", QUALIFIERS, index);
            vitalSignQualifier2.add(newVitalSignQualifierValue2);
            vitalSignQualifiers.add(vitalSignQualifier2);
        }
        newVitalSignObservation.add(vitalSignQualifiers);
        return newVitalSignObservation;
    }
}

