/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HASkillTrackingBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private String recordIdentifier;
    private int IDX;
    public static final String[] CONTACT_METHODS = new String[]{"Method 1", "Method 2", "Method 3", "Method 4"};

    public HASkillTrackingBuilder() {
    }

    public HASkillTrackingBuilder(String recordIdentifier, String personContacted) {
        this.recordIdentifier = recordIdentifier;
    }

    public HASkillTrackingBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HASkillTrackingBuilder(Random random) {
        super(random);
    }

    public List<Element> makeSkillTracking(int number) {
        return this.makeSkillTracking(number, null);
    }

    public List<Element> makeSkillTracking(int number, Element patient) {
        return this.makeSkillTracking(number, patient, true, null);
    }

    public List<Element> makeSkillTracking(int number, Element patient, boolean updateRecordXml, String skillType) {
        ArrayList<Element> SkillTracking = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            SkillTracking.add(this.makeSkillTracking("skillTracking", patient, updateRecordXml, skillType));
        }
        return SkillTracking;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeSkillTracking("SkillTracking", personIdentifier, null);
    }

    public Element makeSkillTracking(String elementName, Element Identifier, String skillType) {
        return this.makeSkillTracking(elementName, Identifier, false, skillType);
    }

    public Element makeSkillTracking(String elementName, Element identifier, boolean updateRecordXml, String skillType) {
        ++this.IDX;
        Element newSkillTracking = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (identifier != null) {
            newPatient.element("identifier").element("identity").setText(identifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText(ASSIGNINGAUTHORITY_HDR);
        }
        newSkillTracking.add(newPatient);
        Element newEntryDateTime = this.createPointInTime("entryDate", new Date());
        newSkillTracking.add(newEntryDateTime);
        newSkillTracking.addElement("skillSuccessLevel").addText("0");
        newSkillTracking.addElement("skillType").addText(skillType);
        newSkillTracking.addElement("skillFrequency").addText("skillFrequency");
        newSkillTracking.addElement("dataEnterer").addText("dataEnterer");
        newSkillTracking.addElement("allowAccessByClinicalStaff").addText("true");
        newSkillTracking.addElement("comments").addText("comments");
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                newSkillTracking.add(this.createHL72EntityIdentifier("recordIdentifier", this.recordIdentifier));
            } else {
                newSkillTracking.add(this.createHL72EntityIdentifier("recordIdentifier", this.IDX));
            }
        }
        return newSkillTracking;
    }

    public Element makeSkillTracking(Element identifier, int countObservations, boolean updateRecordXml, String skillType) {
        Element skillsTracking = DocumentHelper.createElement((String)"skillsTracking");
        List<Element> skillTrackingList = this.makeSkillTracking(countObservations, identifier, updateRecordXml, skillType);
        for (Element skillTracking : skillTrackingList) {
            skillsTracking.add(skillTracking);
        }
        return skillsTracking;
    }

    public Element makeSkillTracking(String outerElementName, String recordIdentifier, String recordStatus, String innerElementName, String skillType) {
        Element skillsTracking = DocumentHelper.createElement((String)outerElementName);
        Element skillTracking = DocumentHelper.createElement((String)innerElementName);
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        skillTracking.add(newRecordIdentifier);
        skillTracking.addElement("recordStatus").addText(recordStatus);
        skillsTracking.add(skillTracking);
        return skillsTracking;
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

