/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.HAExerciseJournalBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class HAPatientEnteredExerciseJournalEntryBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HAExerciseJournalBuilder exerciseJournalBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Namespace patientJournalingNS = DocumentHelper.createNamespace((String)"patientjournaling", (String)"PatientJournaling");
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(patientJournalingNS);
        rootElement.add(xsiNS);
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element patientJournalEntry = this.exerciseJournalBuilder.makeExerciseJournalEntry(patientIdentifier, count, updateRecordXml);
        patient.add(patientJournalEntry);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Namespace patientJournalingNS = DocumentHelper.createNamespace((String)"patientjournaling", (String)"PatientJournaling");
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(patientJournalingNS);
        rootElement.add(xsiNS);
        Element patient = rootElement.element("patient");
        Element patientJournalEntries = this.exerciseJournalBuilder.makeJournalEntry("patientJournalEntries", recordIdentifier, recordStatus, "patientjournaling:patientEnteredExerciseJournalEntry");
        patient.add(patientJournalEntries);
    }

    public void setExerciseJournalBuilder(HAExerciseJournalBuilder exerciseJournalBuilder) {
        this.exerciseJournalBuilder = exerciseJournalBuilder;
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setExerciseJournalBuilder((HAExerciseJournalBuilder)builder);
    }
}

