/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.PatientEnteredDailyEventBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class HAPatienEnteredDailyEventJournalEntryBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private PatientEnteredDailyEventBuilder patientEnteredDailyEventBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Namespace patientJournalingNS = DocumentHelper.createNamespace((String)"patientjournaling", (String)"PatientJournaling");
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(patientJournalingNS);
        rootElement.add(xsiNS);
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element patientJournalEntry = this.patientEnteredDailyEventBuilder.makePatientEnteredDailyEventJournalEntry(patientIdentifier, 1, updateRecordXml);
        patient.add(patientJournalEntry);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Namespace patientJournalingNS = DocumentHelper.createNamespace((String)"patientjournaling", (String)"PatientJournaling");
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(patientJournalingNS);
        rootElement.add(xsiNS);
        Element patient = rootElement.element("patient");
        Element patientJournalEntries = this.patientEnteredDailyEventBuilder.makeJournalEntry("patientJournalEntries", recordIdentifier, recordStatus, "patientjournaling:patientEnteredDailyEventJournalEntry");
        patient.add(patientJournalEntries);
    }

    public void setDailyEventJournalEntryBuilder(PatientEnteredDailyEventBuilder patientEnteredDailyEventBuilder) {
        this.patientEnteredDailyEventBuilder = patientEnteredDailyEventBuilder;
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setDailyEventJournalEntryBuilder((PatientEnteredDailyEventBuilder)builder);
    }
}

