/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.HAPainReassessmentBuilder;
import org.dom4j.Document;
import org.dom4j.Element;

public class HAPainReassessmentBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HAPainReassessmentBuilder painReassessmentBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        Element patient = rootElement.element("patient");
        Element newPainReassessments = this.painReassessmentBuilder.makePainReassessment("painReassessments", recordIdentifier, recordStatus);
        patient.add(newPainReassessments);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element newPainReassessments = this.painReassessmentBuilder.makePainReassessment(patientIdentifier, count, updateRecordXml);
        patient.add(newPainReassessments);
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setPainReassessmentBuilder((HAPainReassessmentBuilder)builder);
    }

    public HAPainReassessmentBuilder getPainReassessmentBuilder() {
        return this.painReassessmentBuilder;
    }

    public void setPainReassessmentBuilder(HAPainReassessmentBuilder painReassessmentBuilder) {
        this.painReassessmentBuilder = painReassessmentBuilder;
    }
}

