/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAPainReassessmentBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private String recordIdentifier;
    private String painReassessmentDate;
    private int IDX;

    public HAPainReassessmentBuilder() {
    }

    public HAPainReassessmentBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAPainReassessmentBuilder(String recordIdentifier, String painReassessmentDate) {
        this.recordIdentifier = recordIdentifier;
        this.painReassessmentDate = painReassessmentDate;
    }

    public HAPainReassessmentBuilder(Random random) {
        super(random);
    }

    public List<Element> makePainReassessments(int number) {
        return this.makePainReassessments(number, null);
    }

    public List<Element> makePainReassessments(int number, Element patient) {
        return this.makePainReassessments(number, patient, true);
    }

    public List<Element> makePainReassessments(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makePainReassessment("painReassessment", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makePainReassessment("patientJournalEntry", personIdentifier);
    }

    public Element makePainReassessment(String elementName, Element patientIdentifier) {
        return this.makePainReassessment(elementName, patientIdentifier, false);
    }

    public Element makePainReassessment(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPainReassessmentEntry = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText(ASSIGNINGAUTHORITY_HDR);
        }
        newPainReassessmentEntry.add(newPatient);
        Element newAssessmentDate = this.createFixedPointInTime("assessmentDate");
        newPainReassessmentEntry.add(newAssessmentDate);
        Element newPainReassessmentDate = this.painReassessmentDate != null ? this.createPointInTime("reassessmentDate", this.painReassessmentDate) : this.createFixedPointInTime("reassessmentDate");
        newPainReassessmentEntry.add(newPainReassessmentDate);
        Element newAvgPainLevelEntry = DocumentHelper.createElement((String)"avgPainLevel");
        newAvgPainLevelEntry.addElement("rating").addText("5");
        newAvgPainLevelEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newAvgPainLevelEntry);
        Element newMaxPainLevelEntry = DocumentHelper.createElement((String)"maxPainLevel");
        newMaxPainLevelEntry.addElement("rating").addText("5");
        newMaxPainLevelEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newMaxPainLevelEntry);
        Element newMinPainLevelEntry = DocumentHelper.createElement((String)"minPainLevel");
        newMinPainLevelEntry.addElement("rating").addText("5");
        newMinPainLevelEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newMinPainLevelEntry);
        Element newPainInterferenceEntry = DocumentHelper.createElement((String)"painInterference");
        newPainInterferenceEntry.addElement("rating").addText("5");
        newPainInterferenceEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newPainInterferenceEntry);
        Element newPainImpactOnMoodEntry = DocumentHelper.createElement((String)"painImpactOnMood");
        newPainImpactOnMoodEntry.addElement("rating").addText("5");
        newPainImpactOnMoodEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newPainImpactOnMoodEntry);
        Element newPainImpactOnWorkEntry = DocumentHelper.createElement((String)"painImpactOnWork");
        newPainImpactOnWorkEntry.addElement("rating").addText("5");
        newPainImpactOnWorkEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newPainImpactOnWorkEntry);
        Element newDecreaseInSocialEntry = DocumentHelper.createElement((String)"decreaseInSocial");
        newDecreaseInSocialEntry.addElement("rating").addText("5");
        newDecreaseInSocialEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newDecreaseInSocialEntry);
        Element newImpressionOfChangeEntry = DocumentHelper.createElement((String)"impressionOfChange");
        newImpressionOfChangeEntry.addElement("rating").addText("5");
        newImpressionOfChangeEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newImpressionOfChangeEntry);
        Element newSleepRefreshmentEntry = DocumentHelper.createElement((String)"sleepRefreshment");
        newSleepRefreshmentEntry.addElement("rating").addText("5");
        newSleepRefreshmentEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newSleepRefreshmentEntry);
        Element newDepressionLevelEntry = DocumentHelper.createElement((String)"depressionLevel");
        newDepressionLevelEntry.addElement("rating").addText("5");
        newDepressionLevelEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newDepressionLevelEntry);
        Element newConcernOfPainEndingEntry = DocumentHelper.createElement((String)"concernOfPainEnding");
        newConcernOfPainEndingEntry.addElement("rating").addText("5");
        newConcernOfPainEndingEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newConcernOfPainEndingEntry);
        Element newConcernOfPainToleranceEntry = DocumentHelper.createElement((String)"concernOfPainTolerance");
        newConcernOfPainToleranceEntry.addElement("rating").addText("5");
        newConcernOfPainToleranceEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newConcernOfPainToleranceEntry);
        newPainReassessmentEntry.addElement("dataEnterer").addText("dataEnterer");
        newPainReassessmentEntry.addElement("allowAccessByClinicalStaff").addText("true");
        Element newConcernOfExcersizeInjuryEntry = DocumentHelper.createElement((String)"concernOfExerciseInjury");
        newConcernOfExcersizeInjuryEntry.addElement("rating").addText("5");
        newConcernOfExcersizeInjuryEntry.addElement("question").addText("Question");
        newPainReassessmentEntry.add(newConcernOfExcersizeInjuryEntry);
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                Element element = DocumentHelper.createElement((String)"recordIdentifier");
                element.addElement("identity").addText(this.recordIdentifier);
                element.addElement("namespaceId").addText("NamespaceId");
                element.addElement("universalId").addText("UniversalId");
                element.addElement("universalIdType").addText("UniversalIdType");
                newPainReassessmentEntry.add(element);
            } else {
                Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
                newPainReassessmentEntry.add(newRecordIdentifier);
            }
        }
        return newPainReassessmentEntry;
    }

    public Element makePainReassessment(String elementName, String recordIdentifier, String recordStatus) {
        Element newPainReassessments = DocumentHelper.createElement((String)elementName);
        Element newPainReassessment = DocumentHelper.createElement((String)"painReassessment");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newPainReassessment.add(newRecordIdentifier);
        newPainReassessment.addElement("recordStatus").addText(recordStatus);
        newPainReassessments.add(newPainReassessment);
        return newPainReassessments;
    }

    public Element makePainReassessment(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newPainReassessments = DocumentHelper.createElement((String)"painReassessments");
        List<Element> painReassessmentList = this.makePainReassessments(countObservations, patientIdentifier, updateRecordXml);
        for (Element painReassessment : painReassessmentList) {
            newPainReassessments.add(painReassessment);
        }
        return newPainReassessments;
    }

    @Override
    public String fillPrintBuffer(Object aObject) {
        return null;
    }
}

