/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.HAPainAssessmentBuilder;
import org.dom4j.Document;
import org.dom4j.Element;

public class HAPainAssessmentBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HAPainAssessmentBuilder painAssessmentBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        Element patient = rootElement.element("patient");
        Element newPainAssessments = this.painAssessmentBuilder.makePainAssessment("painAssessments", recordIdentifier, recordStatus);
        patient.add(newPainAssessments);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element newPainReassessments = this.painAssessmentBuilder.makePainAssessment(patientIdentifier, count, updateRecordXml);
        patient.add(newPainReassessments);
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setPainAssessmentBuilder((HAPainAssessmentBuilder)builder);
    }

    public HAPainAssessmentBuilder getAssessmentBuilder() {
        return this.painAssessmentBuilder;
    }

    public void setPainAssessmentBuilder(HAPainAssessmentBuilder painAssessmentBuilder) {
        this.painAssessmentBuilder = painAssessmentBuilder;
    }
}

