/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAMoodJournalBuilder
extends AbstractEntryPointBuilder {
    private int index;
    private static final String[] moods = new String[]{"Love", "Sad", "Depressed", "Jealous", "Greed", "Grumpy", "Anxiety", "Hopeful", "Angry", "Happy", "Fear"};
    private static final String[] worldTimezoneOffsets = new String[]{"+0000", "+0100", "+0200", "+0300", "+0330", "+0400", "+0430", "+0500", "+0530", "+0600", "+0630", "+0700", "+0800", "+0900", "+0930", "+1000", "+1100", "+1200", "-1100", "-1000", "-0930", "-0900", "-0830", "-0800", "-0700", "-0600", "-0500", "-0400", "-0330", "-0300", "-0200", "-0100"};
    private String recordIdentifier;
    private String updatedMood;
    private String attachmentName;

    public HAMoodJournalBuilder() {
    }

    public HAMoodJournalBuilder(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public HAMoodJournalBuilder(String recordIdentifier, String updatedMood, String attachmentName) {
        this.recordIdentifier = recordIdentifier;
        this.updatedMood = updatedMood;
        this.attachmentName = attachmentName;
    }

    public List<Element> makeJournalEntries(int number) {
        return this.makeJournalEntries(number, null);
    }

    public List<Element> makeJournalEntries(int number, Element patient) {
        return this.makeJournalEntries(number, patient, true);
    }

    public List<Element> makeJournalEntries(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makeJournalEntry("patientjournaling:patientEnteredMoodJournalEntry", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeJournalEntry("PatientJournalEntry", personIdentifier);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier) {
        return this.makeJournalEntry(elementName, patientIdentifier, false);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.index;
        Element newPatientJournalEntry = DocumentHelper.createElement((String)elementName);
        newPatientJournalEntry.add(this.createSimpleStringElement("mood", updateRecordXml ? this.updatedMood : this.getRandomMood()));
        newPatientJournalEntry.add(this.createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, this.index, updateRecordXml, HAMoodJournalBuilder.getDateTodayWithRandomTimezoneOffset(), this.recordIdentifier, null));
        return newPatientJournalEntry;
    }

    public Element makeMoodJournalEntry(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element patientJournalEntries = DocumentHelper.createElement((String)"patientJournalEntries");
        List<Element> patientJournalEntryList = this.makeJournalEntries(countObservations, patientIdentifier, updateRecordXml);
        for (Element patientJournalEntry : patientJournalEntryList) {
            patientJournalEntries.add(patientJournalEntry);
        }
        return patientJournalEntries;
    }

    public static String getDateTodayWithRandomTimezoneOffset() {
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        date = date + HAMoodJournalBuilder.getRandomXsTimezoneOffset();
        return date;
    }

    public static String getRandomXsTimezoneOffset() {
        int index = (int)Math.round(Math.random() * (double)(worldTimezoneOffsets.length - 1));
        return worldTimezoneOffsets[index];
    }

    private String getRandomMood() {
        int index = (int)Math.round(Math.random() * (double)(moods.length - 1));
        return moods[index];
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }

    @Override
    protected Element createGenericJournalEntryDetails(String elementName, Element patientIdentifier, int index, boolean updateRecordXml, String xsdDateString, String recordIdentifier, String attachmentName) {
        Element genericJournalEntryDetailsElement = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText("USDOD");
        }
        genericJournalEntryDetailsElement.add(newPatient);
        if (updateRecordXml) {
            Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
            genericJournalEntryDetailsElement.add(newRecordIdentifier);
        }
        genericJournalEntryDetailsElement.addElement("journalEntryType").addText("JournalEntryType");
        genericJournalEntryDetailsElement.addElement("allowAccessByClinicalStaff").addText("false");
        genericJournalEntryDetailsElement.addElement("comments").addText("Comments");
        Element newObservationDate = xsdDateString == null || xsdDateString.trim().equals("") ? this.createFixedPointInTime("observationDate") : this.createPointInTime("observationDate", xsdDateString);
        genericJournalEntryDetailsElement.add(newObservationDate);
        Element binaryAttachmentsElement = this.createBase64BinaryAttachmentsElement(this.attachmentName);
        genericJournalEntryDetailsElement.add(binaryAttachmentsElement);
        genericJournalEntryDetailsElement.addElement("dataEnterer").addText("DataEnterer");
        return genericJournalEntryDetailsElement;
    }
}

