/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAGoalTrackingBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private String recordIdentifier;
    private String goalName;
    private String goalEntryDate;
    private int IDX;

    public HAGoalTrackingBuilder() {
    }

    public HAGoalTrackingBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAGoalTrackingBuilder(String recordIdentifier, String goalEntryDate) {
        this.recordIdentifier = recordIdentifier;
        this.goalEntryDate = goalEntryDate;
    }

    public HAGoalTrackingBuilder(String recordIdentifier, String goalName, String goalEntryDate) {
        this.recordIdentifier = recordIdentifier;
        this.goalName = goalName;
        this.goalEntryDate = goalEntryDate;
    }

    public HAGoalTrackingBuilder(Random random) {
        super(random);
    }

    public List<Element> makeGoalsTracking(int number) {
        return this.makeGoalsTracking(number, null);
    }

    public List<Element> makeGoalsTracking(int number, Element patient) {
        return this.makeGoalsTracking(number, patient, true);
    }

    public List<Element> makeGoalsTracking(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> goalsTracking = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            goalsTracking.add(this.makeGoalTracking("goalTracking", patient, updateRecordXml));
        }
        return goalsTracking;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeGoalTracking("goalTracking", personIdentifier);
    }

    public Element makeGoalTracking(String elementName, Element patientIdentifier) {
        return this.makeGoalTracking(elementName, patientIdentifier, false);
    }

    public Element makeGoalTracking(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newGoalTracking = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText(ASSIGNINGAUTHORITY_HDR);
        }
        newGoalTracking.add(newPatient);
        Element newGoalTrackingDate = this.goalEntryDate != null ? this.createPointInTime("entryDate", this.goalEntryDate) : this.createFixedPointInTime("entryDate");
        newGoalTracking.add(newGoalTrackingDate);
        newGoalTracking.addElement("completionPercent").addText("25");
        newGoalTracking.addElement("comments").addText("comments");
        newGoalTracking.addElement("dataEnterer").addText("dataEnterer");
        newGoalTracking.addElement("allowAccessByClinicalStaff").addText("true");
        newGoalTracking.addElement("goalName").addText(this.goalName != null ? this.goalName : "goalName");
        newGoalTracking.addElement("goalType").addText("goalType");
        newGoalTracking.addElement("goalDetails").addText("goalDetails");
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                Element element = DocumentHelper.createElement((String)"recordIdentifier");
                element.addElement("identity").addText(this.recordIdentifier);
                element.addElement("namespaceId").addText("NamespaceId");
                element.addElement("universalId").addText("UniversalId");
                element.addElement("universalIdType").addText("UniversalIdType");
                newGoalTracking.add(element);
            } else {
                Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
                newGoalTracking.add(newRecordIdentifier);
            }
        }
        return newGoalTracking;
    }

    public Element makeGoalTracking(String elementName, String recordIdentifier, String recordStatus) {
        Element newGoalsTracking = DocumentHelper.createElement((String)elementName);
        Element newGoalTracking = DocumentHelper.createElement((String)"goalTracking");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newGoalTracking.add(newRecordIdentifier);
        newGoalTracking.addElement("recordStatus").addText(recordStatus);
        newGoalsTracking.add(newGoalTracking);
        return newGoalsTracking;
    }

    public Element makeGoalTracking(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newGoalsTracking = DocumentHelper.createElement((String)"goalsTracking");
        List<Element> goalTrackingList = this.makeGoalsTracking(countObservations, patientIdentifier, updateRecordXml);
        for (Element goalTracking : goalTrackingList) {
            newGoalsTracking.add(goalTracking);
        }
        return newGoalsTracking;
    }

    @Override
    public String fillPrintBuffer(Object aObject) {
        return null;
    }

    public void setGoalName(String goalName) {
        this.goalName = goalName;
    }

    public void setGoalEntryDate(String goalEntryDate) {
        this.goalEntryDate = goalEntryDate;
    }
}

