/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAExerciseJournalBuilder
extends AbstractEntryPointBuilder {
    private int IDX;
    private String recordIdentifier;
    private String physicalQty;
    private static final String[] ACTIVITY_TYPE = new String[]{"activityType1", "activityType2", "activityType3", "activityType4"};
    private static final String[] EXERCISE_INTENSITY = new String[]{"exerciseIntensity1", "exerciseIntensity2", "exerciseIntensity3", "exerciseIntensity4"};

    public HAExerciseJournalBuilder() {
    }

    public HAExerciseJournalBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAExerciseJournalBuilder(String recordIdentifier, String physicalQty) {
        this.recordIdentifier = recordIdentifier;
        this.physicalQty = physicalQty;
    }

    public HAExerciseJournalBuilder(Random random) {
        super(random);
    }

    public List<Element> makeJournalEntries(int number) {
        return this.makeJournalEntries(number, null);
    }

    public List<Element> makeJournalEntries(int number, Element patient) {
        return this.makeJournalEntries(number, patient, true);
    }

    public List<Element> makeJournalEntries(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makeJournalEntry("patientjournaling:patientEnteredExerciseJournalEntry", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeJournalEntry("patientjournaling:patientEnteredExerciseJournalEntry", personIdentifier);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier) {
        return this.makeJournalEntry(elementName, patientIdentifier, false);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPatientJournalEntry = DocumentHelper.createElement((String)elementName);
        Element newActivityType = this.createHL72CodedElementLite("activityType", "ActivityType", ACTIVITY_TYPE);
        newPatientJournalEntry.add(newActivityType);
        Element newExerciseIntensity = this.createHL72CodedElementLite("exerciseIntensity", "ExerciseIntensity", EXERCISE_INTENSITY);
        newPatientJournalEntry.add(newExerciseIntensity);
        if (this.physicalQty != null) {
            newPatientJournalEntry.add(this.createPhysicalQuantity("activityDuration", this.physicalQty));
        } else {
            newPatientJournalEntry.add(this.createPhysicalQuantity("activityDuration", "ActivityDuration"));
        }
        newPatientJournalEntry.add(this.createPhysicalQuantity("activityDistance", "ActivityDistance"));
        if (this.recordIdentifier != null) {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetailsRecordId("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml, this.recordIdentifier));
        } else {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml));
        }
        return newPatientJournalEntry;
    }

    public Element makeExerciseJournalEntry(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element patientJournalEntries = DocumentHelper.createElement((String)"patientJournalEntries");
        List<Element> patientJournalEntryList = this.makeJournalEntries(countObservations, patientIdentifier, updateRecordXml);
        for (Element patientJournalEntry : patientJournalEntryList) {
            patientJournalEntries.add(patientJournalEntry);
        }
        return patientJournalEntries;
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

