/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HACalendarEventBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private String recordIdentifier;
    private String title;
    private String calendarEventStartDate;
    private int IDX;

    public HACalendarEventBuilder() {
    }

    public HACalendarEventBuilder(String recordIdentifier, String title) {
        this.recordIdentifier = recordIdentifier;
        this.title = title;
    }

    public HACalendarEventBuilder(String recordIdentifier, String title, String calendarEventStartDate) {
        this.recordIdentifier = recordIdentifier;
        this.title = title;
        this.calendarEventStartDate = calendarEventStartDate;
    }

    public HACalendarEventBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HACalendarEventBuilder(Random random) {
        super(random);
    }

    public List<Element> makeCalendarEvents(int number) {
        return this.makeCalendarEvents(number, null);
    }

    public List<Element> makeCalendarEvents(int number, Element patient) {
        return this.makeCalendarEvents(number, patient, true);
    }

    public List<Element> makeCalendarEvents(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makeCalendarEvent("calendarEvent", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeCalendarEvent("patientJournalEntry", personIdentifier);
    }

    public Element makeCalendarEvent(String elementName, Element patientIdentifier) {
        return this.makeCalendarEvent(elementName, patientIdentifier, false);
    }

    public Element makeCalendarEvent(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newCalendarEventEntry = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText(ASSIGNINGAUTHORITY_HDR);
        }
        newCalendarEventEntry.add(newPatient);
        if (this.title != null) {
            newCalendarEventEntry.addElement("calendarEventTitle").addText(this.title);
        } else {
            newCalendarEventEntry.addElement("calendarEventTitle").addText("CalendarEventTitle");
        }
        Element newCalendarEventStartDate = this.calendarEventStartDate != null ? this.createPointInTime("calendarEventStartDate", this.calendarEventStartDate) : this.createFixedPointInTime("calendarEventStartDate");
        newCalendarEventEntry.add(newCalendarEventStartDate);
        Element newCalendarEventStopDate = this.createFixedPointInTime("calendarEventStopDate");
        newCalendarEventEntry.add(newCalendarEventStopDate);
        Element newCalendarEventReminderDateTime = this.createFixedPointInTime("calendarEventReminderDateTime");
        newCalendarEventEntry.add(newCalendarEventReminderDateTime);
        newCalendarEventEntry.addElement("calendarEventNote").addText("CalendarEventNote");
        newCalendarEventEntry.addElement("repeatFrequency").addText("1");
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                Element element = DocumentHelper.createElement((String)"recordIdentifier");
                element.addElement("identity").addText(this.recordIdentifier);
                element.addElement("namespaceId").addText("NamespaceId");
                element.addElement("universalId").addText("UniversalId");
                element.addElement("universalIdType").addText("UniversalIdType");
                newCalendarEventEntry.add(element);
            } else {
                Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
                newCalendarEventEntry.add(newRecordIdentifier);
            }
        }
        return newCalendarEventEntry;
    }

    public Element makeCalendarEvent(String elementName, String recordIdentifier, String recordStatus) {
        Element newCalendarEvents = DocumentHelper.createElement((String)elementName);
        Element newCalendarEvent = DocumentHelper.createElement((String)"calendarEvent");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newCalendarEvent.add(newRecordIdentifier);
        newCalendarEvent.addElement("recordStatus").addText(recordStatus);
        newCalendarEvents.add(newCalendarEvent);
        return newCalendarEvents;
    }

    public Element makeCalendarEvent(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newCalendarEvents = DocumentHelper.createElement((String)"calendarEvents");
        List<Element> calendarEventList = this.makeCalendarEvents(countObservations, patientIdentifier, updateRecordXml);
        for (Element calendarEvent : calendarEventList) {
            newCalendarEvents.add(calendarEvent);
        }
        return newCalendarEvents;
    }

    @Override
    public String fillPrintBuffer(Object aObject) {
        return null;
    }
}

