/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class FilterBuilder {
    public static final String NO_XPATH = "";
    public static final String NO_XPATH_QUERY = "";
    public static final String ASSESSMENT_XPATH = "allergyAssessments[status != 'E']";
    public static final String IC_XPATH = "intoleranceConditions[status != 'E']";
    public static final String VITALS_HTH_XPATH = "vitalSignObservationEvents[((recordSource/namespaceId[starts-with(., '200T')]) and (status != 'E'))]";
    public static final String VITALS_VISTA_XPATH = "vitalSignObservationEvents[((recordSource/namespaceId[not(starts-with(.,'200T'))]) and (status != 'E'))]";
    public static final String VITALS_XPATH = "vitalSignObservationEvents[status != 'E']";
    public static final String RDI_IC_XPATH = "intoleranceConditions[((gmrAllergyAgent[(code!='') and (codingSystem = '99VHA_ERT' or contains(.,'99VA'))]) or (drugClass/code[(code!='') and (codingSystem = '99VHA_ERT' or contains(.,'99VA'))]) or (drugIngredient/code[(code!='') and (codingSystem = '99VHA_ERT' or contains(.,'99VA'))])) and (status = 'F')]";
    public static final String RDI_RX_XPATH = "outpatientMedicationPromises[pharmacyRequest/orderedMedication/medicationCode[(code!='') and (codingSystem = '99VHA_ERT' or contains(.,'99VA'))]]";
    public static final String REQUEST_ID_XPATH = "ClinicalData/requestId";
    public static final String DOMAIN_ENTRYPOINT_KEY = "domainEntryPoint";
    public static final String START_DATE_KEY = "startDate";
    public static final String END_DATE_KEY = "endDate";
    public static final String QUERY_TIMEOUT_SECONDS = "queryTimeoutSeconds";
    public static final String QUERY_NAME_KEY = "queryName";
    public static final String PATIENT_CENTRIC_KEY = "isPatientCentric";
    public static final String FACILITY_ID_KEY = "facilityId";
    public static final String X_PATH_KEY = "xPath";
    public static final String XPATH_QUERY = "xpathQuery";
    public static final String RECORD_IDENTITY = "identity";
    public static final String NAMESPACEID = "namespaceId";
    public static final String UNIVERSALID = "universalId";
    public static final String UNIVERSALIDTYPE = "universalIdType";
    public static final String OTHERQUERYPARAMETERS = "otherQueryParameters";
    public static final String ASSIGNING_AUTHORITY_KEY = "assigningAuthority";
    public static final String ASSIGNING_FACILITY = "assigningFacility";
    public static final String IDENTITY = "identity";

    public static Document buildEmptyFilterDocument() {
        Namespace filterNamespace = DocumentHelper.createNamespace((String)"filter", (String)"Filter");
        Element filterElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"filter", (Namespace)filterNamespace));
        return DocumentHelper.createDocument((Element)filterElement);
    }

    public static Element createPatient(String elementName, String assigningAuthority, String assigningFacility, String identity) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createPersonIdentifier("resolvedIdentifiers", assigningAuthority, assigningFacility, identity));
        return element;
    }

    public static Element createPatient(String elementName, String dodPatient, String vistAPatient, Map<String, String> assigningFacilityAndPatientIdentityMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        String assigningAuthority = null;
        String assigningFacility = null;
        String patientIdentity = null;
        for (Map.Entry<String, String> entry : assigningFacilityAndPatientIdentityMap.entrySet()) {
            assigningAuthority = entry.getKey();
            assigningFacility = entry.getValue();
            patientIdentity = assigningAuthority.equals("USDOD") ? dodPatient : vistAPatient;
            element.add(FilterBuilder.createPersonIdentifier("resolvedIdentifiers", assigningAuthority, assigningFacility, patientIdentity));
        }
        return element;
    }

    public static Element createPatient(String elementName, String assigningAuthority, Map<String, String> assigningFacilityAndPatientIdentityMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        for (Map.Entry<String, String> entry : assigningFacilityAndPatientIdentityMap.entrySet()) {
            String assigningFacility = entry.getKey();
            String patientIdentity = entry.getValue();
            element.add(FilterBuilder.createPersonIdentifier("resolvedIdentifiers", assigningAuthority, assigningFacility, patientIdentity));
        }
        return element;
    }

    public static Element createPatientWithEdipi(String elementName, String patientIdentifier, List<Element> excludeIdentifiers, String assigningAuthority, String assigningFacility) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createPersonIdentifier("EdiPi", assigningAuthority, assigningFacility, patientIdentifier));
        if (excludeIdentifiers != null) {
            for (Element excludeIdentifier : excludeIdentifiers) {
                element.add(excludeIdentifier);
            }
        }
        return element;
    }

    public static Element createPatientWithNationalId(String elementName, String nationalId, List<Element> excludeIdentifiers) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addElement("NationalId").addText(nationalId);
        if (excludeIdentifiers != null) {
            for (Element excludeIdentifier : excludeIdentifiers) {
                element.add(excludeIdentifier);
            }
        }
        return element;
    }

    public static Element createPatientWithNationalIdAndExcludeIdentifiers(String elementName, String nationalId, List<Map<String, String>> excludeIdentifiers) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addElement("NationalId").addText(nationalId);
        for (Map<String, String> excludeIdentifier : excludeIdentifiers) {
            String assigningAuthority = excludeIdentifier.get(ASSIGNING_AUTHORITY_KEY);
            String assigningFacility = excludeIdentifier.get(ASSIGNING_FACILITY);
            element.add(FilterBuilder.createCHDRExcludeIdentifier("excludeIdentifiers", assigningAuthority, assigningFacility));
        }
        return element;
    }

    public static Element buildFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientRequestInitiationTime("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String universalIdType;
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String xPath = null;
            if (filterId.equals("RDI_IC_RX_SINGLE_PATIENT_FILTER")) {
                String xpathQuery;
                String string = entryFilterMap != null ? (entryFilterMap.get(XPATH_QUERY) != null ? entryFilterMap.get(XPATH_QUERY) : "") : (xpathQuery = "");
                if (domainEntryPoint.equals("IntoleranceCondition")) {
                    xPath = RDI_IC_XPATH;
                } else if (domainEntryPoint.equals("OutpatientMedicationPromise")) {
                    xPath = RDI_RX_XPATH;
                }
            } else {
                xPath = entryFilterMap != null ? (entryFilterMap.get(X_PATH_KEY) != null ? entryFilterMap.get(X_PATH_KEY) : "") : "";
            }
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String recordIdentity = entryFilterMap != null ? entryFilterMap.get("identity") : null;
            String namespaceId = entryFilterMap != null ? entryFilterMap.get(NAMESPACEID) : null;
            String universalId = entryFilterMap != null ? entryFilterMap.get(UNIVERSALID) : null;
            String string2 = universalIdType = entryFilterMap != null ? entryFilterMap.get(UNIVERSALIDTYPE) : null;
            if (recordIdentity != null && !recordIdentity.equals("")) {
                element.add(FilterBuilder.createEntryFilterWithRecordIdentifiers("entryPointFilter", domainEntryPoint, recordIdentity, namespaceId, universalId, universalIdType, queryName, queryTimeoutSeconds));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, xPath, queryTimeoutSeconds));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element buildFilterElementWithOptionalParams(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime, Map<String, String> optionalParamsMap, String xpath) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientRequestInitiationTime("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String xPath = null;
            xPath = entryFilterMap != null ? (entryFilterMap.get(xpath) != null ? entryFilterMap.get(X_PATH_KEY) : "") : "";
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String recordIdentity = entryFilterMap != null ? entryFilterMap.get("identity") : null;
            String namespaceId = entryFilterMap != null ? entryFilterMap.get(NAMESPACEID) : null;
            String universalId = entryFilterMap != null ? entryFilterMap.get(UNIVERSALID) : null;
            String universalIdType = entryFilterMap != null ? entryFilterMap.get(UNIVERSALIDTYPE) : null;
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, xpath, queryTimeoutSeconds, null, null, optionalParamsMap));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static String buildSiteCentricFilterWithOptionalParams(String filterId, List<Map<String, String>> entryPointFilterMaps, String clientRequestInitiationTime, String clientName, Map<String, String> optionalParamsMap) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", clientName));
        element.add(FilterBuilder.createClientRequestInitiationTime("clientRequestInitiationTime", clientRequestInitiationTime));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String patientCentric = entryFilterMap != null ? entryFilterMap.get(PATIENT_CENTRIC_KEY) : null;
            String facilityId = entryFilterMap != null ? entryFilterMap.get(FACILITY_ID_KEY) : null;
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            element.add(FilterBuilder.createEntryFilterWithoutIdentifiers("entryPointFilter", domainEntryPoint, queryName, patientCentric, facilityId, queryTimeoutSeconds, optionalParamsMap));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static String buildFilterWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime) {
        return FilterBuilder.buildFilterWithEdiPi(filterId, entryPointFilterMaps, patients, clientRequestInitiationTime, "filter:defaultDomainEntryPointFilter");
    }

    public static String buildFilterWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime, String specializedEntryFilterElementName) {
        return FilterBuilder.buildFilterWithEdiPi(filterId, entryPointFilterMaps, patients, clientRequestInitiationTime, specializedEntryFilterElementName, null);
    }

    public static String buildFilterWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime, String specializedEntryFilterElementName, Map<String, String> optionalQueryParameters) {
        Element element = FilterBuilder.buildFilterElementWithEdiPi(filterId, entryPointFilterMaps, patients, clientRequestInitiationTime, specializedEntryFilterElementName, optionalQueryParameters);
        return element.asXML();
    }

    public static Element buildFilterElementWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime, String specializedEntryPointFilterName, Map<String, String> optionalParamsMap) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientRequestInitiationTime("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithEdiPi("patients", patients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String recordIdentity = entryFilterMap != null ? entryFilterMap.get("identity") : null;
            String namespaceId = entryFilterMap != null ? entryFilterMap.get(NAMESPACEID) : null;
            String universalId = entryFilterMap != null ? entryFilterMap.get(UNIVERSALID) : null;
            String universalIdType = entryFilterMap != null ? entryFilterMap.get(UNIVERSALIDTYPE) : null;
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, null, queryTimeoutSeconds, null, specializedEntryPointFilterName, optionalParamsMap));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element buildFilterElementWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime, String specializedEntryPointFilterName) {
        return FilterBuilder.buildFilterElementWithEdiPi(filterId, entryPointFilterMaps, patients, clientRequestInitiationTime, specializedEntryPointFilterName, null);
    }

    public static Element buildFilterElementWithEdiPi(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> patients, String clientRequestInitiationTime) {
        return FilterBuilder.buildFilterElementWithEdiPi(filterId, entryPointFilterMaps, patients, clientRequestInitiationTime, "filter:defaultDomainEntryPointFilter");
    }

    public static String buildFilterWithNationalId(String filterId, List<Map<String, String>> entryPointFilterMaps, String nationalId, String clientRequestInitiationTime) {
        return FilterBuilder.buildFilterWithNationalId(filterId, entryPointFilterMaps, nationalId, clientRequestInitiationTime, null);
    }

    public static String buildFilterWithNationalId(String filterId, List<Map<String, String>> entryPointFilterMaps, String nationalId, String clientRequestInitiationTime, String specializedDomainEntryPoint) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithNationalId("patients", nationalId, null));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String xPath;
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            String string2 = entryFilterMap != null ? (entryFilterMap.get(X_PATH_KEY) != null ? entryFilterMap.get(X_PATH_KEY) : "") : (xPath = "");
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, xPath, queryTimeoutSeconds, null, specializedDomainEntryPoint, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static Element buildFilterElementWithResolvedIdentfiers2x(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String universalIdType;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String xPath = null;
            if (filterId.equals("RDI_IC_RX_SINGLE_PATIENT_FILTER")) {
                String xpathQuery;
                String string = entryFilterMap != null ? (entryFilterMap.get(XPATH_QUERY) != null ? entryFilterMap.get(XPATH_QUERY) : "") : (xpathQuery = "");
                if (domainEntryPoint.equals("IntoleranceCondition")) {
                    xPath = RDI_IC_XPATH;
                } else if (domainEntryPoint.equals("OutpatientMedicationPromise")) {
                    xPath = RDI_RX_XPATH;
                }
            } else {
                String string = entryFilterMap != null ? (entryFilterMap.get(X_PATH_KEY) != null ? entryFilterMap.get(X_PATH_KEY) : "") : (xPath = "");
            }
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String recordIdentity = entryFilterMap != null ? entryFilterMap.get("identity") : null;
            String namespaceId = entryFilterMap != null ? entryFilterMap.get(NAMESPACEID) : null;
            String universalId = entryFilterMap != null ? entryFilterMap.get(UNIVERSALID) : null;
            String string = universalIdType = entryFilterMap != null ? entryFilterMap.get(UNIVERSALIDTYPE) : null;
            if (recordIdentity != null && !recordIdentity.equals("")) {
                element.add(FilterBuilder.createEntryFilterWithRecordIdentifiers("entryPointFilter", domainEntryPoint, recordIdentity, namespaceId, universalId, universalIdType, queryName, null));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, xPath, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static String buildFilterWithResolvedIdentfiers2x(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Element element = FilterBuilder.buildFilterElementWithResolvedIdentfiers2x(filterId, entryPointFilterMaps, resolvedPatients, clientRequestInitiationTime);
        return element.asXML();
    }

    public static String buildFilterWithNationalIdAndExcludeIdentifiers(String filterId, List<Map<String, String>> entryPointFilterMaps, String nationalId, List<Map<String, String>> excludeIdentifiers, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithNationalIdAndExcludeIdentifiers("patients", nationalId, excludeIdentifiers));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String xPath;
            String endDate;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String string = endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            String string2 = entryFilterMap != null ? (entryFilterMap.get(X_PATH_KEY) != null ? entryFilterMap.get(X_PATH_KEY) : "") : (xPath = "");
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, xPath, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static String buildFilterWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Element element = FilterBuilder.buildFilterElementWithResolvedIdentfiers(filterId, entryPointFilterMaps, resolvedPatients, clientRequestInitiationTime);
        return element.asXML();
    }

    public static String buildFilterWithAddionalParms(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime, Map<String, String> optionalParamsMap, String xpath) {
        Element element = FilterBuilder.buildFilterElementWithOptionalParams(filterId, entryPointFilterMaps, resolvedPatients, clientRequestInitiationTime, optionalParamsMap, xpath);
        return element.asXML();
    }

    public static String buildFilterWithResolvedIdentfiersTimeout(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime, String timoutSeconds) {
        Element element = FilterBuilder.buildFilterElementWithResolvedIdentfiers(filterId, entryPointFilterMaps, resolvedPatients, clientRequestInitiationTime);
        return element.asXML();
    }

    public static String buildDetailFilterWithRecordIdentifier(String filterId, Map<String, String> entryPointFilterMap, String clientRequestInitiationTime) {
        String queryName;
        String queryTimeoutSeconds;
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        if (clientRequestInitiationTime != null) {
            element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        }
        String domainEntryPoint = entryPointFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
        String string = queryTimeoutSeconds = entryPointFilterMap != null ? entryPointFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
        String string2 = entryPointFilterMap != null ? (entryPointFilterMap.get(QUERY_NAME_KEY) != null ? entryPointFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
        String patientCentric = entryPointFilterMap != null ? (entryPointFilterMap.get(PATIENT_CENTRIC_KEY) != null ? entryPointFilterMap.get(PATIENT_CENTRIC_KEY) : "false") : "false";
        String recordIdentity = entryPointFilterMap.get("identity");
        String namespaceId = entryPointFilterMap.get(NAMESPACEID);
        String universalId = entryPointFilterMap.get(UNIVERSALID);
        String universalIdType = entryPointFilterMap.get(UNIVERSALIDTYPE);
        element.add(FilterBuilder.createEntryFilterWithRecordIdentifiers("entryPointFilter", domainEntryPoint, recordIdentity, namespaceId, universalId, universalIdType, queryName, patientCentric, queryTimeoutSeconds));
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static String buildHealthAdapterJournalDetailsFilter(String domainEntryPoint, String recordIdentifier, Map<String, String> otherQueryParameters) {
        if (domainEntryPoint == null || domainEntryPoint.trim().equals("")) {
            throw new IllegalArgumentException("domainEntryPoint argument cannot be null or empty string");
        }
        if (recordIdentifier == null || recordIdentifier.trim().equals("")) {
            throw new IllegalArgumentException("recordIdentifier argument cannot be null or empty string");
        }
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.addAttribute("vhimVersion", "Vhim_4_00");
        element.addAttribute("xsi:schemaLocation", "Filter Health_Adapter_Journal_Detail_Filter.xsd");
        element.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.add(FilterBuilder.createFilterId("filterId", "HEALTH_ADAPTER_JOURNAL_DETAIL_FILTER"));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(DocumentHelper.createElement((String)"clientRequestInitiationTime").addText("2001-12-17T09:30:47Z"));
        Element entryPointFilterElement = DocumentHelper.createElement((String)"entryPointFilter");
        Attribute queryNameAttribute = DocumentHelper.createAttribute((Element)entryPointFilterElement, (String)QUERY_NAME_KEY, (String)"ID_1");
        entryPointFilterElement.add(queryNameAttribute);
        Attribute isPatientCentricAttribute = DocumentHelper.createAttribute((Element)entryPointFilterElement, (String)PATIENT_CENTRIC_KEY, (String)"false");
        entryPointFilterElement.add(isPatientCentricAttribute);
        Element domainEntryPointElement = DocumentHelper.createElement((String)DOMAIN_ENTRYPOINT_KEY);
        domainEntryPointElement.setText(domainEntryPoint);
        entryPointFilterElement.add(domainEntryPointElement);
        Element recordIdentifiersElement = DocumentHelper.createElement((String)"recordIdentifiers");
        Element identityElement = DocumentHelper.createElement((String)"identity").addText(recordIdentifier);
        recordIdentifiersElement.add(identityElement);
        entryPointFilterElement.add(recordIdentifiersElement);
        if (otherQueryParameters != null && !otherQueryParameters.isEmpty()) {
            Element otherQueryParametersElement = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            for (String key : otherQueryParameters.keySet()) {
                otherQueryParametersElement.add(DocumentHelper.createElement((String)key).addText(otherQueryParameters.get(key)));
            }
            entryPointFilterElement.add(otherQueryParametersElement);
        }
        element.add(entryPointFilterElement);
        return element.asXML();
    }

    public static Element createPatientWithResolvedIdentifiers(String elementName, List<Map<String, String>> resolvedPatients) {
        Element element = DocumentHelper.createElement((String)elementName);
        for (Map<String, String> patient : resolvedPatients) {
            String assigningAuthority = patient.get(ASSIGNING_AUTHORITY_KEY);
            String assigningFacility = patient.get(ASSIGNING_FACILITY);
            String patientIdentity = patient.get("identity");
            element.add(FilterBuilder.createPersonIdentifier("resolvedIdentifiers", assigningAuthority, assigningFacility, patientIdentity));
        }
        return element;
    }

    public static Element createPatientWithEdiPi(String elementName, List<Map<String, String>> patients) {
        Element element = DocumentHelper.createElement((String)elementName);
        for (Map<String, String> patient : patients) {
            String assigningAuthority = patient.get(ASSIGNING_AUTHORITY_KEY);
            String assigningFacility = patient.get(ASSIGNING_FACILITY);
            String patientIdentity = patient.get("identity");
            element.add(FilterBuilder.createPersonIdentifier("EdiPi", assigningAuthority, assigningFacility, patientIdentity));
        }
        return element;
    }

    public static Element createCHDRPatient(String elementName, String nationalId, String assigningAuthority, String assigningFacility) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addElement("NationalId").setText(nationalId);
        element.add(FilterBuilder.createCHDRExcludeIdentifier("excludeIdentifiers", assigningAuthority, assigningFacility));
        return element;
    }

    public static Element createPersonIdentifier(String elementName, String assigningAuthority, String assigningFacility, String identity) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addElement(ASSIGNING_AUTHORITY_KEY).addText(assigningAuthority);
        element.addElement(ASSIGNING_FACILITY).addText(assigningFacility);
        element.addElement("identity").addText(identity);
        return element;
    }

    public static Element createEntityIdentifier(String elementName) {
        return BaseDatatypesBuilder.createHL72EntityIdentifier(elementName);
    }

    public static Element createEntityIdentifier(String elementName, String identity, String namespaceId, String universalId) {
        return BaseDatatypesBuilder.createHL72EntityIdentifier(elementName, identity, namespaceId, universalId);
    }

    public static Element createEntityIdentifier(String elementName, String identity, String namespaceId, String universalId, String universalIdType) {
        return BaseDatatypesBuilder.createHL72EntityIdentifier(elementName, identity, namespaceId, universalId, universalIdType);
    }

    public static Element createEntryFilter(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String xpath, String queryTimeoutSeconds, String clientRequestInitiationTime, String specializedDomainEntryPointFilter, Map<String, String> optionalParamsMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (xpath != null && xpath.length() > 0) {
            element.add(FilterBuilder.createXpathQuery(XPATH_QUERY, xpath));
        }
        if (optionalParamsMap != null) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            for (Map.Entry<String, String> optionalParam : optionalParamsMap.entrySet()) {
                if (optionalParam.getValue() == null || optionalParam.getValue().length() <= 0) continue;
                otherQueryParameters.add(DocumentHelper.createElement((String)optionalParam.getKey()).addText(optionalParam.getValue()));
            }
            element.add(otherQueryParameters);
        }
        if (queryTimeoutSeconds != null) {
            element.add(FilterBuilder.createDateParameter(QUERY_TIMEOUT_SECONDS, queryTimeoutSeconds));
        }
        if (clientRequestInitiationTime != null) {
            element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createEntryFilter(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String xpath, String queryTimeoutSeconds) {
        return FilterBuilder.createEntryFilter(elementName, domainEntryPoint, startDate, endDate, queryName, xpath, queryTimeoutSeconds, null);
    }

    public static Element createEntryFilter(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String xpath, String queryTimeoutSeconds, String clientRequestInitiationTime) {
        return FilterBuilder.createEntryFilter(elementName, domainEntryPoint, startDate, endDate, queryName, xpath, queryTimeoutSeconds, clientRequestInitiationTime, null, null);
    }

    public static Element createEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String documentClassValue, String[] documentTypeValues, String queryName, String xQueryCriteria) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (null != documentClassValue && documentClassValue.length() > 0 || null != documentTypeValues && documentTypeValues.length > 0) {
            element.add(FilterBuilder.createAdditionalParameters(OTHERQUERYPARAMETERS, documentClassValue, documentTypeValues));
        }
        if (xQueryCriteria != null) {
            Element orderByElement = DocumentHelper.createElement((String)"orderBy");
            orderByElement.add(DocumentHelper.createElement((String)"xqueryExpression").addText(xQueryCriteria));
            element.add(orderByElement);
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createOutpatientMedicationPromiseEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createOutpatientMedicationPromiseEntryFilterWithXpath(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        element.add(FilterBuilder.createXpathQuery(XPATH_QUERY, "outpatientMedicationPromises[pharmacyRequest/statusModifier[contains(displayText,'StatusModifierDisplayTextLite')]]"));
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createMHAEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName) {
        return FilterBuilder.createMHAEntryFilterWithAdditionalParameters(elementName, domainEntryPoint, startDate, endDate, queryName, null);
    }

    public static Element createMHAEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String specializedDomainEntryPoint) {
        Element element = DocumentHelper.createElement((String)elementName);
        String specializedName = "filter:defaultDomainEntryPointFilter";
        if (specializedDomainEntryPoint != null) {
            specializedName = specializedDomainEntryPoint;
        }
        Element specialized = DocumentHelper.createElement((String)specializedName);
        specialized.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        element.add(specialized);
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createMHAEntryFilterWithAdditionalParametersNoEndDate(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName) {
        return FilterBuilder.createMHAEntryFilterWithAdditionalParametersNoEndDate(elementName, domainEntryPoint, startDate, endDate, queryName, null);
    }

    public static Element createMHAEntryFilterWithAdditionalParametersNoEndDate(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String specializedDomainEntryPoint) {
        Element element = DocumentHelper.createElement((String)elementName);
        String specializedName = "filter:defaultDomainEntryPointFilter";
        if (specializedDomainEntryPoint != null) {
            specializedName = specializedDomainEntryPoint;
        }
        Element specialized = DocumentHelper.createElement((String)specializedName);
        specialized.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        element.add(specialized);
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            if (endDate != null) {
                element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
            }
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createOutpatientMedicationPromiseEntryFilterWithAdditionalParametersAndTimeout(String elementName, String domainEntryPoint, String startDate, String endDate, String queryName, String queryTimeoutSeconds) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (queryTimeoutSeconds != null) {
            element.add(FilterBuilder.createDateParameter("queryTimeoutSeconds ", queryTimeoutSeconds));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createOutpatientMedicationPromiseEntryFilterWithAdditionalQueryParameters(String elementName, String domainEntryPoint, String identity, String namespaceId, String universalId, String universalIdType, String queryName, String queryTimeoutSeconds) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        element.add(FilterBuilder.createRecordIdentifier("recordIdentifiers", identity, namespaceId, universalId, universalIdType));
        if (queryTimeoutSeconds != null) {
            element.add(FilterBuilder.createDateParameter(QUERY_TIMEOUT_SECONDS, queryTimeoutSeconds));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createNonVaMedEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String statusValue, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (null != statusValue && statusValue.length() > 0) {
            element.add(FilterBuilder.createNonVaMedAdditionalParameters(OTHERQUERYPARAMETERS, statusValue));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createAppointmentEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String statusValue, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        } else if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        } else if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (null != statusValue && statusValue.length() > 0) {
            element.add(FilterBuilder.createAppointmentAdditionalParameters(OTHERQUERYPARAMETERS, statusValue));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createEntryFilterWithRecordIdentifiers(String elementName, String domainEntryPoint, String identity, String namespaceId, String universalId, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        element.add(FilterBuilder.createEntityIdentifier("recordIdentifiers", identity, namespaceId, universalId));
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createEntryFilterWithRecordIdentifiers(String elementName, String domainEntryPoint, String identity, String namespaceId, String universalId, String universalIdType, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (domainEntryPoint.equals("PatientAlert")) {
            Element startDateElement = DocumentHelper.createElement((String)START_DATE_KEY);
            startDateElement.setText(namespaceId);
            element.add(startDateElement);
            element.add(DocumentHelper.createElement((String)OTHERQUERYPARAMETERS));
            element.element(OTHERQUERYPARAMETERS).add(DocumentHelper.createElement((String)"identity").addText(identity));
        } else {
            element.add(FilterBuilder.createEntityIdentifier("recordIdentifiers", identity, namespaceId, universalId, universalIdType));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createEntryFilterWithRecordIdentifiers(String elementName, String domainEntryPoint, String identity, String namespaceId, String universalId, String universalIdType, String queryName, String queryTimeoutSeconds) {
        return FilterBuilder.createEntryFilterWithRecordIdentifiers(elementName, domainEntryPoint, identity, namespaceId, universalId, universalIdType, queryName, null, queryTimeoutSeconds);
    }

    public static Element createEntryFilterWithRecordIdentifiers(String elementName, String domainEntryPoint, String identity, String namespaceId, String universalId, String universalIdType, String queryName, String patientCentric, String queryTimeoutSeconds) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        element.add(FilterBuilder.createEntityIdentifier("recordIdentifiers", identity, namespaceId, universalId, universalIdType));
        if (queryTimeoutSeconds != null) {
            element.add(DocumentHelper.createElement((String)QUERY_TIMEOUT_SECONDS).addText(queryTimeoutSeconds));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        element.addAttribute(PATIENT_CENTRIC_KEY, patientCentric);
        return element;
    }

    public static Element createEntryFilterWithoutIdentifiers(String elementName, String domainEntryPoint, String queryName, String patientCentric, String facilityId, String queryTimeoutSeconds, Map<String, String> optionalParamsMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (queryTimeoutSeconds != null) {
            element.add(DocumentHelper.createElement((String)QUERY_TIMEOUT_SECONDS).addText(queryTimeoutSeconds));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        element.addAttribute(PATIENT_CENTRIC_KEY, patientCentric);
        if (facilityId != null) {
            element.addAttribute(FACILITY_ID_KEY, facilityId);
        }
        if (optionalParamsMap != null) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            for (Map.Entry<String, String> optionalParam : optionalParamsMap.entrySet()) {
                if (optionalParam.getValue() == null || optionalParam.getValue().length() <= 0) continue;
                otherQueryParameters.add(DocumentHelper.createElement((String)optionalParam.getKey()).addText(optionalParam.getValue()));
            }
            element.add(otherQueryParameters);
        }
        return element;
    }

    public static Element createXpathQuery(String elementName, String xpath) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createXPath("xpath", xpath));
        return element;
    }

    public static Element createXPath(String elementName, String xpath) {
        return DocumentHelper.createElement((String)elementName).addText(xpath);
    }

    public static Element createDateParameter(String elementName, String date) {
        return DocumentHelper.createElement((String)elementName).addText(date);
    }

    public static Element createClientRequestInitiationTimeParameter(String elementName, String clientRequestInitiationTime) {
        return DocumentHelper.createElement((String)elementName).addText(clientRequestInitiationTime);
    }

    public static Element createFilterId(String elementName, String filterId) {
        return DocumentHelper.createElement((String)elementName).addText(filterId);
    }

    public static Element createClientRequestInitiationTime(String elementName, String clientRequestInitiationTime) {
        return DocumentHelper.createElement((String)elementName).addText(clientRequestInitiationTime);
    }

    public static Element createClientName(String elementName, String clientName) {
        return DocumentHelper.createElement((String)elementName).addText(clientName);
    }

    public static Element createDomainEntryPoint(String elementName, String domainEntryPoint) {
        return DocumentHelper.createElement((String)elementName).addText(domainEntryPoint);
    }

    public static Element createRecordIdentifier(String elementName, String identity, String namespaceId, String universalId, String universalIdType) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createRecordIdentity("identity", identity));
        element.add(FilterBuilder.createRecordNamespaceId(NAMESPACEID, namespaceId));
        element.add(FilterBuilder.createRecordUniversalId(UNIVERSALID, universalId));
        element.add(FilterBuilder.createRecordUniversalIdType(UNIVERSALIDTYPE, universalIdType));
        return element;
    }

    public static Element createRecordIdentity(String elementName, String identity) {
        return DocumentHelper.createElement((String)elementName).addText(identity);
    }

    public static Element createRecordNamespaceId(String elementName, String namespaceId) {
        return DocumentHelper.createElement((String)elementName).addText(namespaceId);
    }

    public static Element createRecordUniversalId(String elementName, String universalId) {
        return DocumentHelper.createElement((String)elementName).addText(universalId);
    }

    public static Element createRecordUniversalIdType(String elementName, String universalIdType) {
        return DocumentHelper.createElement((String)elementName).addText(universalIdType);
    }

    public static Element createCHDRExcludeIdentifier(String elementName, String assigningAuthority, String assigningFacility) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createChdrAuthority(ASSIGNING_AUTHORITY_KEY, assigningAuthority));
        element.add(FilterBuilder.createChdrFacility(ASSIGNING_FACILITY, assigningFacility));
        return element;
    }

    public static Element createChdrAuthority(String elementName, String assigningAuthority) {
        return DocumentHelper.createElement((String)elementName).addText(assigningAuthority);
    }

    public static Element createChdrFacility(String elementName, String assigningFacility) {
        return DocumentHelper.createElement((String)elementName).addText(assigningFacility);
    }

    public static Element createAdditionalParameters(String elementName, String documentClassValue, String[] documentTypeValues) {
        Element element = DocumentHelper.createElement((String)elementName);
        if (null != documentClassValue && documentClassValue.length() > 0) {
            element.add(FilterBuilder.createDocumentClassValues("documentClass", documentClassValue));
        }
        if (null != documentTypeValues) {
            for (String documentTypeValue : documentTypeValues) {
                element.add(FilterBuilder.createDocumentTypeValues("documentType", documentTypeValue));
            }
        }
        return element;
    }

    public static Element createNonVaMedAdditionalParameters(String elementName, String statusValue) {
        Element element = DocumentHelper.createElement((String)elementName);
        if (null != statusValue && statusValue.length() > 0) {
            element.add(FilterBuilder.createDocumentClassValues("status", statusValue));
        }
        return element;
    }

    public static Element createAppointmentAdditionalParameters(String elementName, String statusValue) {
        Element element = DocumentHelper.createElement((String)elementName);
        if (null != statusValue && statusValue.length() > 0) {
            element.add(FilterBuilder.createDocumentClassValues("appointmentStatus", statusValue));
        }
        return element;
    }

    public static Element createDocumentClassValues(String elementName, String documentClassValue) {
        return DocumentHelper.createElement((String)elementName).addText(documentClassValue);
    }

    public static Element createDocumentTypeValues(String elementName, String DocumentTypeValue) {
        return DocumentHelper.createElement((String)elementName).addText(DocumentTypeValue);
    }

    public static Element createProlemListAdditionalParameters(String elementName, Map<String, String> optionalParamsMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        for (Map.Entry<String, String> optionalParam : optionalParamsMap.entrySet()) {
            if (optionalParam.getValue() == null || optionalParam.getValue().length() <= 0) continue;
            element.add(FilterBuilder.createDocumentClassValues(optionalParam.getKey(), optionalParam.getValue()));
        }
        return element;
    }

    public static Document convertString2Document(String xml) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Element buildVrmFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String statusValue) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (statusValue != null) {
                element.add(FilterBuilder.createVrmEntryFilterWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, statusValue, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static String buildRequestsNExamsFilterElementWithResolvedIdentfiers(String filterId, String clientName, String clientRequestInitiationTime, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, Map<String, String> optionalParamsMap) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", clientName));
        if (clientRequestInitiationTime != null) {
            element.add(FilterBuilder.createClientRequestInitiationTime("clientRequestInitiationTime", clientRequestInitiationTime));
        }
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String endDate;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String string = endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            if (optionalParamsMap != null && optionalParamsMap.size() > 0 || startDate != null || endDate != null) {
                element.add(FilterBuilder.createRequestsNExamsFilterWithAdditionalParameters("entryPointFilter", domainEntryPoint, optionalParamsMap, startDate, endDate, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static Element createRequestsNExamsFilterWithAdditionalParameters(String elementName, String domainEntryPoint, Map<String, String> optionalParamsMap, String startDate, String endDate, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (optionalParamsMap != null) {
            element.add(FilterBuilder.createRequestsNExamsAdditionalParameters(OTHERQUERYPARAMETERS, domainEntryPoint, optionalParamsMap));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createRequestsNExamsAdditionalParameters(String elementName, String domainEntryPoint, Map<String, String> optionalParamsMap) {
        Element element = DocumentHelper.createElement((String)elementName);
        String optionalParamKey = null;
        String optionalParamValue = null;
        if (!optionalParamsMap.isEmpty()) {
            if (domainEntryPoint.equals("ExamRequest2507")) {
                optionalParamKey = "requestStatus";
                optionalParamValue = optionalParamsMap.get("requestStatus");
            } else if (domainEntryPoint.equals("Exam2507")) {
                optionalParamKey = "status";
                optionalParamValue = optionalParamsMap.get("status");
            }
            element.add(FilterBuilder.createDocumentClassValues(optionalParamKey, optionalParamValue));
        }
        return element;
    }

    public static Element buildExamRequestsFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime, String status) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText("VRM 1.0"));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (status != null || startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createExamRequestsDomainEntryPointWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, clientRequestInitiationTime, status, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element buildClinicalRemindersFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime, String status, String token) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText("VRM 1.0"));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (status != null || startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createClinicalRemindersDomainEntryPointWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, clientRequestInitiationTime, status, token, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element createClinicalRemindersDomainEntryPointWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String clientRequestInitiationTime, String status, String token, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
        if (token != null) {
            otherQueryParameters.add(DocumentHelper.createElement((String)"samlToken").addText(token));
        }
        if (otherQueryParameters.hasContent()) {
            element.add(otherQueryParameters);
        }
        if (status != null) {
            if (status.indexOf(",") > 0) {
                String[] statusArray = status.split(",");
                for (int i = 0; i < statusArray.length; ++i) {
                    otherQueryParameters.add(DocumentHelper.createElement((String)"status").addText(statusArray[i]));
                }
            } else {
                otherQueryParameters.add(DocumentHelper.createElement((String)"status").addText(status));
            }
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createExamRequestsDomainEntryPointWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String clientRequestInitiationTime, String status, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (status != null) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            if (status.indexOf(",") > 0) {
                String[] statusArray = status.split(",");
                for (int i = 0; i < statusArray.length; ++i) {
                    otherQueryParameters.add(DocumentHelper.createElement((String)"requestStatus").addText(statusArray[i]));
                }
            } else {
                otherQueryParameters.add(DocumentHelper.createElement((String)"requestStatus").addText(status));
            }
            element.add(otherQueryParameters);
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element createExamRequestsDomainEntryPointWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String clientRequestInitiationTime, ArrayList<String> statusList, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (statusList != null) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            for (String status : statusList) {
                otherQueryParameters.add(DocumentHelper.createElement((String)"requestStatus").addText(status));
            }
            element.add(otherQueryParameters);
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element buildExamsFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime, String status) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText("VRM 1.0"));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (status != null || startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createExamsDomainEntryPointWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, clientRequestInitiationTime, status, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element createExamsDomainEntryPointWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String clientRequestInitiationTime, String status, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (status != null) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            otherQueryParameters.add(DocumentHelper.createElement((String)"status").addText(status));
            element.add(otherQueryParameters);
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static Element buildAppointmentsFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText("VRM 1.0"));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            if (startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createAppointmentsDomainEntryPointWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, clientRequestInitiationTime, queryName, queryTimeoutSeconds));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, queryTimeoutSeconds));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element buildPatientAlertFilterElementWithRequestId(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime, String identity, String namespaceId, String universalId, String universalIdType) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText("Fix The Phones"));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryTimeoutSeconds;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String string = queryTimeoutSeconds = entryFilterMap != null ? entryFilterMap.get(QUERY_TIMEOUT_SECONDS) : null;
            if (startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createEntryFilterWithRecordIdentifiers("entryPointFilter", "PatientAlert", identity, namespaceId, null, null, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, queryTimeoutSeconds));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    private Element createElement(String elementName, String elementValue) {
        return DocumentHelper.createElement((String)elementName).addText(elementValue);
    }

    public static Element buildAppointmentsFilterElementWithResolvedIdentfiersNoClientName(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(DocumentHelper.createElement((String)"clientName").addText(""));
        element.add(FilterBuilder.createDateParameter("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (startDate != null || clientRequestInitiationTime != null) {
                element.add(FilterBuilder.createAppointmentsDomainEntryPointWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, clientRequestInitiationTime, queryName, null));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static Element createAppointmentsDomainEntryPointWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String clientRequestInitiationTime, String queryName, String queryTimeoutSeconds) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        if (queryTimeoutSeconds != null) {
            element.add(DocumentHelper.createElement((String)QUERY_TIMEOUT_SECONDS).addText(queryTimeoutSeconds));
        }
        return element;
    }

    public static Element createVrmEntryFilterWithAdditionalParameters(String elementName, String domainEntryPoint, String startDate, String endDate, String statusValue, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null && endDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (null != statusValue) {
            Element otherQueryParameters = DocumentHelper.createElement((String)OTHERQUERYPARAMETERS);
            otherQueryParameters.add(DocumentHelper.createElement((String)"status").addText(statusValue));
            element.add(otherQueryParameters);
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static String buildNonVaMedFilterWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String statusValue, String clientRequestInitiationTime) {
        Element filter = FilterBuilder.buildNonVaMedFilterElementWithResolvedIdentfiers(filterId, entryPointFilterMaps, resolvedPatients, statusValue, clientRequestInitiationTime);
        return filter.asXML();
    }

    public static Element buildNonVaMedFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String statusValue, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (statusValue != null) {
                element.add(FilterBuilder.createNonVaMedEntryFilterWithAdditionalParameters("entryPointFilter", domainEntryPoint, statusValue, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static String buildAppointmentFilterWithResolvedIdentfiers(String filterId, String clientName, String clientRequestInitiationTime, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String statusValue) {
        Element filter = FilterBuilder.buildAppointmentFilterElementWithResolvedIdentfiers(filterId, clientName, clientRequestInitiationTime, entryPointFilterMaps, resolvedPatients, statusValue);
        return filter.asXML();
    }

    public static Element buildAppointmentFilterElementWithResolvedIdentfiers(String filterId, String clientName, String clientRequestInitiationTime, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String statusValue) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", clientName));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String endDate;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            String startDate = entryFilterMap != null ? entryFilterMap.get(START_DATE_KEY) : null;
            String string = endDate = entryFilterMap != null ? entryFilterMap.get(END_DATE_KEY) : null;
            if (statusValue != null) {
                element.add(FilterBuilder.createAppointmentEntryFilterWithAdditionalParameters("entryPointFilter", domainEntryPoint, startDate, endDate, statusValue, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, startDate, endDate, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }

    public static String buildProblemListFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String startDate, String endDate, Map<String, String> optionalParamsMap, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String queryName;
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String string = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : (queryName = "id_1");
            if (optionalParamsMap != null && optionalParamsMap.size() > 0 || startDate != null || endDate != null) {
                element.add(FilterBuilder.createProblemListFilterWithAdditionalParameters("entryPointFilter", domainEntryPoint, optionalParamsMap, startDate, endDate, queryName));
                continue;
            }
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element.asXML();
    }

    public static Element createProblemListFilterWithAdditionalParameters(String elementName, String domainEntryPoint, Map<String, String> optionalParamsMap, String startDate, String endDate, String queryName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(FilterBuilder.createDomainEntryPoint(DOMAIN_ENTRYPOINT_KEY, domainEntryPoint));
        if (startDate != null) {
            element.add(FilterBuilder.createDateParameter(START_DATE_KEY, startDate));
        }
        if (endDate != null) {
            element.add(FilterBuilder.createDateParameter(END_DATE_KEY, endDate));
        }
        if (optionalParamsMap != null) {
            element.add(FilterBuilder.createProlemListAdditionalParameters(OTHERQUERYPARAMETERS, optionalParamsMap));
        }
        element.addAttribute(QUERY_NAME_KEY, queryName);
        return element;
    }

    public static String build3xOutpatientMedicationPromiseFilterWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Element filter = FilterBuilder.build3xOutpatientMedicationPromiseFilterElementWithResolvedIdentfiers(filterId, entryPointFilterMaps, resolvedPatients, clientRequestInitiationTime);
        return filter.asXML();
    }

    public static Element build3xOutpatientMedicationPromiseFilterElementWithResolvedIdentfiers(String filterId, List<Map<String, String>> entryPointFilterMaps, List<Map<String, String>> resolvedPatients, String clientRequestInitiationTime) {
        Document filterDocument = FilterBuilder.buildEmptyFilterDocument();
        Element element = filterDocument.getRootElement();
        element.add(FilterBuilder.createFilterId("filterId", filterId));
        element.add(FilterBuilder.createClientName("clientName", "testClientName"));
        element.add(FilterBuilder.createClientName("clientRequestInitiationTime", clientRequestInitiationTime));
        element.add(FilterBuilder.createPatientWithResolvedIdentifiers("patients", resolvedPatients));
        for (Map<String, String> entryFilterMap : entryPointFilterMaps) {
            String domainEntryPoint = entryFilterMap.get(DOMAIN_ENTRYPOINT_KEY);
            String queryName = entryFilterMap != null ? (entryFilterMap.get(QUERY_NAME_KEY) != null ? entryFilterMap.get(QUERY_NAME_KEY) : "id_1") : "id_1";
            element.add(FilterBuilder.createEntryFilter("entryPointFilter", domainEntryPoint, null, null, queryName, null, null));
        }
        element.addAttribute("vhimVersion", "Vhim_4_00");
        return element;
    }
}

