/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DBQQuestionnaireResultBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private int IDX;
    private Boolean isCDATA = null;

    public DBQQuestionnaireResultBuilder() {
        this(true);
    }

    public DBQQuestionnaireResultBuilder(boolean isCDATA) {
        this.isCDATA = isCDATA;
    }

    public DBQQuestionnaireResultBuilder(Random random) {
        super(random);
    }

    public List<Element> makeQuestionnaireResults(int number) {
        return this.makeQuestionnaireResults(number, null);
    }

    public List<Element> makeQuestionnaireResults(int number, Element patient) {
        return this.makeQuestionnaireResults(number, patient, true);
    }

    public List<Element> makeQuestionnaireResults(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> questionnaireResults = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            questionnaireResults.add(this.makeQuestionnaireResult("questionnaireResult", patient, updateRecordXml));
        }
        return questionnaireResults;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeQuestionnaireResult("questionnaireResult", personIdentifier);
    }

    public Element makeQuestionnaireResult(String elementName, Element patientIdentifier) {
        return this.makeQuestionnaireResult(elementName, patientIdentifier, false);
    }

    public Element makeQuestionnaireResult(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element questionnaireResult = DocumentHelper.createElement((String)elementName);
        Element patient = null;
        if (patientIdentifier != null) {
            patient = this.createPatientLite("patient");
            patient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            patient.element("identifier").element("assigningFacility").setText(patientIdentifier.elementText("assigningFacility"));
            patient.element("identifier").element("assigningAuthority").setText(patientIdentifier.elementText("assigningAuthority"));
            Element dobElement = patientIdentifier.element("dateOfBirth");
            if (dobElement != null) {
                patient.add(patientIdentifier.element("dateOfBirth").detach());
            }
        }
        questionnaireResult.add(patient);
        Element dateCreated = this.createFixedPointInTime("dateCreated");
        questionnaireResult.add(dateCreated);
        questionnaireResult.addElement("documentType").addText("Document Type");
        questionnaireResult.addElement("initiatingSystem").addText("InitiatingSystem");
        questionnaireResult.add(this.createHL72EntityIdentifier("documentIdentifier", this.IDX));
        questionnaireResult.add(this.createHL72OrganizationIdentifier("facilityIdentifier"));
        questionnaireResult.addElement("approvedFlag").addText("APPROVED");
        questionnaireResult.add(this.createPractitionerParticipationLite("approvedBy", "Approved By Comment", AUTHOR_IDS));
        questionnaireResult.add(this.createPractitionerParticipationLite("author", "Author Comment", AUTHOR_IDS));
        Element eDetailXml = questionnaireResult.addElement("detailXML");
        if (this.isCDATA.booleanValue()) {
            eDetailXml.add(DocumentHelper.createCDATA((String)"<xml>HeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8JbzlpaiHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpairy6XhA_t4QE9KsIMVBx32PSUNmfjwHeuDGvgkCZWnOqd-5RY1Foc7T0L8Jbzlpai01</xml>"));
        } else {
            try {
                eDetailXml.add(DocumentHelper.parseText((String)"<xmlData>Hi</xmlData>").getRootElement());
            }
            catch (DocumentException e) {
                throw new RuntimeException("Error parsing test XML data.", e);
            }
        }
        questionnaireResult.addElement("claimNumber").addElement("root").addText(UUID.randomUUID().toString());
        return questionnaireResult;
    }

    public Element makeQuestionnaireResult(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newQuestionnaireResults = DocumentHelper.createElement((String)"questionnaireResults");
        List<Element> questionnaireResultList = this.makeQuestionnaireResults(countObservations, patientIdentifier, updateRecordXml);
        for (Element questionnaireResult : questionnaireResultList) {
            newQuestionnaireResults.add(questionnaireResult);
        }
        return newQuestionnaireResults;
    }

    @Override
    public String fillPrintBuffer(Object aObject) {
        return null;
    }
}

