/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.builders.BuilderTest;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=SuiteAwareSpringRunner.class)
@ContextConfiguration(locations={"classpath:gov/va/med/cds/testharness/vhim400/builders/buildersTestContext.xml"})
public class ClinicalDataDocumentBuilderTest
extends BuilderTest {
    @Autowired
    ClinicalDataBuilder clinicalDataBuilder;

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointIntoleranceConditionRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("IntoleranceConditionCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointAllergyAssessmentRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("AllergyAssessmentCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointLabRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("LabCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointVitalsRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("VitalsignsCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointPharmacyRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("PharmacyCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateEntryPointTiuRecord() {
        this.printDocumentToSystemOut(this.clinicalDataBuilder.createClinicalData("TiuCreateOrUpdate40060"));
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testGetDomainEntryPoints() throws Exception {
        Set<DomainEntryPoint> entryPointsSet = this.clinicalDataBuilder.getDomainEntryPoints("AllergyAssessmentCreate40020");
        Assert.assertTrue((boolean)entryPointsSet.contains(DomainEntryPoint.AllergyAssessment));
    }
}

