/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.sql;

import gov.va.med.cds.testharness.sql.ExecuteException;
import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.cds.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class SqlPlusRunner {
    private static Log logger = LogFactory.getLog(SqlPlusRunner.class);
    private static final String APPLICATION_NAME = "CDS";

    public void execute(String primaryConnectionString, Resource sqlResource) throws ExecuteException {
        try {
            this.execute(primaryConnectionString, sqlResource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new ExecuteException(e);
        }
    }

    public void execute(String primaryConnectionString, String sqlFilePath) throws ExecuteException {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("sqlplus", "-s", primaryConnectionString, "@" + sqlFilePath);
            this.startProcessBuilder(processBuilder, sqlFilePath);
        }
        catch (Exception io) {
            throw new ExecuteException("Failed to execute sql with file path: " + sqlFilePath, io);
        }
    }

    public void execute(String primaryConnectionString, String sqlFilePath, String parameter) throws ExecuteException {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("sqlplus", "-s", primaryConnectionString, "@" + sqlFilePath, parameter);
            this.startProcessBuilder(processBuilder, sqlFilePath);
        }
        catch (Exception io) {
            throw new ExecuteException("Failed to execute sql with file path: " + sqlFilePath, io);
        }
    }

    private void startProcessBuilder(ProcessBuilder processBuilder, String sqlFilePath) throws ExecuteException {
        try {
            Process p = processBuilder.start();
            p.getOutputStream().close();
            InputStream output = p.getInputStream();
            String msgString = StreamUtil.streamToString((InputStream)output);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sqlFilePath);
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msgString));
            }
            if (msgString.contains("ORA-")) {
                throw new ExecuteException(msgString);
            }
        }
        catch (IOException io) {
            throw new ExecuteException("Failed to execute sql with file path: " + sqlFilePath, io);
        }
    }
}

