/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.examples;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xml.sax.InputSource;

@RunWith(value=SuiteAwareRunner.class)
public class SimpleJaxpXpathEvaluateTest {
    Map<String, String> namespaceResolver = new HashMap<String, String>();

    @Test
    @Suite(groups={"checkintest"})
    public void testXPathEvaluate() throws XPathExpressionException {
        String inputXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><doc><name>expectedName</name></doc>";
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expression = xpath.compile("/doc/name");
        String result = expression.evaluate(new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><doc><name>expectedName</name></doc>")));
        Assert.assertEquals((Object)result, (Object)"expectedName");
        Assert.assertNotSame((Object)result, (Object)"notTheRightValue");
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testXPathEvaluateTemplateLikeXml() throws Exception {
        String inputXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><template3400:ClinicalData xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:allergies3400=\"Allergies3400\" xmlns:common3400=\"Common3400\" xmlns:template3400=\"Template3400\" errorSection=\"NONE\" templateId=\"CustomStrictAllergiesFullInsertTemplate\" vhimVersion=\"VHIM3400\"><allergies3400:intoleranceCondition>someValue</allergies3400:intoleranceCondition></template3400:ClinicalData>";
        this.namespaceResolver.put("allergies3400", "Allergies3400");
        this.namespaceResolver.put("common3400", "Common3400");
        this.namespaceResolver.put("template3400", "Template3400");
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String arg0) {
                return SimpleJaxpXpathEvaluateTest.this.namespaceResolver.get(arg0);
            }

            @Override
            public String getPrefix(String arg0) {
                return "";
            }

            public Iterator<Object> getPrefixes(String arg0) {
                return null;
            }
        });
        XPathExpression expression = xpath.compile("/template3400:ClinicalData/allergies3400:intoleranceCondition");
        String result = expression.evaluate(new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><template3400:ClinicalData xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:allergies3400=\"Allergies3400\" xmlns:common3400=\"Common3400\" xmlns:template3400=\"Template3400\" errorSection=\"NONE\" templateId=\"CustomStrictAllergiesFullInsertTemplate\" vhimVersion=\"VHIM3400\"><allergies3400:intoleranceCondition>someValue</allergies3400:intoleranceCondition></template3400:ClinicalData>")));
        Assert.assertEquals((Object)result, (Object)"someValue");
        Assert.assertNotSame((Object)result, (Object)"notTheRightValue");
    }
}

