/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.examples;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@RunWith(value=SuiteAwareRunner.class)
public class ResourceLoaderTest {
    private static ResourceLoader loader;

    @BeforeClass
    @Suite(groups={"checkintest"})
    public static void beforeResourceLoaderTestClassSetUp() {
        loader = new DefaultResourceLoader();
    }

    @AfterClass
    @Suite(groups={"checkintest"})
    public static void afterResourceLoaderTestClassTearDown() {
        loader = null;
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testClassPathResourceLoad() throws IOException {
        Resource resource = loader.getResource("classpath:gov/va/med/cds/testharness/examples/ResourceLoaderTest_TestFile.xml");
        Assert.assertNotNull((String)"the class path resource should have been found", (Object)resource);
        String content = StreamUtil.streamToString((InputStream)resource.getInputStream());
        Assert.assertEquals((Object)content, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }
}

