/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness;

import gov.va.med.cds.properties.PropertiesUtil;
import gov.va.med.cds.util.LogMessageUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

public class LoggingAndPropertyConfigurator {
    private static final String LOGGER_CONFIG_PATH = "src/test/resources/log4j2.xml";
    private static final String APPLICATION_NAME = "CDS";

    public String getDefaultLoggingConfigFilePath() {
        return LOGGER_CONFIG_PATH;
    }

    public static void configureLoggingAndProperties(Log logger, String logfilePath) throws FactoryConfigurationError, IOException {
        new PropertiesUtil().loadSystemRunProperties();
        if (logfilePath == null) {
            logfilePath = LOGGER_CONFIG_PATH;
        }
        File logFile = new File(logfilePath);
        String absolutePath = logFile.getAbsolutePath();
        FileInputStream is = new FileInputStream(absolutePath);
        BufferedInputStream bis = new BufferedInputStream(is);
        ConfigurationSource cs = new ConfigurationSource((InputStream)bis);
        XmlConfiguration configuration = new XmlConfiguration(cs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("using log file: " + logFile.getAbsolutePath())));
        }
    }
}

