/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness;

import gov.va.med.cds.testharness.LoggingAndPropertyConfigurator;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlComparatorInterface;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.util.LogMessageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractBaseTest
implements XmlComparatorInterface {
    protected static Log logger = null;
    protected static String logfilePath = null;
    protected static XmlComparator xmlComparator = null;
    protected static LoggingAndPropertyConfigurator configurator = null;
    private static final String APPLICATION_NAME = "CDS";
    protected static String uniquePatientIdentity = null;

    protected AbstractBaseTest(String logPath) {
        this();
        logfilePath = logPath;
    }

    protected AbstractBaseTest() {
    }

    @Override
    public void assertXMLSimilar(String control, String test) throws XmlCompareException {
        XmlComparator.assertXMLSimilar(test, control);
    }

    @BeforeClass
    public static void beforeAbstractInjectionJUnitTestClassSetUp() throws Exception {
        logger = LogFactory.getLog(AbstractBaseTest.class);
        xmlComparator = new XmlComparator();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)"just finished junit4SetUp"));
        }
    }

    @AfterClass
    public static void afterAbstractInjectionJUnitTestTearDown() throws Exception {
        logfilePath = null;
        xmlComparator = null;
        configurator = null;
        logfilePath = null;
    }

    public void setLogfilePath(String logfilePath) {
        AbstractBaseTest.logfilePath = logfilePath;
    }

    public void setXmlComparator(XmlComparator xmlComparator) {
        AbstractBaseTest.xmlComparator = xmlComparator;
    }

    public void setConfigurator(LoggingAndPropertyConfigurator configurator) {
        AbstractBaseTest.configurator = configurator;
    }

    public void setLogger(Log logger) {
        AbstractBaseTest.logger = logger;
    }

    public static void setUniquePatientIdentity(String uniquePatientIdentity) {
        AbstractBaseTest.uniquePatientIdentity = uniquePatientIdentity;
    }
}

