/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7.parser;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.parser.AbstractEscapeSequenceHandler;

public class HexEscapeSequenceHandler
extends AbstractEscapeSequenceHandler {
    private static final String HEX_ESC_SEQ = "X(?:[0-9a-fA-F]{2})+";

    public HexEscapeSequenceHandler(HL7MessageInfo msgInfo) {
        super(msgInfo);
    }

    public String handleSequence(String value) {
        byte[] bytes = new byte[value.length() / 2];
        for (int i = 1; i < value.length(); i += 2) {
            bytes[i / 2] = (byte)(Byte.parseByte(value.substring(i, i + 1), 16) * 16 + Byte.parseByte(value.substring(i + 1, i + 2), 16));
        }
        return new String(bytes);
    }

    public String getSequenceType() {
        return HEX_ESC_SEQ;
    }
}

