/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7.parser;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.parser.AbstractEscapeSequenceHandler;

public class DelimiterEscapeSequenceHandler
extends AbstractEscapeSequenceHandler {
    private HL7MessageInfo msgInfo;

    public DelimiterEscapeSequenceHandler(HL7MessageInfo msgInfo) {
        super(msgInfo);
        this.msgInfo = msgInfo;
    }

    public String handleSequence(String value) {
        char delimiter = value.charAt(0);
        switch (delimiter) {
            case 'F': {
                return this.msgInfo.getFieldDelimeter();
            }
            case 'S': {
                return this.msgInfo.getComponentSeparator();
            }
            case 'T': {
                return this.msgInfo.getSubcomponentSeparator();
            }
            case 'R': {
                return this.msgInfo.getRepetitionSeparator();
            }
            case 'E': {
                return this.msgInfo.getEscapeCharacter();
            }
        }
        return super.handleSequence(value);
    }

    public String getSequenceType() {
        StringBuffer sb = new StringBuffer("[").append("F").append("S").append("T").append("R").append("E").append("]");
        return sb.toString();
    }
}

