/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7;

import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HL7EscapeCharacterDecoder {
    private static final String REGEX_ESC_CHAR = "\\";
    private static final List SPECIAL_CHARS = Arrays.asList("[", "\\", "^", "$", ".", "|", "?", "*", "+", "(", ")");

    public static String decodeString(String s, HL7MessageInfo messageInfo) {
        String esc = messageInfo.getEscapeCharacter();
        String regexField = esc + "F" + esc;
        String decoded = StringHelper.replaceAll(s, regexField, messageInfo.getFieldDelimeter());
        String regexComponent = esc + "S" + esc;
        decoded = StringHelper.replaceAll(decoded, regexComponent, messageInfo.getComponentSeparator());
        String regexSubcomponent = esc + "T" + esc;
        decoded = StringHelper.replaceAll(decoded, regexSubcomponent, messageInfo.getSubcomponentSeparator());
        String regexRepetition = esc + "R" + esc;
        decoded = StringHelper.replaceAll(decoded, regexRepetition, messageInfo.getRepetitionSeparator());
        String regexEscape = esc + "E" + esc;
        decoded = StringHelper.replaceAll(decoded, regexEscape, messageInfo.getEscapeCharacter());
        Pattern hex = Pattern.compile("\\\\X(?:[0-9a-fA-F]{2})+\\\\");
        Matcher matcher = hex.matcher(decoded);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String sub = decoded.substring(matcher.start(), matcher.end());
            matcher.appendReplacement(sb, HL7EscapeCharacterDecoder.hexToBytes(sub));
        }
        matcher.appendTail(sb);
        decoded = sb.toString();
        return decoded;
    }

    private static String escapeRegex(String unEscaped) {
        StringBuilder escaped = new StringBuilder();
        char[] chars = unEscaped.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] - 91 == 0 || chars[i] - 92 == 0 || chars[i] - 94 == 0 || chars[i] - 36 == 0 || chars[i] - 46 == 0 || chars[i] - 124 == 0 || chars[i] - 43 == 0 || chars[i] - 63 == 0 || chars[i] - 42 == 0 || chars[i] - 40 == 0 || chars[i] - 41 == 0) {
                escaped.append(REGEX_ESC_CHAR);
            }
            escaped.append(chars[i]);
        }
        return escaped.toString();
    }

    private static String hexToBytes(String value) {
        value = value.substring(2, value.length() - 1);
        byte[] bytes = new byte[value.length() / 2];
        for (int i = 0; i < value.length(); i += 2) {
            bytes[i / 2] = (byte)(Byte.parseByte(value.substring(i, i + 1), 16) * 16 + Byte.parseByte(value.substring(i + 1, i + 2), 16));
        }
        return new String(bytes);
    }
}

