/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.hl7;

import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class HL7DelimiterEncoder {
    private static Hashtable<String, List> encodingPatternsHash = new Hashtable();
    private static final String FIELD_SEPERATOR = "F";
    private static final String COMPONENT_SEPERATOR = "S";
    private static final String REPETITION_SEPERATOR = "R";
    private static final String ESCAPE_SEPERATOR = "E";
    private static final String SUBCOMPONENT_SEPERATOR = "T";
    private static final int FIELD_SEPERATOR_POSITION = 0;
    private static final int COMPONENT_SEPERATOR_POSITION = 1;
    private static final int REPETITION_SEPERATOR_POSITION = 2;
    private static final int ESCAPE_SEPERATOR_POSITION = 3;
    private static final int SUBCOMPONENT_SEPERATOR_POSITION = 4;
    private static final int HL7_SEPERATORS_LENGTH = 5;
    private static final int ESCAPE_SEPERATOR_INDEX = 255;
    private static final int ENCODING_ARRAY_SIZE = 256;

    public static String encodeHL7Delimiters(String aMessageToEncode, String aHL7MessageSeparators) throws MessageParserException {
        String encodedMessage = "";
        if (aMessageToEncode != null && aMessageToEncode.length() > 0) {
            StringBuffer encodedMessageBuffer = new StringBuffer();
            char[] messageCharArray = aMessageToEncode.toCharArray();
            int lengthOfMessageCharArray = messageCharArray.length;
            ArrayList encodingList = HL7DelimiterEncoder.getEncodingList(aHL7MessageSeparators);
            char escapeSeparatorChar = aHL7MessageSeparators.charAt(3);
            StringBuffer workBuffer = new StringBuffer();
            for (int i = 0; i < lengthOfMessageCharArray; ++i) {
                char messageCharacter = messageCharArray[i];
                if (messageCharacter < '\u0100') {
                    encodedMessageBuffer.append(encodingList.get(messageCharacter));
                    continue;
                }
                workBuffer.setLength(0);
                String hexEquivalent = Integer.toHexString(messageCharacter);
                if (hexEquivalent.length() % 2 != 0) {
                    encodedMessageBuffer.append(HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, "X0" + hexEquivalent, escapeSeparatorChar));
                    continue;
                }
                encodedMessageBuffer.append(HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, "X" + hexEquivalent, escapeSeparatorChar));
            }
            encodedMessage = encodedMessageBuffer.toString();
        }
        return encodedMessage;
    }

    private static ArrayList getEncodingList(String aHL7MessageSeparators) throws MessageParserException {
        ArrayList encodingList = null;
        String hL7MessageSeparators = aHL7MessageSeparators;
        if (null == hL7MessageSeparators || hL7MessageSeparators.length() < 5) {
            throw new MessageParserException("Message separators are a required parameter");
        }
        if (!encodingPatternsHash.containsKey(hL7MessageSeparators)) {
            encodingList = HL7DelimiterEncoder.createEncodingList(hL7MessageSeparators);
            encodingPatternsHash.put(hL7MessageSeparators, encodingList);
        } else {
            encodingList = (ArrayList)encodingPatternsHash.get(hL7MessageSeparators);
        }
        return encodingList;
    }

    private static ArrayList createEncodingList(String aHL7MessageSeparators) throws MessageParserException {
        String hL7MessageSeparators = aHL7MessageSeparators;
        if (null == hL7MessageSeparators || hL7MessageSeparators.length() < 5) {
            throw new MessageParserException("Message separators are a required parameter");
        }
        char escapeSeparatorChar = hL7MessageSeparators.charAt(3);
        char fieldSeparator = hL7MessageSeparators.charAt(0);
        char componentSeparator = hL7MessageSeparators.charAt(1);
        char repetitionSeparator = hL7MessageSeparators.charAt(2);
        char escapeSeparator = hL7MessageSeparators.charAt(3);
        char subComponentSeparator = hL7MessageSeparators.charAt(4);
        ArrayList<String> lookupList = new ArrayList<String>();
        StringBuffer workBuffer = new StringBuffer();
        String hexEquivalent = "";
        for (int count = 0; count < 256; ++count) {
            workBuffer.setLength(0);
            if (count < 32 || count >= 127) {
                hexEquivalent = Integer.toHexString(count);
                if (hexEquivalent.length() == 1) {
                    lookupList.add(HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, "X0" + hexEquivalent, escapeSeparatorChar));
                    continue;
                }
                lookupList.add(HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, "X" + hexEquivalent, escapeSeparatorChar));
                continue;
            }
            lookupList.add("" + (char)count);
        }
        workBuffer.setLength(0);
        lookupList.set(fieldSeparator, HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, FIELD_SEPERATOR, escapeSeparatorChar));
        workBuffer.setLength(0);
        lookupList.set(componentSeparator, HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, COMPONENT_SEPERATOR, escapeSeparatorChar));
        workBuffer.setLength(0);
        lookupList.set(repetitionSeparator, HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, REPETITION_SEPERATOR, escapeSeparatorChar));
        workBuffer.setLength(0);
        lookupList.set(escapeSeparator, HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, ESCAPE_SEPERATOR, escapeSeparatorChar));
        workBuffer.setLength(0);
        lookupList.set(subComponentSeparator, HL7DelimiterEncoder.wrapEscapeSeparator(workBuffer, SUBCOMPONENT_SEPERATOR, escapeSeparatorChar));
        lookupList.set(255, "" + escapeSeparatorChar);
        return lookupList;
    }

    private static String wrapEscapeSeparator(StringBuffer aStringBuffer, String aDataElementToEscape, char aEscapeSeperator) {
        aStringBuffer.append(aEscapeSeperator);
        aStringBuffer.append(aDataElementToEscape);
        aStringBuffer.append(aEscapeSeperator);
        return aStringBuffer.toString();
    }

    public static String reDelimitHL7StringWithNewDelimiters(String aStringToReDelimit, String aOldHL7Delimiters, String aNewHL7Delimiters) throws MessageParserException {
        String reDelimitHL7String = aStringToReDelimit;
        if (reDelimitHL7String != null) {
            String oldHL7MessageSeparators = aOldHL7Delimiters;
            if (null == oldHL7MessageSeparators || oldHL7MessageSeparators.length() < 5) {
                throw new MessageParserException("Original message separators are a required parameter");
            }
            String newHL7MessageSeparators = aNewHL7Delimiters;
            if (null == newHL7MessageSeparators || newHL7MessageSeparators.length() < 5) {
                throw new MessageParserException("New message separators are a required parameter");
            }
            if (!oldHL7MessageSeparators.equals(newHL7MessageSeparators)) {
                StringBuffer keyBuffer = new StringBuffer();
                StringBuffer valueBuffer = new StringBuffer();
                HashMap<String, String> oldToNewMap = new HashMap<String, String>(5);
                HashMap<String, String> newToEscapeMap = new HashMap<String, String>(5);
                char newEscapeSeparatorChar = newHL7MessageSeparators.charAt(3);
                keyBuffer.append(aOldHL7Delimiters.charAt(0));
                valueBuffer.append(aNewHL7Delimiters.charAt(0));
                oldToNewMap.put(keyBuffer.toString(), valueBuffer.toString());
                keyBuffer.setLength(0);
                newToEscapeMap.put(valueBuffer.toString(), HL7DelimiterEncoder.wrapEscapeSeparator(keyBuffer, FIELD_SEPERATOR, newEscapeSeparatorChar));
                keyBuffer.setLength(0);
                valueBuffer.setLength(0);
                keyBuffer.append(aOldHL7Delimiters.charAt(1));
                valueBuffer.append(aNewHL7Delimiters.charAt(1));
                oldToNewMap.put(keyBuffer.toString(), valueBuffer.toString());
                keyBuffer.setLength(0);
                newToEscapeMap.put(valueBuffer.toString(), HL7DelimiterEncoder.wrapEscapeSeparator(keyBuffer, COMPONENT_SEPERATOR, newEscapeSeparatorChar));
                keyBuffer.setLength(0);
                valueBuffer.setLength(0);
                keyBuffer.append(aOldHL7Delimiters.charAt(2));
                valueBuffer.append(aNewHL7Delimiters.charAt(2));
                oldToNewMap.put(keyBuffer.toString(), valueBuffer.toString());
                keyBuffer.setLength(0);
                newToEscapeMap.put(valueBuffer.toString(), HL7DelimiterEncoder.wrapEscapeSeparator(keyBuffer, REPETITION_SEPERATOR, newEscapeSeparatorChar));
                keyBuffer.setLength(0);
                valueBuffer.setLength(0);
                keyBuffer.append(aOldHL7Delimiters.charAt(3));
                valueBuffer.append(aNewHL7Delimiters.charAt(3));
                oldToNewMap.put(keyBuffer.toString(), valueBuffer.toString());
                keyBuffer.setLength(0);
                newToEscapeMap.put(valueBuffer.toString(), HL7DelimiterEncoder.wrapEscapeSeparator(keyBuffer, ESCAPE_SEPERATOR, newEscapeSeparatorChar));
                keyBuffer.setLength(0);
                valueBuffer.setLength(0);
                keyBuffer.append(aOldHL7Delimiters.charAt(4));
                valueBuffer.append(aNewHL7Delimiters.charAt(4));
                oldToNewMap.put(keyBuffer.toString(), valueBuffer.toString());
                keyBuffer.setLength(0);
                newToEscapeMap.put(valueBuffer.toString(), HL7DelimiterEncoder.wrapEscapeSeparator(keyBuffer, SUBCOMPONENT_SEPERATOR, newEscapeSeparatorChar));
                int startingPosition = 0;
                valueBuffer.setLength(0);
                String messageHeaderStartCheck = "MSH" + aOldHL7Delimiters;
                if (reDelimitHL7String.startsWith(messageHeaderStartCheck)) {
                    startingPosition = messageHeaderStartCheck.length();
                    valueBuffer.append("MSH" + aNewHL7Delimiters);
                }
                int messageLength = reDelimitHL7String.length();
                for (int i = startingPosition; i < messageLength; ++i) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(reDelimitHL7String.charAt(i));
                    if (oldToNewMap.containsKey(keyBuffer.toString())) {
                        valueBuffer.append((String)oldToNewMap.get(keyBuffer.toString()));
                        continue;
                    }
                    if (newToEscapeMap.containsKey(keyBuffer.toString())) {
                        valueBuffer.append((String)newToEscapeMap.get(keyBuffer.toString()));
                        continue;
                    }
                    valueBuffer.append(keyBuffer.toString());
                }
                reDelimitHL7String = valueBuffer.toString();
            }
        }
        return reDelimitHL7String;
    }

    public static String replaceCharWithString(String aString, char aChar, String aReplacement) {
        StringBuffer workBuffer = new StringBuffer();
        int messageLength = aString.length();
        for (int i = 0; i < messageLength; ++i) {
            char currentChar = aString.charAt(i);
            if (currentChar == aChar) {
                workBuffer.append(aReplacement);
                continue;
            }
            workBuffer.append(currentChar);
        }
        return workBuffer.toString();
    }

    public static void main(String[] args) {
        StringBuffer data = new StringBuffer();
        String msgFormat = "^~|\\&";
        String result = null;
        long startTime = 0L;
        long endTime = 0L;
        long totalTimeTaken = 0L;
        try {
            String inputMessage = "MSH^~|\\&^field 1-2^field 3|field 3r1|field 3r2^field 4c1~field 4c2s1&field 4c2s2~field 4c3^field 5@6@7^";
            System.out.println("Input  message: " + inputMessage);
            String outputMessage = HL7DelimiterEncoder.reDelimitHL7StringWithNewDelimiters(inputMessage, "^~|\\&", "|^-\\@");
            System.out.println("Output message: " + outputMessage);
            data.append("\uffff").append("\u0fff").append("\u00ff").append("\u000f").append('\uff88');
            data.append('\u00ff').append("H").append('\u00ff');
            data.append("Hello sr^e~e|~q\\a&d:e\u001cv*i k}c]r");
            data.append('\u00ff').append("N").append('\u00ff');
            data.append('\u00ff').append(".sp2").append('\u00ff');
            data.append("^and~the~CDS~t&e&a&m");
            startTime = System.currentTimeMillis();
            for (int i = 0; i < 5000; ++i) {
                result = HL7DelimiterEncoder.encodeHL7Delimiters(data.toString(), msgFormat);
            }
            endTime = System.currentTimeMillis();
            totalTimeTaken = endTime - startTime;
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        System.out.println("\n\nString to encode:\t" + data.toString());
        System.out.println("String Length: " + data.length());
        System.out.println("Encoded result:  \t" + result);
        System.out.println("\n\nTotal time taken for 5000 calls to escapeHL7Delimiters(): " + totalTimeTaken);
    }
}

