/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.xml;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.exception.OperationNotSupportedException;
import gov.va.med.cds.util.ResourceHelper;
import gov.va.med.cds.xml.EntityResolveException;
import gov.va.med.cds.xml.EntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PathReplacementEntityResolver
implements EntityResolver {
    private static Log logger = LogFactory.getLog(PathReplacementEntityResolver.class);
    private String toReplace = null;
    private String replacement = null;
    private ResourceLoader loader = new DefaultResourceLoader();

    public PathReplacementEntityResolver() {
    }

    public PathReplacementEntityResolver(String toReplace, String replacement) {
        this.setToReplace(toReplace);
        this.setReplacement(replacement);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Resource resource = this.findResource(systemId);
        return new InputSource(resource.getInputStream());
    }

    private Resource findResource(String systemId) {
        int indx = systemId.indexOf(this.toReplace);
        if (indx == -1) {
            throw new InitializationException(ErrorCodeEnum.CANNOT_REPLACE_ENTITY_SYSTEM_ID, this.toReplace, systemId);
        }
        String suffix = systemId.substring(indx += this.toReplace.length(), systemId.length());
        String path = "classpath:" + this.replacement + suffix;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replacing entity systemId " + systemId + " with " + path));
        }
        Resource resource = this.loader.getResource(path);
        return resource;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Resource resource = this.findResource(systemId);
        return new DefaultLSInput(resource, publicId, systemId);
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getToReplace() {
        return this.toReplace;
    }

    public void setToReplace(String toReplace) {
        this.toReplace = toReplace;
    }

    private class DefaultLSInput
    implements LSInput {
        private static final String DEFAULT_ENCODING = "UTF-8";
        private Resource resource = null;
        private String publicId = null;
        private String systemId = null;
        private String encoding = null;
        private String stringData = null;
        private Reader characterStream = null;
        private InputStream byteStream = null;
        private String baseUri = null;
        private static final String ENCODING_PROLOG_ELEMENT = "encoding=";

        public DefaultLSInput(Resource resource, String publicId, String systemId) {
            this.resource = resource;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public String getBaseURI() {
            if (this.baseUri == null) {
                try {
                    String path = this.resource.getURL().getPath();
                    int lastSlash = StringUtils.lastIndexOf((String)path, (String)"/");
                    this.baseUri = path.substring(0, lastSlash + 1);
                }
                catch (IOException e) {
                    throw new EntityResolveException(ErrorCodeEnum.CANNOT_GET_BASE_URI, (Throwable)e);
                }
            }
            return this.baseUri;
        }

        public InputStream getByteStream() {
            if (this.byteStream == null) {
                try {
                    return this.resource.getInputStream();
                }
                catch (IOException e) {
                    throw new EntityResolveException(ErrorCodeEnum.CANNOT_GET_BYTE_STREAM, (Throwable)e);
                }
            }
            return this.byteStream;
        }

        public boolean getCertifiedText() {
            throw new OperationNotSupportedException(ErrorCodeEnum.OPERATION_NOT_SUPPORTED, "getCertifiedText");
        }

        public Reader getCharacterStream() {
            if (this.characterStream == null) {
                try {
                    return new InputStreamReader(this.resource.getInputStream());
                }
                catch (IOException e) {
                    throw new EntityResolveException(ErrorCodeEnum.CANNOT_GET_CHARACTER_STREAM, (Throwable)e);
                }
            }
            return this.characterStream;
        }

        public String getEncoding() {
            if (this.encoding == null) {
                try {
                    InputStream stream = this.getByteStream();
                    byte[] bytes = new byte[70];
                    stream.read(bytes, 0, 70);
                    String prolog = new String(bytes);
                    int prefixStart = prolog.indexOf(ENCODING_PROLOG_ELEMENT);
                    if (prefixStart > 0) {
                        int endEncoding = prolog.indexOf(34, prefixStart + ENCODING_PROLOG_ELEMENT.length() + 1);
                        this.encoding = prolog.substring(prefixStart + ENCODING_PROLOG_ELEMENT.length() + 1, endEncoding);
                    } else {
                        this.encoding = DEFAULT_ENCODING;
                    }
                }
                catch (IOException e) {
                    throw new EntityResolveException(ErrorCodeEnum.ENTITY_XML_PARSING_FAILED_TO_DETEREMINE_ENCODING, (Throwable)e);
                }
            }
            return this.encoding;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getStringData() {
            if (this.stringData == null) {
                try {
                    this.stringData = ResourceHelper.resourceToString((Resource)this.resource);
                }
                catch (IOException e) {
                    throw new EntityResolveException(ErrorCodeEnum.CANNOT_GET_STRING_DATA, (Throwable)e);
                }
            }
            return this.stringData;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setBaseURI(String baseUri) {
            this.baseUri = baseUri;
        }

        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        public void setCertifiedText(boolean certifiedText) {
            throw new OperationNotSupportedException(ErrorCodeEnum.OPERATION_NOT_SUPPORTED, "setCertifiedText");
        }

        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

