/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.vdm;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.FilterProcessorInterface;
import gov.va.med.cds.filter.schema.generated.XpathType;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteRequestInterface;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.vdm.VdmException;
import gov.va.med.cds.vdm.VdmFactoryInterface;
import gov.va.med.cds.vdm.VdmManagerInterface;
import gov.va.med.cds.vdm.VhimVersion;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVdmManager
implements VdmManagerInterface {
    private Map<VhimVersion, VdmFactoryInterface> vdmFactoryByVersionMap = null;
    private FilterProcessorInterface filterProcessor;

    @Override
    public Object generateVdmClinicaldata(WriteRequestInterface writeRequest, TemplateMetaDataInterface metaData) {
        VdmFactoryInterface vdmFactory = this.vdmFactoryByVersionMap.get((Object)metaData.getVhimVersion());
        Object vdmTemplate = vdmFactory.create(writeRequest.getRequestData());
        return vdmTemplate;
    }

    @Override
    public Object filterVdmClinicalData(Object vdmTemplate, CdsFilterInterface filter) {
        if (filter.getXpathType() == XpathType.VDM) {
            try {
                vdmTemplate = this.filterProcessor.filterObject(filter, vdmTemplate);
            }
            catch (ValidationException e) {
                throw new VdmException(ErrorCodeEnum.PROBLEM_RUNNING_VDM_FILTER, (Throwable)e, filter.getFilterId());
            }
        }
        return vdmTemplate;
    }

    @Override
    public String generateXml(Object vdmTemplate, TemplateMetaDataInterface metaData) {
        VdmFactoryInterface vdmFactory = this.vdmFactoryByVersionMap.get((Object)metaData.getVhimVersion());
        String result = vdmFactory.createXml(vdmTemplate, metaData);
        return result;
    }

    public void setVdmFactoryByVersionMap(Map<VhimVersion, VdmFactoryInterface> vdmFactoryByVersionMap) {
        this.vdmFactoryByVersionMap = vdmFactoryByVersionMap;
    }

    public void setFilterProcessor(FilterProcessorInterface filterProcessor) {
        this.filterProcessor = filterProcessor;
    }
}

