/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.request;

import gov.va.med.cds.cdm.CdmManagerInterface;
import gov.va.med.cds.cdm.clinicaldata.ClinicalData;
import gov.va.med.cds.exception.CdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandlerFactory;
import gov.va.med.cds.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.filter.CdsFilterFactoryInterface;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.FilterReadRequest;
import gov.va.med.cds.filter.FilterReadResponse;
import gov.va.med.cds.mapping.MapperInterface;
import gov.va.med.cds.request.ErrorResponseInterface;
import gov.va.med.cds.request.ErrorSectionHelperFactory;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.request.MarshalInfo;
import gov.va.med.cds.request.ReadResponseInterface;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteResponseInterface;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.template.TemplateValidatorInterface;
import gov.va.med.cds.template.TemplateWriteRequest;
import gov.va.med.cds.template.TemplateWriteResponse;
import gov.va.med.cds.vdm.VdmManagerInterface;
import gov.va.med.cds.vdm.VhimVersion;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRequestProcessor
implements RequestProcessorInterface {
    private TemplateValidatorInterface templateValidator = null;
    private Map<VhimVersion, MapperInterface> mapperByVersionMap = null;
    private CdmManagerInterface cdmManager = null;
    private CdsFilterFactoryInterface cdsFilterFactory = null;
    private VdmManagerInterface vdmManager = null;
    private Log logger = LogFactory.getLog(TemplateRequestProcessor.class);
    private ExceptionHandlerInterface exceptionHandler = ExceptionHandlerFactory.getInstance().create(TemplateRequestProcessor.class);
    private ErrorSectionHelperFactory errorSectionHelperFactory = null;

    @Override
    public String createData(String request) {
        return this.createClinicalData(request).toXml();
    }

    @Override
    public String updateData(String request) {
        return this.updateClinicalData(request).toXml();
    }

    @Override
    public String appendData(String request) {
        return this.appendClinicalData(request).toXml();
    }

    @Override
    public String deleteData(String request) {
        return this.deleteClinicalData(request).toXml();
    }

    @Override
    public String readData(String templateId, String filterXmlRequest) {
        return this.readClinicalData(templateId, filterXmlRequest).toXml();
    }

    @Override
    public ReadResponseInterface readClinicalData(String templateId, String filterXmlRequest) {
        TemplateMetaDataInterface metaData = null;
        Object vdmClinicalData = null;
        FilterReadResponse readResponse = new FilterReadResponse();
        this.exceptionHandler.clear();
        try {
            FilterReadRequest readRequest = new FilterReadRequest(templateId, filterXmlRequest);
            metaData = this.templateValidator.validate(readRequest);
            CdsFilterInterface filter = this.cdsFilterFactory.create(readRequest, metaData, readResponse);
            ClinicalData cdmClinicalData = this.cdmManager.read(filter, metaData, readResponse);
            MapperInterface mapper = this.mapperByVersionMap.get((Object)metaData.getVhimVersion());
            vdmClinicalData = mapper.mapCdmToVdm(cdmClinicalData);
            vdmClinicalData = this.vdmManager.filterVdmClinicalData(vdmClinicalData, filter);
            readResponse.setReadSuccessful(true);
        }
        catch (CdsBaseException e) {
            try {
                this.exceptionHandler.handleException(e);
            }
            catch (RuntimeException ex) {
                ex.getMessage();
            }
        }
        catch (RuntimeException e) {
            this.exceptionHandler.handleException(e);
        }
        MarshalInfo marshalInfo = this.buildErrorSection(new MarshalInfo<Object>(vdmClinicalData, metaData));
        String marshalledXml = this.vdmManager.generateXml(marshalInfo.getVdmClinicalData(), marshalInfo.getMetaData());
        readResponse.setResult(marshalledXml);
        this.populateErrorResponse(this.exceptionHandler, readResponse);
        return readResponse;
    }

    private MarshalInfo buildErrorSection(MarshalInfo marshalInfo) {
        if (this.exceptionHandler.hasErrors() || marshalInfo.getVdmClinicalData() == null || marshalInfo.getMetaData() == null) {
            ErrorSectionHelperInterface errorSectionHelper = this.errorSectionHelperFactory.getErrorSectionHelper(marshalInfo);
            errorSectionHelper.buildErrorSection(marshalInfo, this.exceptionHandler);
        }
        return marshalInfo;
    }

    @Override
    public WriteResponseInterface createClinicalData(String request) {
        return this.doCUAD(request);
    }

    @Override
    public WriteResponseInterface updateClinicalData(String request) {
        return this.doCUAD(request);
    }

    @Override
    public WriteResponseInterface appendClinicalData(String request) {
        return this.doCUAD(request);
    }

    @Override
    public WriteResponseInterface deleteClinicalData(String request) {
        return this.doCUAD(request);
    }

    private WriteResponseInterface doCUAD(String request) {
        WriteResponseInterface writeResponse = new TemplateWriteResponse();
        this.exceptionHandler.clear();
        try {
            if (request == null) {
                throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_XML_NULL);
            }
            TemplateWriteRequest writeRequest = new TemplateWriteRequest(request);
            TemplateMetaDataInterface metaData = this.templateValidator.validate(writeRequest);
            MapperInterface mapper = this.mapperByVersionMap.get((Object)metaData.getVhimVersion());
            Object vdmClinicalData = this.vdmManager.generateVdmClinicaldata(writeRequest, metaData);
            ClinicalData cdmClinicalData = mapper.mapVdmToCdm(vdmClinicalData);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Performing: " + cdmClinicalData.getRequestType().getType()));
            }
            writeResponse = this.cdmManager.performCRUADOnClinicalData(cdmClinicalData, writeResponse);
            writeResponse.setWriteSuccessful(true);
        }
        catch (RuntimeException e) {
            try {
                this.exceptionHandler.handleException(e);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        MarshalInfo marshalInfo = this.buildErrorSection(new MarshalInfo<Object>(null, null));
        String marshalledXml = this.vdmManager.generateXml(marshalInfo.getVdmClinicalData(), marshalInfo.getMetaData());
        writeResponse.setResult(marshalledXml);
        this.populateErrorResponse(this.exceptionHandler, writeResponse);
        return writeResponse;
    }

    private void populateErrorResponse(ExceptionHandlerInterface exceptionHandler, ErrorResponseInterface errorResponse) {
        errorResponse.setExceptionInfos(exceptionHandler.getExceptionInfoList());
    }

    public void setMapperByVersionMap(Map<VhimVersion, MapperInterface> mapperByVersionMap) {
        this.mapperByVersionMap = mapperByVersionMap;
    }

    public TemplateValidatorInterface getTemplateValidator() {
        return this.templateValidator;
    }

    public void setTemplateValidator(TemplateValidatorInterface templateValidator) {
        this.templateValidator = templateValidator;
    }

    public void setCdmManager(CdmManagerInterface cdmManager) {
        this.cdmManager = cdmManager;
    }

    public void setCdsFilterFactory(CdsFilterFactoryInterface cdsFilterFactory) {
        this.cdsFilterFactory = cdsFilterFactory;
    }

    public void setVdmManager(VdmManagerInterface vdmManager) {
        this.vdmManager = vdmManager;
    }

    public void setErrorSectionHelperFactory(ErrorSectionHelperFactory errorSectionHelperFactory) {
        this.errorSectionHelperFactory = errorSectionHelperFactory;
    }
}

