/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.request;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.request.MarshalInfo;
import gov.va.med.cds.request.RequestProcessingException;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.template.TemplateMetaDataProviderInterface;
import gov.va.med.cds.vdm.vhim3400.clinicaldata.ClinicalData;
import gov.va.med.cds.vdm.vhim3400.clinicaldata.Error;
import gov.va.med.cds.vdm.vhim3400.clinicaldata.ErrorSection;

public class ErrorSectionHelper3400
implements ErrorSectionHelperInterface {
    private String vhimVersion = null;
    private TemplateMetaDataProviderInterface metaDataProvider = null;

    public String getVhimVersion() {
        return this.vhimVersion;
    }

    public void setVhimVersion(String vhimVersion) {
        this.vhimVersion = vhimVersion;
    }

    public void buildErrorSection(MarshalInfo marshalInfo, ExceptionHandlerInterface exceptionHandler) {
        ClinicalData clinicalData = null;
        TemplateMetaDataInterface metaData = null;
        if (marshalInfo.getVdmClinicalData() != null) {
            if (!(marshalInfo.getVdmClinicalData() instanceof ClinicalData)) {
                throw new RequestProcessingException(ErrorCodeEnum.INVALID_ERROR_SECTION_HELPER_FOR_THIS_VERSION_OF_CLINICAL_DATA);
            }
            clinicalData = (ClinicalData)((Object)marshalInfo.getVdmClinicalData());
        } else {
            clinicalData = new ClinicalData();
        }
        metaData = marshalInfo.getMetaData() != null ? marshalInfo.getMetaData() : this.metaDataProvider.getDefaultResponseTemplateMetaData();
        ErrorSection errorSection = new ErrorSection();
        this.populateErrorSection(errorSection, exceptionHandler);
        clinicalData.setErrors(errorSection);
        marshalInfo.setVdmClinicalData(clinicalData);
        marshalInfo.setMetaData(metaData);
    }

    private void populateErrorSection(ErrorSection errorSection, ExceptionHandlerInterface exceptionHandler) {
        Error error = null;
        LoggingSeverity loggingSeverity = null;
        for (ExceptionInfo exceptionInfo : exceptionHandler.getExceptionInfoList()) {
            error = new Error();
            error.setDisplayMessage(exceptionInfo.getClientMessage());
            error.setException(exceptionInfo.getException().getClass().getName());
            error.setExceptionMessage(exceptionInfo.getExceptionMessage());
            if (exceptionInfo.getErrorCode() != null) {
                error.setErrorCode(exceptionInfo.getErrorCode().toString());
            }
            error.setErrorId(Long.toString(exceptionInfo.getLoggedMessageId()));
            loggingSeverity = exceptionInfo.getLoggingSeverity();
            if (loggingSeverity == null) {
                loggingSeverity = LoggingSeverity.FATAL;
                exceptionInfo.setLoggingSeverity(LoggingSeverity.FATAL);
            }
            switch (loggingSeverity) {
                case WARNING: {
                    errorSection.getWarning().add(error);
                }
                case ERROR: {
                    errorSection.getError().add(error);
                }
            }
            errorSection.getFatalError().add(error);
        }
    }

    public void setMetaDataProvider(TemplateMetaDataProviderInterface metaDataProvider) {
        this.metaDataProvider = metaDataProvider;
    }
}

