/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsDomainFilterRegistryFactory;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.XpathFilterRegistryInterface;
import gov.va.med.cds.filter.schema.generated.Filter;
import gov.va.med.cds.filter.schema.generated.Parameter;
import gov.va.med.cds.filter.schema.generated.QueryPath;
import gov.va.med.cds.filter.schema.generated.XpathType;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.vdm.VhimVersion;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdsFilter
implements CdsFilterInterface {
    public static final DateFormat DATABASE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String CDS_FILTER_PATH = "classpath:gov/va/med/cds/filter/schema/filters1000.xsd";
    private static final String JAXB_FILTER_CONTEXT = "gov.va.med.cds.filter.schema.generated";
    private static XpathFilterRegistryInterface xpathFilterRegistry = CdsDomainFilterRegistryFactory.createCdsDomainFilterRegistry();
    private String filterXml = null;
    private Filter filter = null;
    private String xpath;
    private XpathType xpathType;
    private List<Parameter> xpathParameters;

    public CdsFilter(String aFilterXml) {
        this.setFilterXml(aFilterXml);
    }

    public Filter getFilter() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        return this.filter;
    }

    private void processFilterInstanceDocument(String aFilterDocument) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource resource = resolver.getResource(CDS_FILTER_PATH);
            File filterFile = resource.getFile();
            Schema schema = schemaFactory.newSchema(filterFile);
            JAXBContext jaxbContent = JAXBContext.newInstance((String)JAXB_FILTER_CONTEXT);
            Unmarshaller unmarshaller = jaxbContent.createUnmarshaller();
            unmarshaller.setSchema(schema);
            this.filter = (Filter)unmarshaller.unmarshal((Reader)new StringReader(aFilterDocument));
        }
        catch (JAXBException e) {
            throw new ValidationException(ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, (Throwable)e, aFilterDocument);
        }
        catch (IOException e) {
            throw new ValidationException(ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, (Throwable)e, aFilterDocument);
        }
        catch (SAXException e) {
            throw new ValidationException(ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, (Throwable)e, aFilterDocument);
        }
    }

    private void setFilterXml(String aFilterXml) {
        this.filterXml = aFilterXml;
        this.processFilterInstanceDocument(aFilterXml);
        this.xpath = null;
        this.xpathType = null;
        this.xpathParameters = null;
        Filter.XpathQuery xpathQuery = this.filter.getXpathQuery();
        if (xpathQuery != null) {
            this.xpathType = xpathQuery.getXpathType();
            Filter.XpathQuery.ReferencedXpath referencedXpath = null;
            Filter.XpathQuery.PreparedXpath preparedXpath = xpathQuery.getPreparedXpath();
            if (preparedXpath != null) {
                QueryPath queryPath = preparedXpath.getQueryPath();
                this.xpath = queryPath.getXpath();
                this.xpathParameters = preparedXpath.getParameter();
            } else {
                referencedXpath = xpathQuery.getReferencedXpath();
                if (referencedXpath != null) {
                    String filterId = referencedXpath.getFilterId();
                    if (filterId != null && !filterId.equals("")) {
                        this.xpath = xpathFilterRegistry.getXpathFilter(this.xpathType, filterId);
                        if (this.xpath == null) {
                            throw new ValidationException(ErrorCodeEnum.MISSING_REFERENCE_XPATH_IN_FILTER, filterId);
                        }
                        this.xpathParameters = referencedXpath.getParameter();
                    }
                } else {
                    throw new ValidationException(ErrorCodeEnum.INVALID_XPATH_QUERY);
                }
            }
            if (this.xpath != null && this.xpathType == null) {
                throw new ValidationException(ErrorCodeEnum.MISSING_XPATH_OR_XPATH_TYPE_IN_QUERYPATH_ELEMENT_OF_FILTER);
            }
        }
    }

    @Override
    public String getFilterXml() {
        return this.filterXml;
    }

    @Override
    public String getFilterId() {
        return this.getFilter().getFilterId();
    }

    @Override
    public List<String> getVpids() {
        return this.getFilter().getSubject().getVpid();
    }

    @Override
    public XMLGregorianCalendar getStartDate() {
        return this.getFilter().getStartDate();
    }

    @Override
    public XMLGregorianCalendar getEndDate() {
        return this.getFilter().getEndDate();
    }

    @Override
    public String getFormattedStringStartDate() {
        XMLGregorianCalendar startDate = this.getStartDate();
        String value = null;
        if (startDate != null) {
            value = DATABASE_DATE_FORMAT.format(this.getStartDate().toGregorianCalendar().getTime());
        }
        return value;
    }

    @Override
    public String getFormattedStringEndDate() {
        XMLGregorianCalendar endDate = this.getEndDate();
        String value = null;
        if (endDate != null) {
            value = DATABASE_DATE_FORMAT.format(this.getEndDate().toGregorianCalendar().getTime());
        }
        return value;
    }

    @Override
    public List<String> getRecords() {
        return this.getFilter().getRecord();
    }

    @Override
    public Filter.XpathQuery getXpathQuery() {
        return this.getFilter().getXpathQuery();
    }

    @Override
    public String getEntryPoint() {
        return this.getFilter().getEntryPoint();
    }

    @Override
    public VhimVersion getVhimVersion() {
        return VhimVersion.valueOf(this.getFilter().getVhimVersion());
    }

    @Override
    public XpathType getXpathType() {
        return this.xpathType;
    }

    @Override
    public String getXpath() {
        return this.xpath;
    }

    @Override
    public List<Parameter> getXpathParameters() {
        return this.xpathParameters;
    }
}

