/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.cdm.allergies;

import gov.va.med.cds.cdm.allergies.ReactionObservationEvent;
import gov.va.med.cds.cdm.allergies.SeverityObservationEvent;
import gov.va.med.cds.cdm.common.PractitionerParticipation;
import gov.va.med.cds.cdm.common.ServiceDeliveryLocation;
import gov.va.med.cds.cdm.common.VaPersonId;
import gov.va.med.cds.cdm.datatype.Code;
import gov.va.med.cds.cdm.datatype.EffectiveTime;
import gov.va.med.cds.cdm.datatype.Identity;
import gov.va.med.cds.cdm.datatype.IdentityInterface;
import gov.va.med.cds.cdm.datatype.NullableCode;
import gov.va.med.cds.cdm.history.StatusHistory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntoleranceCondition
implements Serializable,
IdentityInterface {
    private static final long serialVersionUID = -779118826671824577L;
    private Long allergyId;
    private Identity identity;
    private Code informationSourceCategoryCode;
    private NullableCode mechanismCode;
    private Code agentCode;
    private Code statusCode;
    private VaPersonId patient;
    private ServiceDeliveryLocation serviceLocation;
    private EffectiveTime observationTime;
    private SeverityObservationEvent severityObservationEvent;
    private Set<StatusHistory> statusHistory;
    private Set<PractitionerParticipation> practitionerParticipations;
    private Set<ReactionObservationEvent> reactionObservationEvents;
    private Map<Identity, ReactionObservationEvent> reactionObservationEventIdentities;

    public Code getAgentCode() {
        return this.agentCode;
    }

    public void setAgentCode(Code agentCode) {
        this.agentCode = agentCode;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Code getInformationSourceCategoryCode() {
        return this.informationSourceCategoryCode;
    }

    public void setInformationSourceCategoryCode(Code informationSourceCatagoryCode) {
        this.informationSourceCategoryCode = informationSourceCatagoryCode;
    }

    public NullableCode getMechanismCode() {
        return this.mechanismCode;
    }

    public void setMechanismCode(NullableCode mechanismCode) {
        this.mechanismCode = mechanismCode;
    }

    public EffectiveTime getObservationTime() {
        return this.observationTime;
    }

    public void setObservationTime(EffectiveTime observationTime) {
        this.observationTime = observationTime;
    }

    public VaPersonId getPatient() {
        return this.patient;
    }

    public void setPatient(VaPersonId patient) {
        this.patient = patient;
    }

    public ServiceDeliveryLocation getServiceLocation() {
        return this.serviceLocation;
    }

    public void setServiceLocation(ServiceDeliveryLocation aServiceLocation) {
        this.serviceLocation = aServiceLocation;
    }

    public SeverityObservationEvent getSeverityObservationEvent() {
        return this.severityObservationEvent;
    }

    public void setSeverityObservationEvent(SeverityObservationEvent aSeverityObservationEvent) {
        this.severityObservationEvent = aSeverityObservationEvent;
    }

    public Code getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Code statusCode) {
        this.statusCode = statusCode;
    }

    public ReactionObservationEvent getReactionObservationEventByIdentity(Identity aIdentity) {
        return this.getReactionObservationEventIdentities().get(aIdentity);
    }

    public Map<Identity, ReactionObservationEvent> getReactionObservationEventIdentities() {
        if (this.reactionObservationEventIdentities == null) {
            this.reactionObservationEventIdentities = new HashMap<Identity, ReactionObservationEvent>();
        }
        return this.reactionObservationEventIdentities;
    }

    public Set<ReactionObservationEvent> getReactionObservationEvents() {
        if (this.reactionObservationEvents == null) {
            this.reactionObservationEvents = new HashSet<ReactionObservationEvent>();
        }
        return this.reactionObservationEvents;
    }

    public void setReactionObservationEvents(Set<ReactionObservationEvent> aReactionObservationEvents) {
        this.reactionObservationEvents = null;
        this.reactionObservationEventIdentities = null;
        for (ReactionObservationEvent event : aReactionObservationEvents) {
            this.addReactionObservationEvent(event);
        }
    }

    public void addReactionObservationEvent(ReactionObservationEvent aReactionObservationEvent) {
        this.getReactionObservationEvents().add(aReactionObservationEvent);
        this.getReactionObservationEventIdentities().put(aReactionObservationEvent.getIdentity(), aReactionObservationEvent);
    }

    public void addReactionObservationEvents(Set<ReactionObservationEvent> aReactionObservationEvents) {
        for (ReactionObservationEvent event : aReactionObservationEvents) {
            this.addReactionObservationEvent(event);
        }
    }

    public StatusHistory getStatusHistoryUpdate() {
        StatusHistory statusHistory = null;
        Iterator<StatusHistory> iterator = this.getStatusHistory().iterator();
        if (iterator.hasNext()) {
            statusHistory = iterator.next();
        }
        return statusHistory;
    }

    public Set<StatusHistory> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new HashSet<StatusHistory>();
        }
        return this.statusHistory;
    }

    public void setStatusHistory(Set<StatusHistory> aStatusHistory) {
        this.statusHistory = aStatusHistory;
    }

    public void addStatusHistory(StatusHistory aStatusHistory) {
        this.getStatusHistory().add(aStatusHistory);
    }

    public void addStatusHistory(Set<StatusHistory> aStatusHistories) {
        this.getStatusHistory().addAll(aStatusHistories);
    }

    public Set<PractitionerParticipation> getPractitionerParticipations() {
        if (this.practitionerParticipations == null) {
            this.practitionerParticipations = new HashSet<PractitionerParticipation>();
        }
        return this.practitionerParticipations;
    }

    public void setPractitionerParticipations(Set<PractitionerParticipation> aPractitionerParticipations) {
        this.practitionerParticipations = aPractitionerParticipations;
    }

    public void addPractitionerParticipation(PractitionerParticipation aPractitionerParticipation) {
        this.getPractitionerParticipations().add(aPractitionerParticipation);
    }

    public void addPractitionerParticipations(Set<PractitionerParticipation> aPractitionerParticipations) {
        this.getPractitionerParticipations().addAll(aPractitionerParticipations);
    }

    public void setAllergyId(Long allergyId) {
        this.allergyId = allergyId;
    }

    public Long getAllergyId() {
        return this.allergyId;
    }

    public String toString() {
        return "allergyId: " + this.allergyId + ", patient: " + this.patient + ", practitioners: " + this.getPractitionerParticipations();
    }
}

