/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds;

import gov.va.med.cds.client.ClinicalDataSourceSynchronous;
import gov.va.med.cds.request.ReadResponseInterface;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.WriteResponseInterface;
import javax.annotation.PostConstruct;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless
@Remote(value={ClinicalDataSourceSynchronous.class})
public class DefaultClinicalDataSourceSynchronous
implements ClinicalDataSourceSynchronous {
    private Log logger = LogFactory.getLog(DefaultClinicalDataSourceSynchronous.class);
    private RequestProcessorInterface requestProcessor = null;

    @PostConstruct
    public void init() {
        this.logger.debug((Object)"initializing the clinical data service synchronous.");
    }

    public boolean isAlive() {
        return true;
    }

    public String deleteClinicalData(String request) {
        WriteResponseInterface response = this.requestProcessor.deleteClinicalData(request);
        return response.toXml();
    }

    public String readClinicalData(String templateId, String filterXmlRequest) {
        ReadResponseInterface response = this.requestProcessor.readClinicalData(templateId, filterXmlRequest);
        return response.toXml();
    }

    public String updateClinicalData(String request) {
        WriteResponseInterface response = this.requestProcessor.updateClinicalData(request);
        return response.toXml();
    }

    public void setRequestProcessor(RequestProcessorInterface requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public String appendClinicalData(String request) {
        WriteResponseInterface response = this.requestProcessor.appendClinicalData(request);
        return response.toXml();
    }

    public String createClinicalData(String request) {
        WriteResponseInterface response = this.requestProcessor.createClinicalData(request);
        return response.toXml();
    }
}

