/**
 * 
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.testharness.util.XpathAsserterInterface;
import gov.va.med.cds.testharness.xml.XpathAsserterFactory.VHIM_VERSION;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author DNS   egberb
 *
 */
public class XpathAsserterFactoryTest {

	@Test
	public void testXpathAsserterFactoryCreateMethodValidVhimVersion()
	{
		XpathAsserterInterface asserter = XpathAsserterFactory.createXpathAsserter(VHIM_VERSION.VHIM_400);
		Assert.assertNotNull(asserter);
		
	}
	
	@Test ( expected=UnrecognizedVhimVersionException.class )
	public void testXpathAsserterFactoryCreateMethodNullVhimVersion()
	{
		XpathAsserterInterface asserter = XpathAsserterFactory.createXpathAsserter(null);
		Assert.assertNotNull(asserter);
	}
}
