/**
 * 
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.testharness.util.XpathAsserterInterface;
import gov.va.med.cds.testharness.vhim400.Vhim400XpathAsserter;

/**
 * @author DNS   egberb
 *
 */
public class XpathAsserterFactory {
	
	enum VHIM_VERSION { VHIM_400 }; 

	public static XpathAsserterInterface createXpathAsserter(VHIM_VERSION vhimVersion) throws XpathAsserterException
	{
		if( vhimVersion == null )
		{
			throw new UnrecognizedVhimVersionException(vhimVersion);
		}
		
		switch (vhimVersion) {
		case VHIM_400:
			return new Vhim400XpathAsserter();
		default:
			throw new UnrecognizedVhimVersionException(vhimVersion);
		}
			
	}
	
}
