

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class PatientEnteredDailyEventBuilder
    extends
        AbstractEntryPointBuilder
{
    private int IDX;

    private String recordIdentifier;
    
    private String attachmentName;


    public void setRecordIdentifer( String recordIdentifer )
    {
        this.recordIdentifier = recordIdentifer;
    }


    public String getRecordIdentifier( )
    {
        return recordIdentifier;
    }

    
    public void setAttachmentName( String attachmentName )
    {
        this.attachmentName = attachmentName;
    }
    
    
    public String getAttachmentName( )
    {
        return attachmentName;
    }
    

    public PatientEnteredDailyEventBuilder( )
    {
        super();
    }


    public PatientEnteredDailyEventBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public PatientEnteredDailyEventBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makeJournalEntries( int number )
    {
        return makeJournalEntries( number, null );
    }


    public List<Element> makeJournalEntries( int number, Element patient )
    {
        return makeJournalEntries( number, patient, true );
    }


    public List<Element> makeJournalEntries( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makeJournalEntry( "patientjournaling:patientEnteredDailyEventJournalEntry", patient, updateRecordXml ) );
        }

        return journalEntry;
    }


    public List<Element> makeJournalEntries( int number, Element patient, boolean updateRecordXml, String recordIdentifier )
    {
        List<Element> journalEntry = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            journalEntry.add( makeJournalEntry( "patientjournaling:patientEnteredDailyEventJournalEntry", patient, updateRecordXml, recordIdentifier ) );
        }

        return journalEntry;
    }


    public Element makeJournalEntry( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPatientJournalEntry = DocumentHelper.createElement( elementName );

        newPatientJournalEntry.addElement( "eventTitle" ).addText( "ActivityJournal" );

        if ( recordIdentifier == null )
        {
            newPatientJournalEntry.add( createGenericJournalEntryDetails( "genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml, null, null, this.attachmentName ) );
        }
        else
        {
            newPatientJournalEntry.add( createGenericJournalEntryDetails( "genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml, null, recordIdentifier, this.attachmentName ) );
        }

        return newPatientJournalEntry;
    }


    public Element makeJournalEntry( String elementName, Element patientIdentifier, boolean updateRecordXml, String recordIdentifier )
    {
        IDX++ ;

        Element newPatientJournalEntry = DocumentHelper.createElement( elementName );

        Attribute contactLogEntryAttr = DocumentHelper.createAttribute( newPatientJournalEntry, " xmlns:patientjournaling", "PatientJournaling" );
        newPatientJournalEntry.add( contactLogEntryAttr );

        newPatientJournalEntry.addElement( "eventTitle" ).addText( "eventTitle1" );

        newPatientJournalEntry.add( createGenericJournalEntryDetails( "genericJournalEntryDetails", patientIdentifier, IDX, updateRecordXml, null, recordIdentifier, this.attachmentName ) );

        return newPatientJournalEntry;
    }


    public Element makeDailyEventJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element patientJournalEntries = DocumentHelper.createElement( "patientJournalEntries" );
        List<Element> patientJournalEntryList = makeJournalEntries( countObservations, patientIdentifier, updateRecordXml );
        for ( Element patientJournalEntry : patientJournalEntryList )
        {
            patientJournalEntries.add( patientJournalEntry );
        }

        return patientJournalEntries;
    }


    public Element makeDailyEventJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml, String recordIdentifier )
    {
        Element patientJournalEntries = DocumentHelper.createElement( "patientJournalEntries" );
        List<Element> patientJournalEntryList = makeJournalEntries( countObservations, patientIdentifier, updateRecordXml, recordIdentifier );
        for ( Element patientJournalEntry : patientJournalEntryList )
        {
            patientJournalEntries.add( patientJournalEntry );
        }

        return patientJournalEntries;
    }


    public Element makePatientEnteredDailyEventJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        return makeDailyEventJournalEntry( patientIdentifier, countObservations, updateRecordXml );
    }


    public Element makePatientEnteredDailyEventJournalEntry( Element patientIdentifier, int countObservations, boolean updateRecordXml, String recordIdentifier )
    {
        return makeDailyEventJournalEntry( patientIdentifier, countObservations, updateRecordXml, recordIdentifier );
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return null;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        return null;
    }

}
