

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;

import java.util.List;


public class LabBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    private LabBuilder labBuilder = null;


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        buildLabData( clinicalData, cnt, patientIdentifier );
    }


    private void buildLabData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );

        List<Element> labs = labBuilder.makeLabTestPromise( count, patientIdentifier );

        for ( Element lab : labs )
        {
            patient.add( lab );
        }
    }


    public void setLabBuilder( LabBuilder labBuilder )
    {
        this.labBuilder = labBuilder;
    }
}
