

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.Element;


//wrapper for VdmVitalsBuilder
public class HAPatientEnteredVitalSignBuilderFactory
    implements
        HAClinicalDomainBuilderFactoryInterface
{
    private HAVitalsBuilder vitalSignObservationEventBuilder = null;


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildVitalsData( clinicalData, cnt, patientIdentifier );
    }


    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        buildVitalsData( clinicalData, recordIdentifier, recordStatus );
    }


    private void buildVitalsData( Document clinicalData, int count, Element patientIdentifier )
    {
        //determine if we need a record identifier for an Update template else it will be excluded for a create xml	
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );
        boolean updateRecordXml = templateId.getText().endsWith( "Update1" ) ? true : false;

        Element patient = rootElement.element( "patient" );

        Element patientEnteredVitalSigns = vitalSignObservationEventBuilder.makePatientEnteredVitalSign( "patientEnteredVitalSigns",
                        patientIdentifier, count, updateRecordXml );
       
        patient.add( patientEnteredVitalSigns );
    }


    private void buildVitalsData( Document clinicalData, String recordIdentifier, String recordStatus )
    {
        //determine if we need a record identifier for an Update template else it will be excluded for a create xml 
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element( "templateId" );

        Element patient = rootElement.element( "patient" );

        Element patientEnteredVitalSigns = vitalSignObservationEventBuilder.makePatientEnteredVitalSign( "patientEnteredVitalSigns",
                        recordIdentifier, recordStatus );

        patient.add( patientEnteredVitalSigns );
    }

    public void setVitalSignObservationEventBuilder(HAVitalsBuilder vitalSignObservationEventBuilder){
        
        this.vitalSignObservationEventBuilder = vitalSignObservationEventBuilder;
    }

    public void setBuilder( AbstractEntryPointBuilder builder )
    {    
        setVitalSignObservationEventBuilder((HAVitalsBuilder)builder);
    }

}
