

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;


public class HAPainEventBuilder
    extends
        AbstractEntryPointBuilder
{
    private static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private static final String[] PAIN_QUALITIES = { "Aching", "Cramping", "Deep", "Dull" };
    private static final String[] PAIN_TREATMENTS = { "deep-breathing", "exercise", "icing", "medication" };

    private String recordIdentifier;
    private String painEntryDate;
    private int IDX;


    public HAPainEventBuilder( )
    {
        super();
    }


    public HAPainEventBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAPainEventBuilder( String recordIdentifier, String painEntryDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.painEntryDate = painEntryDate;
    }


    public HAPainEventBuilder( Random random )
    {
        super( random );
    }


    public List<Element> makePainEvents( int number )
    {
        return makePainEvents( number, null );
    }


    public List<Element> makePainEvents( int number, Element patient )
    {
        return makePainEvents( number, patient, true );
    }


    public List<Element> makePainEvents( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> painEvents = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
            painEvents.add( makePainEvent( "painEvent", patient, updateRecordXml ) );
        }

        return painEvents;
    }


    @Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makePainEvent( "painEvent", personIdentifier );
    }


    public Element makePainEvent( String elementName, Element patientIdentifier )
    {
        return makePainEvent( elementName, patientIdentifier, false );
    }


    /*
    <xsd:complexType name="PainEvent">
        <xsd:all>
            <xsd:element name="patient" type="common:PatientLite"/>
            <xsd:element name="entryDate" type="basedatatypes:PointInTimeWithPattern"/>
            <xsd:element name="painType" type="xsd:string" minOccurs="0"/>
            <xsd:element name="treatmentUsefulness" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="painLevel" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="painImpactOnMood" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="painInterference" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="sleepRefreshment" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="depressionLevel" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="impactOnFunction" type="common:ZeroToTenRating" minOccurs="0"/>
            <xsd:element name="comments" type="xsd:string" minOccurs="0"/>
            <xsd:element name="painWorsenedBy" type="xsd:string" minOccurs="0"/>
            <xsd:element name="painImprovedBy" type="xsd:string" minOccurs="0"/>
            <xsd:element name="dataEnterer" type="xsd:string"/>
            <xsd:element name="painActivatedBy" type="xsd:string" minOccurs="0"/>
            <xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
            <xsd:element name="painQualityToday" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="painQuality" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <xsd:element name="treatments" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="treatment" type="xsd:string" minOccurs="0" maxOccurs="unbounded"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
            <xsd:element name="painLocations" minOccurs="0">
                <xsd:complexType>
                    <xsd:sequence>
                        <xsd:element name="painLocation" type="xsd:string" minOccurs="0"/>
                    </xsd:sequence>
                </xsd:complexType>
            </xsd:element>
        </xsd:all>
    </xsd:complexType>
     */
    public Element makePainEvent( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPainEvent = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( patientIdentifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );
        }

        newPainEvent.add( newPatient );

        Element newPainEventDate = ( this.painEntryDate != null ) ? createPointInTime( "entryDate", this.painEntryDate ) : createFixedPointInTime( "entryDate" );
        newPainEvent.add( newPainEventDate );

        newPainEvent.addElement( "painType" ).addText( "Acute Pain" );

        newPainEvent.add( createZeroToTenRating( "treatmentUsefulness" ) );
        newPainEvent.add( createZeroToTenRating( "painLevel" ) );
        newPainEvent.add( createZeroToTenRating( "painImpactOnMood" ) );
        newPainEvent.add( createZeroToTenRating( "painInterference" ) );
        newPainEvent.add( createZeroToTenRating( "sleepRefreshment" ) );
        newPainEvent.add( createZeroToTenRating( "depressionLevel" ) );
        newPainEvent.add( createZeroToTenRating( "impactOnFunction" ) );

        newPainEvent.addElement( "comments" ).addText( "comments" );
        newPainEvent.addElement( "painWorsenedBy" ).addText( "painWorsenedBy" );
        newPainEvent.addElement( "painImprovedBy" ).addText( "painImprovedBy" );
        newPainEvent.addElement( "dataEnterer" ).addText( "dataEnterer" );
        newPainEvent.addElement( "painActivatedBy" ).addText( "painActivatedBy" );

        newPainEvent.addElement( "allowAccessByClinicalStaff" ).addText( "true" );

        if ( updateRecordXml )
        {
            if ( recordIdentifier != null )
            {
                Element element = DocumentHelper.createElement( "recordIdentifier" );
                element.addElement( "identity" ).addText( recordIdentifier );
                element.addElement( "namespaceId" ).addText( "NamespaceId" );
                element.addElement( "universalId" ).addText( "UniversalId" );
                element.addElement( "universalIdType" ).addText( "UniversalIdType" );
                newPainEvent.add( element );
            }
            else
            {
                Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", IDX );
                newPainEvent.add( newRecordIdentifier );
            }
        }

        Element painQualities = DocumentHelper.createElement( "painQualityToday" );
        for ( int i = this.recordIdentifier == null ? 0 : 1, j = 0; j < 2; i++ , j++ )
        {
            painQualities.addElement( "painQuality" ).addText( PAIN_QUALITIES[i] );
        }
        newPainEvent.add( painQualities );

        Element treatments = DocumentHelper.createElement( "treatments" );
        for ( int i = this.recordIdentifier == null ? 0 : 1, j = 0; j < 2; i++ , j++ )
        {
            treatments.addElement( "treatment" ).addText( PAIN_TREATMENTS[i] );
        }
        newPainEvent.add( treatments );

        return newPainEvent;
    }


    public Element makePainEvent( String elementName, String recordIdentifier, String recordStatus )
    {
        Element newPainEvents = DocumentHelper.createElement( elementName );
        Element newPainEvent = DocumentHelper.createElement( "painEvent" );

        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
        newPainEvent.add( newRecordIdentifier );

        newPainEvent.addElement( "recordStatus" ).addText( recordStatus );
        newPainEvents.add( newPainEvent );

        return newPainEvents;
    }


    public Element makePainEvent( Element patientIdentifier, int countObservations, boolean updateRecordXml )
    {
        Element newPainEvents = DocumentHelper.createElement( "painEvents" );
        List<Element> painEventList = makePainEvents( countObservations, patientIdentifier, updateRecordXml );
        for ( Element painEvent : painEventList )
        {
            newPainEvents.add( painEvent );
        }

        return newPainEvents;
    }


    @Override
    public String fillPrintBuffer( Object aObject )
    {
        // TODO Auto-generated method stub
        return null;
    }

}
