package gov.va.med.cds.testharness.vhim400.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAPainAssessmentBuilder 
       extends
          AbstractEntryPointBuilder
 {
	private String recordIdentifier;
    private String painAssessmentDate;
    private int IDX;


	
    public HAPainAssessmentBuilder( )
    {
        super();
    }

    public HAPainAssessmentBuilder( String recordIdentifier )
    {
        super();
        this.recordIdentifier = recordIdentifier;
    }


    public HAPainAssessmentBuilder( String recordIdentifier, String painAssessmentDate )
    {
        super();
        this.recordIdentifier = recordIdentifier;
        this.painAssessmentDate = painAssessmentDate;
    }


    public HAPainAssessmentBuilder( Random random )
    {
        super( random );
    }

    public List<Element> makePainAssessments( int number )
    {
        return makePainAssessments( number, null );
    }


    public List<Element> makePainAssessments( int number, Element patient )
    {
        return makePainAssessments( number, patient, true );
    }

	
	
	
	public List<Element> makePainAssessments( int number, Element patient, boolean updateRecordXml )
    {
        List<Element> painAssessment = new ArrayList<Element>( number );
        for ( int i = 0; i < number; i++ )
        {
        	painAssessment.add( makePainAssessment( "painAssessment", patient, updateRecordXml ) );
        }

        return painAssessment;
    }
	
	@Override
    public Element createEntryPointRecord( Element personIdentifier )
    {
        return makePainAssessment( "painAssessment", personIdentifier );
    }


    public Element makePainAssessment( String elementName, Element patientIdentifier )
    {
        return makePainAssessment( elementName, patientIdentifier, false );
    }


	/**
	  <xsd:complexType name="PainAssessment">
	<xsd:all>
		<xsd:element name="patient" type="common:PatientLite"/>
		<xsd:element name="assessmentDate" type="basedatatypes:PointInTime"/>
		<xsd:element name="avgPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="maxPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="minPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="painInterference" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="painImpactOnMood" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="painImpactOnWork" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="decreaseInSocial" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="sleepRefreshment" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="concernOfPainEnding" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="concernOfPainTolerance" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="concernOfExcersizeInjury" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="depressionLevel" type="common:ZeroToTenRating" minOccurs="0"/>
		<xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier"/>
		<xsd:element name="recordUpdateTime" type="basedatatypes:PointInTime" minOccurs="0"/>
		<xsd:element name="recordVersion" type="xsd:integer" minOccurs="0"/>
		<xsd:element name="dataEnterer" type="xsd:string"/>
		<xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
	</xsd:all>
</xsd:complexType>
	
	**/
	public Element makePainAssessment( String elementName, Element patientIdentifier, boolean updateRecordXml )
    {
        IDX++ ;

        Element newPainAssessmentEntry = DocumentHelper.createElement( elementName );

        Element newPatient = createPatientLite( "patient" );
        if ( patientIdentifier != null )
        {
            newPatient.element( "identifier" ).element( "identity" ).setText( patientIdentifier.elementText( "identity" ) );
            newPatient.element( "identifier" ).element( "assigningFacility" ).setText( ASSIGNING_FACILITY_HDR );
            newPatient.element( "identifier" ).element( "assigningAuthority" ).setText( ASSIGNINGAUTHORITY_HDR );
        }

        newPainAssessmentEntry.add( newPatient );
        
        
        Element newAssessmentDate = createFixedPointInTime( "assessmentDate" );
        newPainAssessmentEntry.add( newAssessmentDate );

        
        /*Element newPainAssessmentDate = ( this.painAssessmentDate != null ) ? createPointInTime( "assessmentDate", this.painAssessmentDate ) : createFixedPointInTime( "assessmentDate" );
        newPainAssessmentEntry.add( newPainAssessmentDate );
       */
        //<xsd:element name="avgPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("avgPainLevel"));
        //<xsd:element name="maxPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("maxPainLevel"));
        //<xsd:element name="minPainLevel" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("minPainLevel"));
       // <xsd:element name="painInterference" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("painInterference"));
        //<xsd:element name="painImpactOnMood" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("painImpactOnMood"));
        //<xsd:element name="painImpactOnWork" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("painImpactOnWork"));
        //<xsd:element name="decreaseInSocial" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("decreaseInSocial"));
        //<xsd:element name="sleepRefreshment" type="common:ZeroToTenRating" minOccurs="0"/>      
        newPainAssessmentEntry.add(createZeroToTenRating("sleepRefreshment"));
        //<xsd:element name="concernOfPainEnding" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("concernOfPainEnding"));
        //<xsd:element name="concernOfPainTolerance" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("concernOfPainTolerance"));
        //<xsd:element name="concernOfExcersizeInjury" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("concernOfExerciseInjury"));
        //<xsd:element name="depressionLevel" type="common:ZeroToTenRating" minOccurs="0"/>
        newPainAssessmentEntry.add(createZeroToTenRating("depressionLevel"));
        //<xsd:element name="allowAccessByClinicalStaff" type="xsd:boolean" default="true"/>
        newPainAssessmentEntry.addElement( "allowAccessByClinicalStaff" ).addText( "true" );
        //<xsd:element name="recordIdentifier" type="basedatatypes:HL72EntityIdentifier"/>
        if ( updateRecordXml )
        {
            if ( recordIdentifier != null )
            {
                Element element = DocumentHelper.createElement( "recordIdentifier" );
                element.addElement( "identity" ).addText( recordIdentifier );
                element.addElement( "namespaceId" ).addText( "NamespaceId" );
                element.addElement( "universalId" ).addText( "UniversalId" );
                element.addElement( "universalIdType" ).addText( "UniversalIdType" );
                newPainAssessmentEntry.add( element );
            }
            else
            {
                Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", IDX );
                newPainAssessmentEntry.add( newRecordIdentifier );
            }
        }

        return newPainAssessmentEntry;
    }

	  public Element makePainAssessment( String elementName, String recordIdentifier, String recordStatus )
	    {
	        Element newPainAssessments = DocumentHelper.createElement( elementName );
	        Element newPainAssessment = DocumentHelper.createElement( "painAssessment" );

	        Element newRecordIdentifier = createHL72EntityIdentifier( "recordIdentifier", recordIdentifier );
	        newPainAssessment.add( newRecordIdentifier );

	        newPainAssessment.addElement( "recordStatus" ).addText( recordStatus );
	        newPainAssessments.add( newPainAssessment );

	        return newPainAssessments;
	    }
	  
	  public Element makePainAssessment( Element patientIdentifier, int countObservations, boolean updateRecordXml )
	    {
	        Element newPainAssessments = DocumentHelper.createElement( "painAssessments" );
	        List<Element> painAssessmentList = makePainAssessments( countObservations, patientIdentifier, updateRecordXml );
	        for ( Element painAssessment : painAssessmentList )
	        {
	        	newPainAssessments.add( painAssessment );
	        }

	        return newPainAssessments;
	    }




	@Override
	public String fillPrintBuffer(Object object) {
		String returnString = "";

        if ( ( object != null ) && ( object instanceof Element ) )
        {
            returnString = ( ( Element )object ).asXML();
        }

        return returnString;
    }

	
}
