

package gov.va.med.cds.testharness.vhim400;


import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.OutpatientMedicationPromiseBuilder;
import gov.va.med.cds.testharness.vhim400.builders.OutpatientMedicationPromiseBuilderFactory;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.ElementModifier;
import org.dom4j.io.SAXModifier;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@RunWith(SuiteAwareSpringRunner.class)
@ContextConfiguration(locations = { "classpath:gov/va/med/cds/testharness/vhim400/elementModifierContext.xml" })
public class ExpectedReadResultProjectionTest
{
    
    private ElementModifier vwPharmacyDetailRead40010Modifier;
    
    @Resource
    public void setElementModifier( ElementModifier elementModifier )
    {
        this.vwPharmacyDetailRead40010Modifier = elementModifier;
    }
    
    @Test
    public void testVWPharmacyDetailRead40010FromPharmacyCreateOrUpdate40060( )
    {
        Map<String, DomainEntryPoint> domainEntryPointMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointMap.put( "PharmacyCreateOrUpdate40060", DomainEntryPoint.OutpatientMedicationPromise );
        OutpatientMedicationPromiseBuilderFactory factory = new OutpatientMedicationPromiseBuilderFactory();
        factory.setOutpatientMedicationPromiseBuilder( new OutpatientMedicationPromiseBuilder() );
        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        domainEntryPointsWrappersMap.put( "OutpatientMedicationPromise", factory );

        // Use the builder framework to create a PharmacyCreateOrUpdate40060
        ClinicalDataBuilder builder = new ClinicalDataBuilder();
        builder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );
        builder.setDomainEntryPointsMap( domainEntryPointMap );
        String outpaitientMedicationPromise = builder.createClinicalData( "PharmacyCreateOrUpdate40060", 1 ).asXML();

        SAXModifier modifier = new SAXModifier();
        modifier.addModifier( "/ClinicalData", vwPharmacyDetailRead40010Modifier );

        try
        {
            Document doc = modifier.modify( new StringReader( outpaitientMedicationPromise ) );
        }
        catch ( DocumentException e )
        {
            e.printStackTrace();
        }

    }

}
