

package gov.va.med.cds.testharness.examples.hsqldb;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;


/**
 * Unit tests demonstrating how to use HSQLDB
 */
@RunWith( SuiteAwareRunner.class )
public class LoadUpInMemHsqldbTest
{
    private static Connection c;


    /**
     * Shows how to get an in memory HSQLDB connection
     * @throws ClassNotFoundException
     * @throws SQLException
     */
    @BeforeClass
    public static void beforeLoadUpInMemHsqldbTestSetUp( )
        throws ClassNotFoundException,
            SQLException
    {
        Class.forName( "org.hsqldb.jdbcDriver" );
        c = DriverManager.getConnection( "jdbc:hsqldb:mem:LoadUpInMemHsqldbTest", "sa", "" );
        Assert.assertNotNull( c );

        // Need to configure database with database creation script for hsql
    }


    @AfterClass
    public static void afterLoadUpInMemHsqldbTestTearDown( )
        throws SQLException
    {
        c.close();
        c = null;
    }


    /**
     * This unit test is empty, but it forces the demonstration
     * of the setUp method which shows how to connect to an in RAM HSQLDB
     * Good candidate for re-factoring. R.S.
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testLoadHsqldbIntoMemory( )
        throws SQLException,
            ClassNotFoundException
    {

    }
}
