

package gov.va.med.tfs.persistence;


import static org.junit.Assert.assertNotNull;

import java.util.List;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.tfs.tfdm.FilterMetaData;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/tfs/config/tfrPersistenceContext.xml",
				"classpath:gov/va/med/tfs/config/tfrFilterPersistenceContextTest.xml",
                "classpath:gov/va/med/tfs/config/nonWeblogicTfrDataSourceContext.xml" } )
public class FilterSchemaMappingTest
{
    private static ReadPersistenceManagerInterface readManager;


    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCreateReadPersistenceManager( )
    {
        System.out.println("+++");
        System.out.println( "test created readManager: " + readManager );
        assertNotNull( readManager );
        System.out.println("+++");
    }
    

    private void testCode( String aFilterId )
        throws Exception
    {
        System.out.println( "--- this read manager:" + readManager );
        
        FilterMetaData filter = null;
        System.out.println( "this2: " + this );
        filter = readManager.readFilterData( aFilterId );

        System.out.println( "filter: " + filter );
        System.out.println( "---" );
        
        assertNotNull( filter );
    }


    @Resource
    public void setReadManager( ReadPersistenceManagerInterface aReadManager )
    {
        System.out.println( "***" );
        System.out.println( "thread Id: " + Thread.currentThread().getName() );
        System.out.println( "injected readManager: " + aReadManager );
        System.out.println( "this: " + this );
        System.out.println( "***" );
        readManager = aReadManager;
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void multiReadTest( )
        throws Exception
    {
        testCode( "RDI_IC_RX_SINGLE_PATIENT_FILTER" );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void readActiveTemplateIdsTest( )
        throws Exception
    {
        System.err.println( "enter: -F-F- readActiveFilterIdsTest" );
        
        
        List<String> filters = null;
        
        System.out.println( "this2: " + this );
        
        List<String> vhimVersions = null;
        vhimVersions = readManager.readVhimVersions();
        for ( String vhimVersion : vhimVersions )
        {
            filters = readManager.readActiveFilterIds( vhimVersion );
            System.err.println( "filters for vhim version " + vhimVersion + ": " + filters );
            System.err.println( "-x-x-" );

            assertNotNull( filters );
           
        }
        System.err.println( "exit: -F-F- readActiveFilterIdsTest" );

    }
    
 /*    make a read all filters test
    @Test
    @Suite( groups = { "checkintest" } )
    public void readAllTemplateIdsTest( )
    {
        System.out.println( "-x-x- this read manager:" + readManager );
        
        List<String> templates = null;
        try
        {
            System.out.println( "this2: " + this );
            templates = readManager.readTemplateIds();
        }
        catch ( Exception e )
        {
            System.err.println( "Exception: " + e.getMessage() );
        }
        System.out.println( "templates: " + templates );
        System.out.println( "-x-x-" );

    }
*/
    

}
